/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJG\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2'\u0010\u000f\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b0\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\n0\u0010H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ChangeListRemoveConfirmation;", "", "()V", "checkCanDeleteChangelist", "Lcom/intellij/util/ThreeState;", "project", "Lcom/intellij/openapi/project/Project;", "list", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "explicitly", "", "deleteEmptyInactiveLists", "", "lists", "", "confirm", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "toAsk", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nChangeListRemoveConfirmation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeListRemoveConfirmation.kt\ncom/intellij/openapi/vcs/changes/actions/ChangeListRemoveConfirmation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1603#2,9:83\n1855#2:92\n1856#2:94\n1612#2:95\n1855#2,2:96\n1#3:93\n*S KotlinDebug\n*F\n+ 1 ChangeListRemoveConfirmation.kt\ncom/intellij/openapi/vcs/changes/actions/ChangeListRemoveConfirmation\n*L\n63#1:83,9\n63#1:92\n63#1:94\n63#1:95\n78#1:96,2\n63#1:93\n*E\n"})
public final class ChangeListRemoveConfirmation {
    @NotNull
    public static final ChangeListRemoveConfirmation INSTANCE = new ChangeListRemoveConfirmation();

    private ChangeListRemoveConfirmation() {
    }

    @NotNull
    public final ThreeState checkCanDeleteChangelist(@NotNull Project project2, @NotNull LocalChangeList list2, boolean explicitly) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance(project2).getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        AbstractVcs[] activeVcss = abstractVcsArray;
        boolean confirmationAsked = false;
        boolean removeVetoed = false;
        for (AbstractVcs vcs : activeVcss) {
            ThreeState permission;
            Intrinsics.checkNotNullExpressionValue((Object)vcs.mayRemoveChangeList(list2, explicitly), (String)"mayRemoveChangeList(...)");
            if (permission != ThreeState.UNSURE) {
                confirmationAsked = true;
            }
            if (permission != ThreeState.NO) continue;
            removeVetoed = true;
            break;
        }
        if (!confirmationAsked) {
            return ThreeState.UNSURE;
        }
        if (removeVetoed) {
            return ThreeState.NO;
        }
        return ThreeState.YES;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void deleteEmptyInactiveLists(@NotNull Project project2, @NotNull Collection<? extends LocalChangeList> lists, @NotNull Function1<? super List<? extends LocalChangeList>, Boolean> confirm) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(lists, (String)"lists");
        Intrinsics.checkNotNullParameter(confirm, (String)"confirm");
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager manager = changeListManager;
        List toRemove = new ArrayList();
        List toAsk = new ArrayList();
        Iterable $this$mapNotNull$iv = lists;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LocalChangeList it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LocalChangeList it = (LocalChangeList)element$iv$iv;
            boolean bl2 = false;
            if (manager.getChangeList(it.getId()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (LocalChangeList list2 : (List)destination$iv$iv) {
            if (list2.isDefault()) continue;
            Intrinsics.checkNotNull((Object)list2);
            switch (WhenMappings.$EnumSwitchMapping$0[INSTANCE.checkCanDeleteChangelist(project2, list2, false).ordinal()]) {
                case 1: {
                    toAsk.add(list2);
                    break;
                }
                case 2: {
                    toRemove.add(list2);
                }
            }
        }
        if (!((Collection)toAsk).isEmpty() && ((Boolean)confirm.invoke((Object)toAsk)).booleanValue()) {
            toRemove.addAll(toAsk);
        }
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalChangeList it = (LocalChangeList)element$iv;
            boolean bl = false;
            manager.removeChangeList(it.getName());
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.YES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

