/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.AbstractChangeListAction;
import com.intellij.openapi.vcs.changes.actions.MoveChangesHandler;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction;", "Lcom/intellij/openapi/vcs/changes/actions/AbstractChangeListAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "selectAndShowFile", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "update", "Companion", "intellij.platform.vcs.impl"})
public final class MoveChangesToAnotherListAction
extends AbstractChangeListAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        boolean enabled = project2 != null && ProjectLevelVcsManager.getInstance(project2).hasActiveVcss() && ChangeListManager.getInstance(project2).areChangeListsEnabled() && (!UtilKt.asJBIterable((Iterable)((Iterable)e.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY))).isEmpty() || !((objectArray = (Object[])e.getData(VcsDataKeys.CHANGES)) == null || objectArray.length == 0) || !((objectArray = (Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || objectArray.length == 0));
        AbstractChangeListAction.updateEnabledAndVisible$default(this, e, enabled, false, 4, null);
        objectArray = (Object[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (!(objectArray == null || objectArray.length == 0)) {
            e.getPresentation().setText(ActionsBundle.message((String)"action.ChangesView.Move.Files.text", (Object[])new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        MoveChangesHandler $this$actionPerformed_u24lambda_u240 = new MoveChangesHandler(project2);
        boolean bl = false;
        $this$actionPerformed_u24lambda_u240.addChanges((Change[])e.getData(VcsDataKeys.CHANGES));
        if ($this$actionPerformed_u24lambda_u240.isEmpty()) {
            $this$actionPerformed_u24lambda_u240.addChangesForFiles((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        }
        if ($this$actionPerformed_u24lambda_u240.isEmpty()) {
            VcsBalloonProblemNotifier.showOverChangesView($this$actionPerformed_u24lambda_u240.getProject(), VcsBundle.message("move.to.another.changelist.nothing.selected.notification", new Object[0]), MessageType.INFO, new NamedRunnable[0]);
            return;
        }
        if (!Companion.askAndMove($this$actionPerformed_u24lambda_u240.getProject(), (Collection<? extends Change>)$this$actionPerformed_u24lambda_u240.getChanges(), $this$actionPerformed_u24lambda_u240.getUnversionedFiles())) {
            return;
        }
        if (!((Collection)$this$actionPerformed_u24lambda_u240.getChangedFiles()).isEmpty()) {
            this.selectAndShowFile($this$actionPerformed_u24lambda_u240.getProject(), $this$actionPerformed_u24lambda_u240.getChangedFiles().get(0));
        }
    }

    private final void selectAndShowFile(Project project2, VirtualFile file) {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(project2, "Local Changes");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window = toolWindow;
        if (!window.isVisible()) {
            window.activate(() -> MoveChangesToAnotherListAction.selectAndShowFile$lambda$1(project2, file));
        }
    }

    private static final void selectAndShowFile$lambda$1(Project $project, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        ChangesViewManager.getInstance($project).selectFile($file);
    }

    @JvmStatic
    public static final boolean askAndMove(@NotNull Project project2, @NotNull Collection<? extends Change> changes2, @NotNull List<? extends VirtualFile> unversionedFiles) {
        return Companion.askAndMove(project2, changes2, unversionedFiles);
    }

    @JvmStatic
    @Nullable
    public static final LocalChangeList askTargetChangelist(@NotNull Project project2, @NotNull List<LocalRange> selectedRanges, @NotNull PartialLocalLineStatusTracker tracker) {
        return Companion.askTargetChangelist(project2, selectedRanges, tracker);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J;\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u000b\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018H\u0002J \u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction$Companion;", "", "()V", "askAndMove", "", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "unversionedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "askTargetChangelist", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "selectedRanges", "Lcom/intellij/openapi/vcs/ex/LocalRange;", "tracker", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "affectedLists", "", "sameFileChangeLists", "title", "", "Lorg/jetbrains/annotations/Nls;", "askTargetList", "guessPreferredList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "lists", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nMoveChangesToAnotherListAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveChangesToAnotherListAction.kt\ncom/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n37#2,2:197\n1446#3,5:199\n1446#3,5:204\n1549#3:209\n1620#3,3:210\n766#3:213\n857#3,2:214\n766#3:216\n857#3,2:217\n1#4:219\n*S KotlinDebug\n*F\n+ 1 MoveChangesToAnotherListAction.kt\ncom/intellij/openapi/vcs/changes/actions/MoveChangesToAnotherListAction$Companion\n*L\n77#1:197,2\n96#1:199,5\n98#1:204,5\n114#1:209\n114#1:210,3\n115#1:213\n115#1:214,2\n118#1:216\n118#1:217,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean askAndMove(@NotNull Project project2, @NotNull Collection<? extends Change> changes2, @NotNull List<? extends VirtualFile> unversionedFiles) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(changes2, (String)"changes");
            Intrinsics.checkNotNullParameter(unversionedFiles, (String)"unversionedFiles");
            if (changes2.isEmpty() && unversionedFiles.isEmpty()) {
                return false;
            }
            LocalChangeList targetList = this.askTargetList(project2, changes2);
            if (targetList != null) {
                ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx(project2);
                Intrinsics.checkNotNullExpressionValue((Object)changeListManagerEx, (String)"getInstanceEx(...)");
                ChangeListManagerEx changeListManager = changeListManagerEx;
                Collection<? extends Change> $this$toTypedArray$iv = changes2;
                boolean $i$f$toTypedArray = false;
                Collection<? extends Change> thisCollection$iv = $this$toTypedArray$iv;
                Change[] changeArray = thisCollection$iv.toArray(new Change[0]);
                changeListManager.moveChangesTo(targetList, Arrays.copyOf(changeArray, changeArray.length));
                if (!((Collection)unversionedFiles).isEmpty()) {
                    ScheduleForAdditionAction.Manager.addUnversionedFilesToVcsInBackground(project2, targetList, unversionedFiles);
                }
                return true;
            }
            return false;
        }

        private final ChangeList guessPreferredList(Collection<? extends LocalChangeList> lists) {
            Comparator comparator2 = new Comparator(){

                public final int compare(T a, T b) {
                    LocalChangeList it = (LocalChangeList)a;
                    boolean bl = false;
                    Comparable comparable = it.isDefault() ? (Comparable)Integer.valueOf(-1) : (Comparable)Integer.valueOf(0);
                    it = (LocalChangeList)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(it.isDefault() ? (Comparable)Integer.valueOf(-1) : (Comparable)Integer.valueOf(0)));
                }
            };
            Comparator comparator3 = new Comparator(comparator2){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        LocalChangeList it = (LocalChangeList)a;
                        boolean bl = false;
                        Comparable comparable = it.getChanges().isEmpty() ? (Comparable)Integer.valueOf(-1) : (Comparable)Integer.valueOf(0);
                        it = (LocalChangeList)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(it.getChanges().isEmpty() ? (Comparable)Integer.valueOf(-1) : (Comparable)Integer.valueOf(0)));
                    }
                    return n;
                }
            };
            Comparator<LocalChangeList> comparator4 = ChangesUtil.CHANGELIST_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue(comparator4, (String)"CHANGELIST_COMPARATOR");
            Comparator comparator5 = ComparisonsKt.then((Comparator)comparator3, comparator4);
            return (ChangeList)CollectionsKt.minWithOrNull((Iterable)lists, (Comparator)comparator5);
        }

        /*
         * WARNING - void declaration
         */
        private final LocalChangeList askTargetList(Project project2, Collection<? extends Change> changes2) {
            void destination$iv;
            void $this$flatMapTo$iv;
            Iterable destination$iv2;
            void $this$flatMapTo$iv2;
            ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            Iterable iterable = changes2;
            Collection collection = new LinkedHashSet();
            boolean $i$f$flatMapTo22 = false;
            for (Object element$iv : $this$flatMapTo$iv2) {
                Change it = (Change)element$iv;
                boolean bl = false;
                List<LocalChangeList> list2 = changeListManager2.getChangeLists(it);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getChangeLists(...)");
                Iterable list$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
            }
            Set affectedLists = (Set)destination$iv2;
            destination$iv2 = changes2;
            Collection $i$f$flatMapTo22 = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                Change it = (Change)element$iv;
                boolean bl = false;
                Change fileChange = it instanceof ChangeListChange ? ((ChangeListChange)it).getChange() : it;
                List<LocalChangeList> list3 = changeListManager2.getChangeLists(fileChange);
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getChangeLists(...)");
                Iterable list$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Set sameFileChangeLists = (Set)destination$iv;
            String string2 = ActionsBundle.message((String)"action.ChangesView.Move.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return this.askTargetChangelist(project2, affectedLists, sameFileChangeLists, string2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final LocalChangeList askTargetChangelist(@NotNull Project project2, @NotNull List<LocalRange> selectedRanges, @NotNull PartialLocalLineStatusTracker tracker) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(selectedRanges, (String)"selectedRanges");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            List<LocalChangeList> list2 = changeListManager2.getChangeLists();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChangeLists(...)");
            List<LocalChangeList> allChangelists = list2;
            Iterable $this$map$iv = selectedRanges;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void range;
                LocalRange localRange = (LocalRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(range.getChangelistId());
            }
            Set affectedListIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$filter$iv = allChangelists;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                LocalChangeList list3 = (LocalChangeList)element$iv$iv;
                boolean bl = false;
                if (!affectedListIds.contains(list3.getId())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Set affectedLists = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            Set sameFileChangeListsIds = CollectionsKt.toSet((Iterable)tracker.getAffectedChangeListsIds());
            Iterable $this$filter$iv2 = allChangelists;
            boolean $i$f$filter2 = false;
            Iterable $i$f$filterTo22 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LocalChangeList list4 = (LocalChangeList)element$iv$iv;
                boolean bl = false;
                if (!sameFileChangeListsIds.contains(list4.getId())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            Set sameFileChangeLists = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            String string2 = ActionsBundle.message((String)"action.Vcs.MoveChangedLinesToChangelist.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return this.askTargetChangelist(project2, affectedLists, sameFileChangeLists, string2);
        }

        private final LocalChangeList askTargetChangelist(Project project2, Set<? extends LocalChangeList> affectedLists, Set<? extends LocalChangeList> sameFileChangeLists, String title2) {
            Collection collection;
            Collection collection2;
            ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            List list2 = changeListManager2.getChangeLists();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChangeLists(...)");
            List allChangelists = list2;
            List nonAffectedLists = affectedLists.size() == 1 ? CollectionsKt.minus((Iterable)allChangelists, (Iterable)affectedLists) : allChangelists;
            Collection collection3 = nonAffectedLists;
            if (collection3.isEmpty()) {
                boolean bl = false;
                collection2 = CollectionsKt.listOf((Object)changeListManager2.getDefaultChangeList());
            } else {
                collection2 = collection3;
            }
            List suggestedLists = (List)collection2;
            Collection bl = SetsKt.minus(sameFileChangeLists, (Iterable)affectedLists);
            if (bl.isEmpty()) {
                boolean bl2 = false;
                v3 = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)allChangelists), (Iterable)affectedLists);
            } else {
                v3 = bl = bl;
            }
            if (bl.isEmpty()) {
                boolean bl3 = false;
                collection = nonAffectedLists;
            } else {
                collection = bl;
            }
            Collection preferredList = collection;
            ChangeList defaultSelection = this.guessPreferredList(preferredList);
            ChangeListChooser chooser = new ChangeListChooser(project2, StringUtil.removeEllipsisSuffix((String)title2));
            chooser.setChangeLists(suggestedLists);
            chooser.setDefaultSelection(defaultSelection);
            chooser.show();
            return chooser.getSelectedList();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

