/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.configurable.RecordInfo;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.UriUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u001d\u0010\r\u001a\u00070\t\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001d\u0010\r\u001a\u00070\t\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"RECORD_INFO_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "collectDefaultMappedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "vcsName", "", "getAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "info", "getPresentablePath", "Lcom/intellij/openapi/util/NlsSafe;", "mapping", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "directory", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,563:1\n766#2:564\n857#2,2:565\n1549#2:567\n1620#2,3:568\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanelKt\n*L\n486#1:564\n486#1:565,2\n487#1:567\n487#1:568,3\n*E\n"})
public final class VcsDirectoryConfigurationPanelKt {
    @NotNull
    private static final Comparator<RecordInfo> RECORD_INFO_COMPARATOR;

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> collectDefaultMappedRoots(Project project2, String vcsName) {
        void $this$mapTo$iv$iv;
        VcsRoot it;
        Iterable $this$filterTo$iv$iv;
        List<VcsRoot> list2 = ProjectLevelVcsManagerImpl.getInstanceImpl(project2).getVcsRootObjectsForDefaultMapping();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getVcsRootObjectsForDefaultMapping(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VcsRoot)element$iv$iv;
            boolean bl = false;
            AbstractVcs abstractVcs = it.getVcs();
            if (!Intrinsics.areEqual((Object)(abstractVcs != null ? abstractVcs.getName() : null), (Object)vcsName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VcsRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    private static final String getPresentablePath(Project project2, VcsDirectoryMapping mapping) {
        if (mapping.isDefaultMapping()) {
            String string2 = VcsDirectoryMapping.PROJECT_CONSTANT.get();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
            return string2;
        }
        String string3 = mapping.getDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDirectory(...)");
        return VcsDirectoryConfigurationPanelKt.getPresentablePath(project2, string3);
    }

    private static final String getPresentablePath(Project project2, String directory) {
        VirtualFile baseDir2 = project2.getBaseDir();
        if (baseDir2 == null) {
            String string2 = new File(directory).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            return string2;
        }
        String string3 = UriUtil.trimTrailingSlashes((String)directory);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trimTrailingSlashes(...)");
        File directoryFile = new File(StringsKt.removeSuffix((String)string3, (CharSequence)"\\") + "/");
        File ioBase = new File(baseDir2.getPath());
        if (directoryFile.isAbsolute() && !FileUtil.isAncestor((File)ioBase, (File)directoryFile, (boolean)false)) {
            String string4 = new File(directory).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
            return string4;
        }
        String relativePath = FileUtil.getRelativePath((File)ioBase, (File)directoryFile);
        if (Intrinsics.areEqual((Object)".", (Object)relativePath) || relativePath == null) {
            String string5 = ioBase.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
            return string5;
        }
        return relativePath + " (" + ioBase + ")";
    }

    private static final SimpleTextAttributes getAttributes(RecordInfo info) {
        RecordInfo recordInfo = info;
        if (recordInfo instanceof RecordInfo.InvalidMapping) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"ERROR_ATTRIBUTES");
            return simpleTextAttributes;
        }
        if (recordInfo instanceof RecordInfo.UnregisteredMapping) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_BOLD_ATTRIBUTES");
            return simpleTextAttributes;
        }
        if (recordInfo instanceof RecordInfo.Header) {
            return new SimpleTextAttributes(129, null);
        }
        if (recordInfo instanceof RecordInfo.ValidMapping) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            return simpleTextAttributes;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final /* synthetic */ SimpleTextAttributes access$getAttributes(RecordInfo info) {
        return VcsDirectoryConfigurationPanelKt.getAttributes(info);
    }

    public static final /* synthetic */ String access$getPresentablePath(Project project2, VcsDirectoryMapping mapping) {
        return VcsDirectoryConfigurationPanelKt.getPresentablePath(project2, mapping);
    }

    public static final /* synthetic */ List access$collectDefaultMappedRoots(Project project2, String vcsName) {
        return VcsDirectoryConfigurationPanelKt.collectDefaultMappedRoots(project2, vcsName);
    }

    public static final /* synthetic */ Comparator access$getRECORD_INFO_COMPARATOR$p() {
        return RECORD_INFO_COMPARATOR;
    }

    static {
        Comparator comparator2 = new Comparator(){

            public final int compare(T a, T b) {
                Comparable comparable;
                Comparable comparable2;
                RecordInfo info = (RecordInfo)a;
                boolean bl = false;
                RecordInfo recordInfo = info;
                if (recordInfo instanceof RecordInfo.ValidMapping) {
                    comparable2 = Integer.valueOf(0);
                } else if (recordInfo instanceof RecordInfo.InvalidMapping) {
                    comparable2 = Integer.valueOf(1);
                } else if (recordInfo instanceof RecordInfo.UnregisteredHeader) {
                    comparable2 = Integer.valueOf(2);
                } else if (recordInfo instanceof RecordInfo.UnregisteredMapping) {
                    comparable2 = Integer.valueOf(3);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                info = (RecordInfo)b;
                Comparable comparable3 = comparable2;
                bl = false;
                recordInfo = info;
                if (recordInfo instanceof RecordInfo.ValidMapping) {
                    comparable = Integer.valueOf(0);
                } else if (recordInfo instanceof RecordInfo.InvalidMapping) {
                    comparable = Integer.valueOf(1);
                } else if (recordInfo instanceof RecordInfo.UnregisteredHeader) {
                    comparable = Integer.valueOf(2);
                } else if (recordInfo instanceof RecordInfo.UnregisteredMapping) {
                    comparable = Integer.valueOf(3);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return ComparisonsKt.compareValues((Comparable)comparable3, (Comparable)comparable);
            }
        };
        RECORD_INFO_COMPARATOR = new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    RecordInfo info = (RecordInfo)a;
                    boolean bl = false;
                    Object object = info instanceof RecordInfo.MappingInfo ? (RecordInfo.MappingInfo)info : null;
                    String string2 = object != null && (object = ((RecordInfo.MappingInfo)object).getMapping()) != null ? ((VcsDirectoryMapping)object).getDirectory() : null;
                    info = (RecordInfo)b;
                    Comparable comparable = (Comparable)((Object)string2);
                    bl = false;
                    Object object2 = info instanceof RecordInfo.MappingInfo ? (RecordInfo.MappingInfo)info : null;
                    n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)(object2 != null && (object2 = ((RecordInfo.MappingInfo)object2).getMapping()) != null ? ((VcsDirectoryMapping)object2).getDirectory() : null))));
                }
                return n;
            }
        };
    }
}

