/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListByDateComparator;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VcsRevisionNumberArrayRule
implements GetDataRule {
    VcsRevisionNumberArrayRule() {
    }

    @Nullable
    public Object getData(@NotNull DataProvider dataProvider) {
        List<VcsRevisionNumber> revisionNumbers;
        if (dataProvider == null) {
            VcsRevisionNumberArrayRule.$$$reportNull$$$0(0);
        }
        return !ContainerUtil.isEmpty(revisionNumbers = this.getRevisionNumbers(dataProvider)) ? revisionNumbers.toArray(new VcsRevisionNumber[0]) : null;
    }

    @Nullable
    public List<VcsRevisionNumber> getRevisionNumbers(@NotNull DataProvider dataProvider) {
        List revisions;
        ArrayList committedChangeLists;
        VcsRevisionNumber revisionNumber;
        if (dataProvider == null) {
            VcsRevisionNumberArrayRule.$$$reportNull$$$0(1);
        }
        if ((revisionNumber = (VcsRevisionNumber)VcsDataKeys.VCS_REVISION_NUMBER.getData(dataProvider)) != null) {
            return Collections.singletonList(revisionNumber);
        }
        Object[] changeLists = (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(dataProvider);
        if (changeLists != null && changeLists.length > 0 && !(committedChangeLists = new ArrayList(ContainerUtil.findAll((Object[])changeLists, CommittedChangeList.class))).isEmpty()) {
            ContainerUtil.sort(committedChangeLists, CommittedChangeListByDateComparator.DESCENDING);
            return ContainerUtil.mapNotNull(committedChangeLists, (Function)CommittedChangeListToRevisionNumberFunction.INSTANCE);
        }
        Object[] fileRevisions = (VcsFileRevision[])VcsDataKeys.VCS_FILE_REVISIONS.getData(dataProvider);
        if (fileRevisions != null && !(revisions = ContainerUtil.filter((Object[])fileRevisions, r -> r != VcsFileRevision.NULL)).isEmpty()) {
            return ContainerUtil.mapNotNull((Object[])fileRevisions, (Function)FileRevisionToRevisionNumberFunction.INSTANCE);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataProvider";
        objectArray2[1] = "com/intellij/openapi/vcs/history/VcsRevisionNumberArrayRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRevisionNumbers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CommittedChangeListToRevisionNumberFunction
    implements Function<CommittedChangeList, VcsRevisionNumber> {
        private static final CommittedChangeListToRevisionNumberFunction INSTANCE = new CommittedChangeListToRevisionNumberFunction();

        private CommittedChangeListToRevisionNumberFunction() {
        }

        public VcsRevisionNumber fun(CommittedChangeList changeList) {
            return changeList instanceof VcsRevisionNumberAware ? ((VcsRevisionNumberAware)((Object)changeList)).getRevisionNumber() : null;
        }
    }

    private static final class FileRevisionToRevisionNumberFunction
    implements Function<VcsFileRevision, VcsRevisionNumber> {
        private static final FileRevisionToRevisionNumberFunction INSTANCE = new FileRevisionToRevisionNumberFunction();

        private FileRevisionToRevisionNumberFunction() {
        }

        public VcsRevisionNumber fun(VcsFileRevision fileRevision) {
            return fileRevision.getRevisionNumber();
        }
    }
}

