/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ<\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0016J4\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\b\b\u0002\u0010(\u001a\u00020\u00072\b\b\u0002\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0014J \u0010,\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\fH\u0014J\u0010\u0010/\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0014J<\u00100\u001a\u0002012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u00102\u001a\u00020\u001a2\u0006\u0010$\u001a\u000203H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0014\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/openapi/vcs/ui/CommitIconTableCellRenderer;", "Lcom/intellij/ui/SimpleColoredRenderer;", "Ljavax/swing/table/TableCellRenderer;", "graphColorSupplier", "Lkotlin/Function0;", "Lcom/intellij/ui/JBColor;", "defaultCellHeight", "", "graphLineWidth", "", "(Lkotlin/jvm/functions/Function0;IF)V", "isLastRow", "", "nodeCenterX", "getNodeCenterX", "()I", "nodeCenterY", "getNodeCenterY", "nodeWidth", "getNodeWidth", "rowHeight", "getRowHeight", "setRowHeight", "(I)V", "rowIndex", "customizeRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "hasFocus", "row", "column", "drawCircle", "g", "Ljava/awt/Graphics2D;", "x0", "y0", "circleRadius", "circleColor", "Ljava/awt/Color;", "drawCommitIcon", "drawEdge", "tableRowHeight", "isDownEdge", "drawNode", "getTableCellRendererComponent", "Ljava/awt/Component;", "paintComponent", "Ljava/awt/Graphics;", "intellij.platform.vcs.impl"})
public class CommitIconTableCellRenderer
extends SimpleColoredRenderer
implements TableCellRenderer {
    @NotNull
    private final Function0<JBColor> graphColorSupplier;
    private final int defaultCellHeight;
    private final float graphLineWidth;
    private int rowIndex;
    private boolean isLastRow;
    private int rowHeight;

    public CommitIconTableCellRenderer(@NotNull Function0<? extends JBColor> graphColorSupplier, int defaultCellHeight, float graphLineWidth) {
        Intrinsics.checkNotNullParameter(graphColorSupplier, (String)"graphColorSupplier");
        this.graphColorSupplier = graphColorSupplier;
        this.defaultCellHeight = defaultCellHeight;
        this.graphLineWidth = graphLineWidth;
    }

    public /* synthetic */ CommitIconTableCellRenderer(Function0 function0, int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 22;
        }
        if ((n2 & 4) != 0) {
            f = 1.5f;
        }
        this((Function0<? extends JBColor>)function0, n, f);
    }

    protected int getNodeWidth() {
        return JBUI.scale((int)8);
    }

    protected final int getNodeCenterX() {
        return this.getNodeWidth();
    }

    protected final int getNodeCenterY() {
        return this.defaultCellHeight / 2;
    }

    protected final int getRowHeight() {
        return this.rowHeight;
    }

    protected final void setRowHeight(int n) {
        this.rowHeight = n;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        this.drawCommitIcon((Graphics2D)g);
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@Nullable JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row2, int column) {
        this.clear();
        this.setPaintFocusBorder(false);
        JTable jTable = table;
        boolean editingRow = jTable != null ? jTable.getEditingRow() == row2 : false;
        this.acquireState(table, isSelected && !editingRow, hasFocus && !editingRow, row2, column);
        this.getCellState().updateRenderer((JComponent)((Object)this));
        this.setBorder(null);
        this.rowIndex = row2;
        if (table != null) {
            this.isLastRow = row2 == table.getRowCount() - 1;
            this.rowHeight = table.getRowHeight(row2);
        }
        this.customizeRenderer(table, value2, isSelected, hasFocus, row2, column);
        return (Component)((Object)this);
    }

    public void customizeRenderer(@Nullable JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row2, int column) {
    }

    protected void drawCommitIcon(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int tableRowHeight = this.rowHeight;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawNode(g);
        if (this.rowIndex > 0) {
            this.drawEdge(g, tableRowHeight, false);
        }
        if (!this.isLastRow) {
            this.drawEdge(g, tableRowHeight, true);
        }
    }

    protected void drawNode(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        CommitIconTableCellRenderer.drawCircle$default(this, g, this.getNodeCenterX(), this.getNodeCenterY(), 0, null, 24, null);
    }

    protected void drawCircle(@NotNull Graphics2D g, int x0, int y0, int circleRadius, @NotNull Color circleColor) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)circleColor, (String)"circleColor");
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - circleRadius) + 0.5, (double)(y0 - circleRadius) + 0.5, 2.0 * (double)circleRadius, 2.0 * (double)circleRadius);
        g.setColor(circleColor);
        g.fill(circle);
    }

    public static /* synthetic */ void drawCircle$default(CommitIconTableCellRenderer commitIconTableCellRenderer, Graphics2D graphics2D, int n, int n2, int n3, Color color2, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drawCircle");
        }
        if ((n4 & 8) != 0) {
            n3 = commitIconTableCellRenderer.getNodeWidth() / 2;
        }
        if ((n4 & 0x10) != 0) {
            color2 = (Color)commitIconTableCellRenderer.graphColorSupplier.invoke();
        }
        commitIconTableCellRenderer.drawCircle(graphics2D, n, n2, n3, color2);
    }

    protected void drawEdge(@NotNull Graphics2D g, int tableRowHeight, boolean isDownEdge) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int y1 = this.getNodeCenterY();
        int y2 = isDownEdge ? tableRowHeight : 0;
        int x = this.getNodeCenterX();
        g.setColor((Color)this.graphColorSupplier.invoke());
        g.setStroke(new BasicStroke(this.graphLineWidth, 1, 2));
        g.drawLine(x, y1, x, y2);
    }
}

