/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl;

import com.intellij.history.ActivityId;
import com.intellij.history.ActivityPresentationProvider;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.LocalHistoryFacadeKt;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.platform.lvcs.impl.ActivityData;
import com.intellij.platform.lvcs.impl.ActivityDiffData;
import com.intellij.platform.lvcs.impl.ActivityItem;
import com.intellij.platform.lvcs.impl.ActivityPresentation;
import com.intellij.platform.lvcs.impl.ActivityProvider;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivitySelection;
import com.intellij.platform.lvcs.impl.ChangeActivityItem;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItem;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItemKt;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.ChangeSetSelectionKt;
import com.intellij.platform.lvcs.impl.LabelActivityItem;
import com.intellij.platform.lvcs.impl.LocalHistoryActivityDataKt;
import com.intellij.platform.lvcs.impl.LocalHistoryActivityProviderKt;
import com.intellij.platform.lvcs.impl.diff.ActivityDiffDataWithDifferencesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/platform/lvcs/impl/LocalHistoryActivityProvider;", "Lcom/intellij/platform/lvcs/impl/ActivityProvider;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/history/integration/IdeaGateway;)V", "facade", "Lcom/intellij/history/core/LocalHistoryFacade;", "getProject", "()Lcom/intellij/openapi/project/Project;", "filterActivityList", "", "Lcom/intellij/platform/lvcs/impl/ActivityItem;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "data", "Lcom/intellij/platform/lvcs/impl/ActivityData;", "activityFilter", "", "getActivityItemsChanged", "Lkotlinx/coroutines/flow/Flow;", "", "getPresentation", "Lcom/intellij/platform/lvcs/impl/ActivityPresentation;", "item", "isActivityFilterSupported", "", "isScopeFilterSupported", "loadActivityList", "", "scopeFilter", "loadDiffData", "Lcom/intellij/platform/lvcs/impl/ActivityDiffData;", "selection", "Lcom/intellij/platform/lvcs/impl/ActivitySelection;", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nLocalHistoryActivityProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalHistoryActivityProvider.kt\ncom/intellij/platform/lvcs/impl/LocalHistoryActivityProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1747#2,3:135\n800#2,11:138\n1620#2,3:149\n857#2,2:152\n1#3:154\n*S KotlinDebug\n*F\n+ 1 LocalHistoryActivityProvider.kt\ncom/intellij/platform/lvcs/impl/LocalHistoryActivityProvider\n*L\n53#1:135,3\n61#1:138,11\n61#1:149,3\n80#1:152,2\n*E\n"})
public final class LocalHistoryActivityProvider
implements ActivityProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final IdeaGateway gateway;
    @NotNull
    private final LocalHistoryFacade facade;

    public LocalHistoryActivityProvider(@NotNull Project project2, @NotNull IdeaGateway gateway) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        this.project = project2;
        this.gateway = gateway;
        LocalHistoryFacade localHistoryFacade = LocalHistoryImpl.Companion.getInstanceImpl().getFacade();
        Intrinsics.checkNotNull((Object)localHistoryFacade);
        this.facade = localHistoryFacade;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Flow<Unit> getActivityItemsChanged(@NotNull ActivityScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return LocalHistoryActivityProviderKt.access$onChangeSetFinished(this.facade, this.project, this.gateway, scope2);
    }

    @Override
    @NotNull
    public List<ActivityItem> loadActivityList(@NotNull ActivityScope scope2, @Nullable String scopeFilter) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        List result2 = new ArrayList();
        String string2 = this.project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocationHash(...)");
        String projectId = string2;
        if (scope2 instanceof ActivityScope.File) {
            String path2 = this.gateway.getPathOrUrl(((ActivityScope.File)scope2).getFile());
            this.gateway.registerUnsavedDocuments(this.facade);
            Ref.ObjectRef lastLabel = new Ref.ObjectRef();
            Intrinsics.checkNotNull((Object)path2);
            LocalHistoryFacadeKt.collectChanges(this.facade, projectId, path2, scopeFilter, (Function1<? super ChangeSet, Unit>)((Function1)new Function1<ChangeSet, Unit>((Ref.ObjectRef<ChangeSet>)lastLabel, (List<ActivityItem>)result2, scope2){
                final /* synthetic */ Ref.ObjectRef<ChangeSet> $lastLabel;
                final /* synthetic */ List<ActivityItem> $result;
                final /* synthetic */ ActivityScope $scope;
                {
                    this.$lastLabel = $lastLabel;
                    this.$result = $result;
                    this.$scope = $scope;
                    super(1);
                }

                public final void invoke(@NotNull ChangeSet changeSet) {
                    Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
                    if (changeSet.isSystemLabelOnly()) {
                        return;
                    }
                    if (changeSet.isLabelOnly()) {
                        this.$lastLabel.element = changeSet;
                    } else {
                        if (this.$lastLabel.element != null) {
                            Object object = this.$lastLabel.element;
                            Intrinsics.checkNotNull((Object)object);
                            this.$result.add(ChangeSetActivityItemKt.toActivityItem((ChangeSet)object, this.$scope));
                            this.$lastLabel.element = null;
                        }
                        this.$result.add(ChangeSetActivityItemKt.toActivityItem(changeSet, this.$scope));
                    }
                }
            }));
        } else {
            for (ChangeSet changeSet : this.facade.getChanges$intellij_platform_lvcs_impl()) {
                if (changeSet.isSystemLabelOnly()) continue;
                if (changeSet.isLabelOnly()) {
                    boolean bl;
                    block7: {
                        List<Change> list2 = changeSet.getChanges();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getChanges(...)");
                        Iterable $this$any$iv = list2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Change it = (Change)element$iv;
                                boolean bl2 = false;
                                if (!it.affectsProject(projectId)) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                }
                result2.add(ChangeSetActivityItemKt.toActivityItem(changeSet, scope2));
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Set<ActivityItem> filterActivityList(@NotNull ActivityScope scope2, @NotNull ActivityData data2, @Nullable String activityFilter) {
        void destination$iv;
        void $this$filterTo$iv;
        Object rootEntry;
        void destination$iv2;
        CharSequence $this$mapTo$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)((Object)data2), (String)"data");
        Iterable $this$filterIsInstance$iv = data2.getItems();
        boolean $i$f$filterIsInstance22 = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ChangeSetActivityItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        Collection $i$f$filterIsInstance22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        destination$iv$iv = $this$mapTo$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            void it;
            Object item$iv = destination$iv$iv.next();
            ChangeSetActivityItem changeSetActivityItem = (ChangeSetActivityItem)item$iv;
            void var15_20 = destination$iv2;
            boolean bl = false;
            var15_20.add(it.getId());
        }
        Set changeSets = (Set)destination$iv2;
        $this$mapTo$iv = activityFilter;
        if ($this$mapTo$iv == null || $this$mapTo$iv.length() == 0 || changeSets.isEmpty()) {
            return null;
        }
        ActivityScope.File file = scope2 instanceof ActivityScope.File ? (ActivityScope.File)scope2 : null;
        if (file == null) {
            return null;
        }
        ActivityScope.File fileScope = file;
        Set filteredIds = new LinkedHashSet();
        Function2 processor2 = (Function2)new Function2<Long, String, Boolean>(activityFilter, (Set<Long>)filteredIds){
            final /* synthetic */ String $activityFilter;
            final /* synthetic */ Set<Long> $filteredIds;
            {
                this.$activityFilter = $activityFilter;
                this.$filteredIds = $filteredIds;
                super(2);
            }

            @NotNull
            public final Boolean invoke(long changeSetId, @Nullable String content) {
                String string2 = content;
                boolean bl = string2 != null ? StringsKt.contains((CharSequence)string2, (CharSequence)this.$activityFilter, (boolean)true) : false;
                if (bl) {
                    this.$filteredIds.add(changeSetId);
                }
                return true;
            }
        };
        if (fileScope instanceof ActivityScope.Selection) {
            LocalHistoryActivityDataKt.getSelectionCalculator(data2, this.facade, this.gateway, (ActivityScope.Selection)fileScope, true).processContents((Function2<? super Long, ? super String, Boolean>)processor2);
        } else {
            RootEntry rootEntry2 = LocalHistoryActivityDataKt.getRootEntry(data2, this.gateway).copy();
            Intrinsics.checkNotNullExpressionValue((Object)rootEntry2, (String)"copy(...)");
            rootEntry = rootEntry2;
            String path2 = this.gateway.getPathOrUrl(fileScope.getFile());
            Intrinsics.checkNotNull((Object)path2);
            LocalHistoryFacadeKt.processContents(this.facade, this.gateway, (RootEntry)rootEntry, path2, changeSets, true, (Function2<? super Long, ? super String, Boolean>)processor2);
        }
        rootEntry = data2.getItems();
        Collection path2 = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            ActivityItem it = (ActivityItem)element$iv;
            boolean bl = false;
            if (!(it instanceof ChangeSetActivityItem && filteredIds.contains(((ChangeSetActivityItem)it).getId()))) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    @Override
    @Nullable
    public ActivityDiffData loadDiffData(@NotNull ActivityScope scope2, @NotNull ActivitySelection selection) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        ChangeSetSelection changeSetSelection = ChangeSetSelectionKt.toChangeSetSelection(selection);
        if (changeSetSelection == null) {
            return null;
        }
        ChangeSetSelection changeSetSelection2 = changeSetSelection;
        return ActivityDiffDataWithDifferencesKt.createDiffData(this.facade, this.gateway, scope2, changeSetSelection2, true);
    }

    @Override
    public boolean isScopeFilterSupported(@NotNull ActivityScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return scope2 instanceof ActivityScope.Directory;
    }

    @Override
    public boolean isActivityFilterSupported(@NotNull ActivityScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return scope2 instanceof ActivityScope.SingleFile || scope2 instanceof ActivityScope.Selection;
    }

    @Override
    @Nullable
    public ActivityPresentation getPresentation(@NotNull ActivityItem item2) {
        ActivityPresentation activityPresentation;
        ActivityPresentationProvider provider2;
        ActivityPresentationProvider activityPresentationProvider;
        ActivityId activityId;
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        if (!(item2 instanceof ChangeSetActivityItem)) {
            return null;
        }
        ActivityId activityId2 = activityId = ((ChangeSetActivityItem)item2).getActivityId();
        if (activityId2 != null) {
            ActivityId it = activityId2;
            boolean bl = false;
            activityPresentationProvider = (ActivityPresentationProvider)LocalHistoryActivityProviderKt.getACTIVITY_PRESENTATION_PROVIDER_EP().findFirstSafe(arg_0 -> LocalHistoryActivityProvider.getPresentation$lambda$4$lambda$3((Function1)new Function1<ActivityPresentationProvider, Boolean>(activityId){
                final /* synthetic */ ActivityId $activityId;
                {
                    this.$activityId = $activityId;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ActivityPresentationProvider it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getId(), (Object)this.$activityId.getProviderId());
                }
            }, arg_0));
        } else {
            activityPresentationProvider = null;
        }
        ActivityPresentationProvider activityPresentationProvider2 = provider2 = activityPresentationProvider;
        Icon icon2 = activityPresentationProvider2 != null ? activityPresentationProvider2.getIcon(activityId.getKind()) : null;
        ActivityItem activityItem = item2;
        if (activityItem instanceof ChangeActivityItem) {
            String string2 = ((ChangeSetActivityItem)item2).getName();
            if (string2 == null) {
                string2 = "";
            }
            activityPresentation = new ActivityPresentation(string2, icon2);
        } else if (activityItem instanceof LabelActivityItem) {
            String string3 = ((ChangeSetActivityItem)item2).getName();
            if (string3 == null) {
                string3 = "";
            }
            activityPresentation = new ActivityPresentation(string3, icon2);
        } else {
            activityPresentation = null;
        }
        return activityPresentation;
    }

    private static final boolean getPresentation$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

