/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.DirectoryChangeModel;
import com.intellij.history.integration.ui.views.DirectoryChange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.ChangeSetSelectionKt;
import com.intellij.platform.lvcs.impl.LocalHistoryActivityDataKt;
import com.intellij.platform.lvcs.impl.RevisionId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001H\u0000\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a.\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0014H\u0000\u001a2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0001*\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0000\u00a8\u0006\u0019"}, d2={"getChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "diff", "Lcom/intellij/history/core/revisions/Difference;", "getEntryPath", "", "findEntry", "Lcom/intellij/history/core/tree/Entry;", "Lcom/intellij/history/core/LocalHistoryFacade;", "rootEntry", "Lcom/intellij/history/core/tree/RootEntry;", "revisionId", "Lcom/intellij/platform/lvcs/impl/RevisionId;", "entryPath", "before", "", "getDiff", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "isOldContentUsed", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nDiffUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffUtils.kt\ncom/intellij/platform/lvcs/impl/diff/DiffUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1549#2:55\n1620#2,3:56\n*S KotlinDebug\n*F\n+ 1 DiffUtils.kt\ncom/intellij/platform/lvcs/impl/diff/DiffUtilsKt\n*L\n48#1:55\n48#1:56,3\n*E\n"})
public final class DiffUtilsKt {
    @Nullable
    public static final Entry findEntry(@NotNull LocalHistoryFacade $this$findEntry, @NotNull RootEntry rootEntry, @NotNull RevisionId revisionId, @NotNull String entryPath, boolean before2) {
        Entry entry2;
        Intrinsics.checkNotNullParameter((Object)$this$findEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootEntry, (String)"rootEntry");
        Intrinsics.checkNotNullParameter((Object)revisionId, (String)"revisionId");
        Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
        RevisionId revisionId2 = revisionId;
        if (revisionId2 instanceof RevisionId.ChangeSet) {
            RootEntry rootEntry2 = rootEntry.copy();
            Intrinsics.checkNotNullExpressionValue((Object)rootEntry2, (String)"copy(...)");
            RootEntry rootCopy = rootEntry2;
            String entryPathInChangeSet = $this$findEntry.revertUpToChangeSet(rootCopy, ((RevisionId.ChangeSet)revisionId).getId(), entryPath, before2, true);
            entry2 = rootCopy.findEntry(entryPathInChangeSet);
        } else if (Intrinsics.areEqual((Object)revisionId2, (Object)RevisionId.Current.INSTANCE)) {
            entry2 = rootEntry.findEntry(entryPath);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return entry2;
    }

    @NotNull
    public static final List<Difference> getDiff(@NotNull LocalHistoryFacade $this$getDiff, @NotNull RootEntry rootEntry, @NotNull ChangeSetSelection selection, @NotNull String entryPath, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$getDiff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootEntry, (String)"rootEntry");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
        Entry leftEntry = DiffUtilsKt.findEntry($this$getDiff, rootEntry, ChangeSetSelectionKt.getLeftRevision(selection), entryPath, isOldContentUsed);
        Entry rightEntry = DiffUtilsKt.findEntry($this$getDiff, rootEntry, ChangeSetSelectionKt.getRightRevision(selection), entryPath, isOldContentUsed);
        List<Difference> list2 = Entry.getDifferencesBetween(leftEntry, rightEntry, ChangeSetSelectionKt.getRightRevision(selection) instanceof RevisionId.Current);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getDifferencesBetween(...)");
        return list2;
    }

    @NotNull
    public static final List<Difference> getDiff(@NotNull LocalHistoryFacade $this$getDiff, @NotNull IdeaGateway gateway, @NotNull ActivityScope scope2, @NotNull ChangeSetSelection selection, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$getDiff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        RootEntry rootEntry = LocalHistoryActivityDataKt.getRootEntry(selection.getData(), gateway);
        String entryPath = DiffUtilsKt.getEntryPath(gateway, scope2);
        return CollectionsKt.toList((Iterable)DiffUtilsKt.getDiff($this$getDiff, rootEntry, selection, entryPath, isOldContentUsed));
    }

    @NotNull
    public static final String getEntryPath(@NotNull IdeaGateway gateway, @NotNull ActivityScope scope2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (scope2 instanceof ActivityScope.File) {
            String string3 = gateway.getPathOrUrl(((ActivityScope.File)scope2).getFile());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPathOrUrl(...)");
        } else {
            string2 = "";
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Change> getChanges(@NotNull IdeaGateway gateway, @NotNull ActivityScope scope2, @NotNull List<Difference> diff) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(diff, (String)"diff");
        Iterable $this$map$iv = diff;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void difference;
            Difference difference2 = (Difference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(scope2 instanceof ActivityScope.Directory ? (Change)new DirectoryChange(new DirectoryChangeModel((Difference)difference, gateway)) : new Change(difference.getLeftContentRevision(gateway), difference.getRightContentRevision(gateway)));
        }
        return (List)destination$iv$iv;
    }
}

