/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.apiPlatform;

import com.intellij.platform.ml.FeatureDeclaration;
import com.intellij.platform.ml.FeatureValueType;
import com.intellij.platform.ml.impl.apiPlatform.CodeLikePrinter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00050\fJ\u0018\u0010\n\u001a\u00020\u00042\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000eJ \u0010\u000f\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R,\u0010\u0003\u001a\u00020\u0004\"\f\b\u0000\u0010\u0005*\u0006\u0012\u0002\b\u00030\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/ml/impl/apiPlatform/CodeLikePrinter;", "", "()V", "codeLikeType", "", "T", "", "Lcom/intellij/platform/ml/FeatureValueType$Enum;", "getCodeLikeType", "(Lcom/intellij/platform/ml/FeatureValueType$Enum;)Ljava/lang/String;", "printCodeLikeString", "featureDeclaration", "Lcom/intellij/platform/ml/FeatureDeclaration;", "featureDeclarations", "", "makeCodeLikeString", "Lcom/intellij/platform/ml/FeatureValueType;", "name", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class CodeLikePrinter {
    private final <T extends Enum<?>> String getCodeLikeType(FeatureValueType.Enum<T> $this$codeLikeType) {
        String string2 = $this$codeLikeType.getEnumClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string2;
    }

    private final <T> String makeCodeLikeString(FeatureValueType<T> $this$makeCodeLikeString, String name) {
        String string2;
        FeatureValueType<T> featureValueType = $this$makeCodeLikeString;
        if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Boolean.INSTANCE)) {
            string2 = "FeatureDeclaration.boolean(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Class.INSTANCE)) {
            string2 = "FeatureDeclaration.aClass(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Double.INSTANCE)) {
            string2 = "FeatureDeclaration.double(\"" + name + "\")";
        } else if (featureValueType instanceof FeatureValueType.Enum) {
            string2 = "FeatureDeclaration.enum<" + this.getCodeLikeType((FeatureValueType.Enum)$this$makeCodeLikeString) + ">(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Float.INSTANCE)) {
            string2 = "FeatureDeclaration.float(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Int.INSTANCE)) {
            string2 = "FeatureDeclaration.int(\"" + name + "\")";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Long.INSTANCE)) {
            string2 = "FeatureDeclaration.long(\"" + name + "\")";
        } else if (featureValueType instanceof FeatureValueType.Nullable) {
            string2 = this.makeCodeLikeString(((FeatureValueType.Nullable)$this$makeCodeLikeString).getBaseType(), name) + ".nullable()";
        } else if (featureValueType instanceof FeatureValueType.Categorical) {
            String possibleValuesSerialized2 = CollectionsKt.joinToString$default((Iterable)((FeatureValueType.Categorical)$this$makeCodeLikeString).getPossibleValues(), (CharSequence)", ", null, null, (int)0, null, (Function1)makeCodeLikeString.possibleValuesSerialized.1.INSTANCE, (int)30, null);
            string2 = "FeatureDeclaration.categorical(\"" + name + "\", setOf(" + possibleValuesSerialized2 + "))";
        } else if (Intrinsics.areEqual(featureValueType, (Object)FeatureValueType.Version.INSTANCE)) {
            string2 = "FeatureDeclaration.version(\"" + name + "\")";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @NotNull
    public final <T> String printCodeLikeString(@NotNull FeatureDeclaration<T> featureDeclaration) {
        Intrinsics.checkNotNullParameter(featureDeclaration, (String)"featureDeclaration");
        return this.makeCodeLikeString(featureDeclaration.getType(), featureDeclaration.getName());
    }

    @NotNull
    public final String printCodeLikeString(@NotNull Collection<? extends FeatureDeclaration<?>> featureDeclarations) {
        Intrinsics.checkNotNullParameter(featureDeclarations, (String)"featureDeclarations");
        return CollectionsKt.joinToString$default((Iterable)featureDeclarations, (CharSequence)", ", null, null, (int)0, null, (Function1)new Function1<FeatureDeclaration<?>, CharSequence>(this){
            final /* synthetic */ CodeLikePrinter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull FeatureDeclaration<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.this$0.printCodeLikeString(it);
            }
        }, (int)30, null);
    }
}

