/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.correctness.checker;

import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u0082\u0001\u0003\n\u000b\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/ml/impl/correctness/checker/SemanticChecker;", "", "getLocationInSuggestion", "Lcom/intellij/openapi/util/TextRange;", "errorRangeInFile", "offset", "", "prefix", "", "suggestion", "Lcom/intellij/platform/ml/impl/correctness/checker/CustomSemanticChecker;", "Lcom/intellij/platform/ml/impl/correctness/checker/InspectionBasedSemanticChecker;", "Lcom/intellij/platform/ml/impl/correctness/checker/RawSemanticChecker;", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public interface SemanticChecker {
    @Nullable
    default public TextRange getLocationInSuggestion(@NotNull TextRange errorRangeInFile, int offset, @NotNull String prefix, @NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)errorRangeInFile, (String)"errorRangeInFile");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        int shift = offset - prefix.length();
        TextRange textRange = new TextRange(0, suggestion.length()).shiftRight(shift);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        TextRange suggestionLocationInFile = textRange;
        if (!suggestionLocationInFile.intersects(errorRangeInFile)) {
            return null;
        }
        TextRange textRange2 = suggestionLocationInFile.intersection(errorRangeInFile);
        Intrinsics.checkNotNull((Object)textRange2);
        return textRange2.shiftLeft(shift);
    }
}

