/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URIReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class XmlBaseReferenceProvider
extends PsiReferenceProvider {
    private final boolean myAcceptSelf;

    public XmlBaseReferenceProvider(boolean acceptSelf) {
        this.myAcceptSelf = acceptSelf;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference reference;
        if (element == null) {
            XmlBaseReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            XmlBaseReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((reference = URIReferenceProvider.getUrlReference(element, ElementManipulators.getValueText((PsiElement)element))) != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                XmlBaseReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        FileReferenceSet referenceSet = FileReferenceSet.createSet((PsiElement)element, (boolean)false, (boolean)false, (boolean)false);
        referenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> this.getContext(element, (PsiFile)file));
        FileReference[] fileReferenceArray = referenceSet.getAllReferences();
        if (fileReferenceArray == null) {
            XmlBaseReferenceProvider.$$$reportNull$$$0(3);
        }
        return fileReferenceArray;
    }

    private Collection<PsiFileSystemItem> getContext(PsiElement element, PsiFile file) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (!this.myAcceptSelf && tag != null) {
            tag = tag.getParentTag();
        }
        while (tag != null) {
            PsiReference reference;
            XmlAttributeValue value2;
            XmlAttribute base = tag.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
            if (base != null && (value2 = base.getValueElement()) != null && (reference = value2.getReference()) instanceof PsiPolyVariantReference) {
                Object[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                return ContainerUtil.map((Object[])results, result2 -> (PsiFileSystemItem)result2.getElement());
            }
            tag = tag.getParentTag();
        }
        PsiDirectory directory = file.getContainingDirectory();
        return ContainerUtil.createMaybeSingletonList((Object)directory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlBaseReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlBaseReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

