/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.serialization.ClassUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.xml.util.XmlTagUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class DomUtil {
    public static final TypeVariable<Class<GenericValue>> GENERIC_VALUE_TYPE_VARIABLE = GenericValue.class.getTypeParameters()[0];
    private static final Class<Void> DUMMY = Void.TYPE;
    private static final Key<DomFileElement<?>> FILE_ELEMENT_KEY = Key.create((String)"dom file element");
    private static final ConcurrentMap<Type, Class<?>> ourTypeParameters = ConcurrentFactoryMap.createMap(key2 -> {
        Class<?> result2 = DomUtil.substituteGenericType(GENERIC_VALUE_TYPE_VARIABLE, key2);
        return result2 == null ? DUMMY : result2;
    });
    private static final ConcurrentMap<Couple<Type>, Class<?>> ourVariableSubstitutions = ConcurrentFactoryMap.createMap(key2 -> DomUtil.doSubstituteGenericType((Type)key2.first, (Type)key2.second));

    @Nullable
    private static Class<?> doSubstituteGenericType(@NotNull Type genericType, @NotNull Type classType) {
        if (genericType == null) {
            DomUtil.$$$reportNull$$$0(0);
        }
        if (classType == null) {
            DomUtil.$$$reportNull$$$0(1);
        }
        if (genericType instanceof TypeVariable) {
            int index;
            Class aClass = ClassUtil.getRawType((Type)classType);
            Type type2 = ClassUtil.resolveVariable((TypeVariable)((TypeVariable)genericType), (Class)aClass, (boolean)true);
            if (type2 instanceof Class) {
                return (Class)type2;
            }
            if (type2 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type2).getRawType();
            }
            if (type2 instanceof TypeVariable && classType instanceof ParameterizedType && (index = ArrayUtilRt.find((Object[])aClass.getTypeParameters(), (Object)type2)) >= 0) {
                return ClassUtil.getRawType((Type)((ParameterizedType)classType).getActualTypeArguments()[index]);
            }
        } else {
            return ClassUtil.getRawType((Type)genericType);
        }
        return null;
    }

    public static Class<?> extractParameterClassFromGenericType(Type type2) {
        return DomUtil.getGenericValueParameter(type2);
    }

    public static boolean isGenericValueType(Type type2) {
        return DomUtil.getGenericValueParameter(type2) != null;
    }

    @Nullable
    public static <T extends DomElement> T findByName(@NotNull Collection<T> list2, @NonNls @NotNull String name) {
        if (list2 == null) {
            DomUtil.$$$reportNull$$$0(2);
        }
        if (name == null) {
            DomUtil.$$$reportNull$$$0(3);
        }
        for (DomElement element : list2) {
            String elementName = element.getGenericInfo().getElementName(element);
            if (elementName == null || !elementName.equals(name)) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public static List<JavaMethod> getFixedPath(DomElement element) {
        DomElement parent;
        assert (element.isValid());
        LinkedList<JavaMethod> methods = new LinkedList<JavaMethod>();
        while (!((parent = element.getParent()) instanceof DomFileElement)) {
            JavaMethod method = DomUtil.getGetterMethod(element, parent);
            if (method == null) {
                return null;
            }
            methods.addFirst(method);
            element = element.getParent();
        }
        return methods;
    }

    @Nullable
    private static JavaMethod getGetterMethod(DomElement element, DomElement parent) {
        String xmlElementName = element.getXmlElementName();
        String namespace = element.getXmlElementNamespaceKey();
        DomGenericInfo genericInfo = parent.getGenericInfo();
        if (element instanceof GenericAttributeValue) {
            DomAttributeChildDescription<?> description2 = genericInfo.getAttributeChildDescription(xmlElementName, namespace);
            assert (description2 != null);
            return description2.getGetterMethod();
        }
        DomFixedChildDescription description3 = genericInfo.getFixedChildDescription(xmlElementName, namespace);
        return description3 != null ? description3.getGetterMethod(description3.getValues(parent).indexOf(element)) : null;
    }

    public static Class<?> substituteGenericType(Type genericType, Type classType) {
        return (Class)ourVariableSubstitutions.get(Couple.of((Object)genericType, (Object)classType));
    }

    @Nullable
    public static Class<?> getGenericValueParameter(Type type2) {
        Class aClass = (Class)ourTypeParameters.get(type2);
        return aClass == DUMMY ? null : aClass;
    }

    @ApiStatus.Internal
    public static void clearCaches() {
        ourTypeParameters.clear();
        ourVariableSubstitutions.clear();
    }

    @Nullable
    public static XmlElement getValueElement(GenericDomValue<?> domValue) {
        if (domValue instanceof GenericAttributeValue) {
            GenericAttributeValue value2 = (GenericAttributeValue)domValue;
            XmlAttributeValue attributeValue2 = value2.getXmlAttributeValue();
            return attributeValue2 == null ? value2.getXmlAttribute() : attributeValue2;
        }
        return domValue.getXmlTag();
    }

    public static List<? extends DomElement> getIdentitySiblings(DomElement element) {
        String tagName;
        GenericDomValue<?> nameDomElement = element.getGenericInfo().getNameDomElement(element);
        if (nameDomElement == null) {
            return Collections.emptyList();
        }
        NameValue nameValue = nameDomElement.getAnnotation(NameValue.class);
        if (nameValue == null || !nameValue.unique()) {
            return Collections.emptyList();
        }
        String stringValue = ElementPresentationManager.getElementName(element);
        if (stringValue == null) {
            return Collections.emptyList();
        }
        DomElement scope2 = element.getManager().getIdentityScope(element);
        if (scope2 == null) {
            return Collections.emptyList();
        }
        DomGenericInfo domGenericInfo = scope2.getGenericInfo();
        DomCollectionChildDescription childDescription = domGenericInfo.getCollectionChildDescription(tagName = element.getXmlElementName(), element.getXmlElementNamespaceKey());
        if (childDescription != null) {
            ArrayList<? extends DomElement> list2 = new ArrayList<DomElement>(childDescription.getValues(scope2));
            list2.remove(element);
            return list2;
        }
        return Collections.emptyList();
    }

    public static <T> List<T> getChildrenOfType(@NotNull DomElement parent, final Class<T> type2) {
        if (parent == null) {
            DomUtil.$$$reportNull$$$0(4);
        }
        SmartList result2 = new SmartList();
        parent.acceptChildren(new DomElementVisitor(){
            final /* synthetic */ List val$result;
            {
                this.val$result = list2;
            }

            @Override
            public void visitDomElement(DomElement element) {
                if (type2.isInstance(element)) {
                    this.val$result.add(type2.cast(element));
                }
            }
        });
        return result2;
    }

    public static List<DomElement> getDefinedChildren(@NotNull DomElement parent, boolean tags, boolean attributes) {
        if (parent == null) {
            DomUtil.$$$reportNull$$$0(5);
        }
        if (parent instanceof MergedObject) {
            final SmartList result2 = new SmartList();
            parent.acceptChildren(new DomElementVisitor(){

                @Override
                public void visitDomElement(DomElement element) {
                    if (DomUtil.hasXml(element)) {
                        result2.add((Object)element);
                    }
                }
            });
            return result2;
        }
        ProgressManager.checkCanceled();
        if (parent instanceof GenericAttributeValue) {
            return Collections.emptyList();
        }
        if (parent instanceof DomFileElement) {
            DomFileElement element = (DomFileElement)parent;
            return tags ? Collections.singletonList(element.getRootElement()) : Collections.emptyList();
        }
        XmlElement xmlElement = parent.getXmlElement();
        if (xmlElement instanceof XmlTag) {
            DomElement element;
            XmlTag tag = (XmlTag)xmlElement;
            DomManager domManager = parent.getManager();
            SmartList result3 = new SmartList();
            if (attributes) {
                for (XmlElement xmlElement2 : tag.getAttributes()) {
                    if (!xmlElement2.isValid()) {
                        Logger.getInstance(DomUtil.class).error("Invalid attr: parent.valid=" + tag.isValid());
                        continue;
                    }
                    element = domManager.getDomElement((XmlAttribute)xmlElement2);
                    if (!DomUtil.checkHasXml(xmlElement2, element)) continue;
                    ContainerUtil.addIfNotNull((Collection)result3, element);
                }
            }
            if (tags) {
                for (XmlElement xmlElement3 : tag.getSubTags()) {
                    if (!xmlElement3.isValid()) {
                        Logger.getInstance(DomUtil.class).error("Invalid subtag: parent.valid=" + tag.isValid());
                        continue;
                    }
                    element = domManager.getDomElement((XmlTag)xmlElement3);
                    if (!DomUtil.checkHasXml(xmlElement3, element)) continue;
                    ContainerUtil.addIfNotNull((Collection)result3, element);
                }
            }
            return result3;
        }
        return Collections.emptyList();
    }

    private static boolean checkHasXml(XmlElement psi, DomElement dom) {
        if (dom != null && !DomUtil.hasXml(dom)) {
            Logger.getInstance(DomUtil.class).error("No xml for dom " + dom + "; attr=" + psi + ", physical=" + psi.isPhysical());
            return false;
        }
        return true;
    }

    public static <T> List<T> getDefinedChildrenOfType(@NotNull DomElement parent, Class<T> type2, boolean tags, boolean attributes) {
        if (parent == null) {
            DomUtil.$$$reportNull$$$0(6);
        }
        return ContainerUtil.findAll(DomUtil.getDefinedChildren(parent, tags, attributes), type2);
    }

    public static <T> List<T> getDefinedChildrenOfType(@NotNull DomElement parent, Class<T> type2) {
        if (parent == null) {
            DomUtil.$$$reportNull$$$0(7);
        }
        return DomUtil.getDefinedChildrenOfType(parent, type2, true, true);
    }

    @Nullable
    public static DomElement findDuplicateNamedValue(DomElement element, String newName) {
        return ElementPresentationManager.findByName(DomUtil.getIdentitySiblings(element), newName);
    }

    public static boolean isAncestor(@NotNull DomElement ancestor, @NotNull DomElement descendant, boolean strict) {
        if (ancestor == null) {
            DomUtil.$$$reportNull$$$0(8);
        }
        if (descendant == null) {
            DomUtil.$$$reportNull$$$0(9);
        }
        if (!strict && ancestor.equals(descendant)) {
            return true;
        }
        DomElement parent = descendant.getParent();
        return parent != null && DomUtil.isAncestor(ancestor, parent, false);
    }

    public static void acceptAvailableChildren(DomElement element, DomElementVisitor visitor) {
        XmlTag tag = element.getXmlTag();
        if (tag != null) {
            for (XmlTag xmlTag : tag.getSubTags()) {
                DomElement childElement = element.getManager().getDomElement(xmlTag);
                if (childElement == null) continue;
                childElement.accept(visitor);
            }
        }
    }

    public static Collection<Class<?>> getAllInterfaces(Class<?> aClass, Collection<Class<?>> result2) {
        Object[] interfaces = aClass.getInterfaces();
        ContainerUtil.addAll(result2, (Object[])interfaces);
        if (aClass.getSuperclass() != null) {
            DomUtil.getAllInterfaces(aClass.getSuperclass(), result2);
        }
        for (Object anInterface : interfaces) {
            DomUtil.getAllInterfaces(anInterface, result2);
        }
        return result2;
    }

    @Nullable
    public static <T> T getParentOfType(DomElement element, Class<T> requiredClass, boolean strict) {
        DomElement curElement;
        DomElement domElement = curElement = strict && element != null ? element.getParent() : element;
        while (curElement != null) {
            if (requiredClass.isInstance(curElement)) {
                return requiredClass.cast(curElement);
            }
            curElement = curElement.getParent();
        }
        return null;
    }

    @Nullable
    public static <T> T getContextElement(@Nullable Editor editor, Class<T> clazz) {
        DomElement element = DomUtil.getContextElement(editor);
        return DomUtil.getParentOfType(element, clazz, false);
    }

    @Nullable
    public static DomElement getContextElement(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DomUtil.getDomElement(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public static DomElement getDomElement(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            DomUtil.$$$reportNull$$$0(10);
        }
        if (file == null) {
            DomUtil.$$$reportNull$$$0(11);
        }
        return DomUtil.getDomElement(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    @Nullable
    public static DomElement getDomElement(@Nullable PsiElement element) {
        GenericAttributeValue<?> value2;
        if (element == null) {
            return null;
        }
        Project project2 = element.getProject();
        DomManager domManager = DomManager.getDomManager(project2);
        XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)false);
        if (attr != null && (value2 = domManager.getDomElement(attr)) != null) {
            return value2;
        }
        for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false); tag != null; tag = tag.getParentTag()) {
            DomElement domElement = domManager.getDomElement(tag);
            if (domElement == null) continue;
            return domElement;
        }
        return null;
    }

    @NotNull
    public static <T extends DomElement> T getOriginalElement(@NotNull T domElement) {
        XmlElement psiElement;
        if (domElement == null) {
            DomUtil.$$$reportNull$$$0(12);
        }
        if ((psiElement = domElement.getXmlElement()) == null) {
            T t = domElement;
            if (t == null) {
                DomUtil.$$$reportNull$$$0(13);
            }
            return t;
        }
        PsiFile psiFile2 = psiElement.getContainingFile().getOriginalFile();
        TextRange range = psiElement.getTextRange();
        PsiElement element = psiFile2.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        boolean isAttribute = psiElement instanceof XmlAttribute;
        Class clazz = isAttribute ? XmlAttribute.class : XmlTag.class;
        DomManager domManager = domElement.getManager();
        DomElement current = null;
        XmlElement next = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)element, clazz, (boolean)false);
        while (next != null && next.getTextLength() <= maxLength) {
            DomElement domElement2 = current = isAttribute ? domManager.getDomElement((XmlAttribute)next) : domManager.getDomElement((XmlTag)next);
            if (current != null && domElement.getClass() != current.getClass()) {
                current = null;
            }
            next = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)next, clazz, (boolean)true);
        }
        DomElement domElement3 = current;
        if (domElement3 == null) {
            DomUtil.$$$reportNull$$$0(14);
        }
        return (T)domElement3;
    }

    public static <T extends DomElement> T addElementAfter(@NotNull T anchor) {
        if (anchor == null) {
            DomUtil.$$$reportNull$$$0(15);
        }
        DomElement parent = anchor.getParent();
        DomCollectionChildDescription childDescription = (DomCollectionChildDescription)anchor.getChildDescription();
        assert (parent != null);
        List<? extends DomElement> list2 = childDescription.getValues(parent);
        int i = list2.indexOf(anchor);
        assert (i >= 0);
        return (T)childDescription.addValue(parent, i + 1);
    }

    @Nullable
    public static <T extends DomElement> T findDomElement(@Nullable PsiElement element, Class<T> beanClass) {
        return DomUtil.findDomElement(element, beanClass, true);
    }

    @Nullable
    public static <T extends DomElement> T findDomElement(@Nullable PsiElement element, Class<T> beanClass, boolean strict) {
        if (element == null) {
            return null;
        }
        for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)strict); tag != null; tag = tag.getParentTag()) {
            DomElement domElement = DomManager.getDomManager(tag.getProject()).getDomElement(tag);
            if (domElement == null) continue;
            return domElement.getParentOfType(beanClass, false);
        }
        return null;
    }

    public static <T extends DomElement> DomFileElement<T> getFileElement(@NotNull DomElement element) {
        if (element == null) {
            DomUtil.$$$reportNull$$$0(16);
        }
        if (element instanceof DomFileElement) {
            return (DomFileElement)element;
        }
        DomFileElement<T> fileElement = (DomFileElement<T>)element.getUserData(FILE_ELEMENT_KEY);
        if (fileElement == null) {
            DomElement parent = element.getParent();
            if (parent != null) {
                fileElement = DomUtil.getFileElement(parent);
            }
            element.putUserData(FILE_ELEMENT_KEY, fileElement);
        }
        return fileElement;
    }

    @NotNull
    public static XmlFile getFile(@NotNull DomElement element) {
        if (element == null) {
            DomUtil.$$$reportNull$$$0(17);
        }
        XmlFile xmlFile = DomService.getInstance().getContainingFile(element);
        if (xmlFile == null) {
            DomUtil.$$$reportNull$$$0(18);
        }
        return xmlFile;
    }

    @NotNull
    public static DomElement getRoot(@NotNull DomElement domElement) {
        if (domElement == null) {
            DomUtil.$$$reportNull$$$0(19);
        }
        while (true) {
            DomElement parent;
            if ((parent = domElement.getParent()) == null) {
                DomElement domElement2 = domElement;
                if (domElement2 == null) {
                    DomUtil.$$$reportNull$$$0(20);
                }
                return domElement2;
            }
            domElement = parent;
        }
    }

    public static boolean hasXml(@NotNull DomElement element) {
        if (element == null) {
            DomUtil.$$$reportNull$$$0(21);
        }
        return element.exists();
    }

    public static Pair<TextRange, PsiElement> getProblemRange(XmlTag tag) {
        XmlToken startToken = XmlTagUtil.getStartTagNameElement(tag);
        if (startToken == null) {
            return Pair.create((Object)tag.getTextRange(), (Object)tag);
        }
        return Pair.create((Object)startToken.getTextRange().shiftRight(-tag.getTextRange().getStartOffset()), (Object)tag);
    }

    public static <T extends DomElement> List<T> getChildrenOf(DomElement parent, Class<T> type2) {
        SmartList list2 = new SmartList();
        List<? extends AbstractDomChildrenDescription> descriptions = parent.getGenericInfo().getChildrenDescriptions();
        int descriptionsSize = descriptions.size();
        for (int i = 0; i < descriptionsSize; ++i) {
            AbstractDomChildrenDescription description2 = descriptions.get(i);
            if (!(description2.getType() instanceof Class) || !type2.isAssignableFrom((Class)description2.getType())) continue;
            List<? extends DomElement> values2 = description2.getValues(parent);
            int valuesSize = values2.size();
            for (int j = 0; j < valuesSize; ++j) {
                DomElement value2 = values2.get(j);
                if (!value2.exists()) continue;
                list2.add(value2);
            }
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/DomUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/DomUtil";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalElement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doSubstituteGenericType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefinedChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefinedChildrenOfType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDomElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 20: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addElementAfter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFileElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasXml";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 13, 14, 18, 20 -> new IllegalStateException(string2);
        };
    }
}

