/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ui.JBColor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.TooltipUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorableTableCellRenderer<T extends DomElement>
extends DefaultTableCellRenderer {
    private final TableCellRenderer myRenderer;
    private final DomElement myRowDomElement;
    private final T myCellValueDomElement;
    private final DomElement myRoot;

    public ErrorableTableCellRenderer(@Nullable T cellValueDomElement, TableCellRenderer renderer2, @NotNull DomElement rowDomElement) {
        if (rowDomElement == null) {
            ErrorableTableCellRenderer.$$$reportNull$$$0(0);
        }
        this.myCellValueDomElement = cellValueDomElement;
        this.myRenderer = renderer2;
        this.myRowDomElement = rowDomElement;
        this.myRoot = DomUtil.getRoot(this.myRowDomElement);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column) {
        boolean hasErrors;
        Component component2 = this.myRenderer.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column);
        if (!this.myRoot.isValid()) {
            return component2;
        }
        DomElementAnnotationsManager annotationsManager = DomElementAnnotationsManager.getInstance(this.myRowDomElement.getManager().getProject());
        DomElementsProblemsHolder holder = annotationsManager.getCachedProblemHolder(this.myRoot);
        List<DomElementProblemDescriptor> errorProblems = holder.getProblems((DomElement)this.myCellValueDomElement);
        ArrayList<DomElementProblemDescriptor> warningProblems = new ArrayList<DomElementProblemDescriptor>(holder.getProblems((DomElement)this.myCellValueDomElement, true, HighlightSeverity.WARNING));
        warningProblems.removeAll(errorProblems);
        boolean bl = hasErrors = errorProblems.size() > 0;
        if (hasErrors) {
            component2.setForeground((Color)JBColor.RED);
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setToolTipText(TooltipUtils.getTooltipText(errorProblems));
            }
        } else {
            component2.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setToolTipText(null);
            }
        }
        if (hasErrors && (value2 == null || value2.toString().trim().length() == 0)) {
            component2.setBackground(BaseControl.ERROR_BACKGROUND);
        } else if (warningProblems.size() > 0) {
            component2.setBackground(BaseControl.WARNING_BACKGROUND);
            if (isSelected) {
                component2.setForeground(JBColor.foreground());
            }
        }
        List<DomElementProblemDescriptor> errorDescriptors = annotationsManager.getCachedProblemHolder(this.myRowDomElement).getProblems(this.myRowDomElement, true, true);
        if (table.getModel().getColumnCount() - 1 == column) {
            if (errorDescriptors.size() > 0) {
                JPanel wrapper = new JPanel(new BorderLayout());
                wrapper.add(component2, "Center");
                wrapper.setBackground(component2.getBackground());
                JLabel errorLabel = new JLabel(ErrorableTableCellRenderer.getErrorIcon());
                wrapper.setToolTipText(TooltipUtils.getTooltipText(errorDescriptors));
                wrapper.add((Component)errorLabel, "East");
                if (component2 instanceof JComponent) {
                    JComponent jComponent = (JComponent)component2;
                    wrapper.setBorder(jComponent.getBorder());
                    jComponent.setBorder(BorderFactory.createEmptyBorder());
                    jComponent.setToolTipText(TooltipUtils.getTooltipText(errorDescriptors));
                }
                return wrapper;
            }
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setToolTipText(null);
            }
        }
        return component2;
    }

    private static Icon getErrorIcon() {
        return AllIcons.General.ExclMark;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowDomElement", "com/intellij/util/xml/ui/ErrorableTableCellRenderer", "<init>"));
    }
}

