/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public final class TooltipUtils {
    @NonNls
    private static final HtmlChunk MESSAGE_DELIMITER = HtmlChunk.hr().attr("size", "1").attr("noshade", "noshade");

    @NlsContexts.Tooltip
    public static String getTooltipText(List<? extends DomElementProblemDescriptor> annotations) {
        if (annotations.size() == 0) {
            return null;
        }
        return TooltipUtils.getTooltipText(TooltipUtils.getMessages(annotations));
    }

    @NlsContexts.Tooltip
    public static String getTooltipText(List<? extends DomElementProblemDescriptor> annotations, @InspectionMessage String[] messages) {
        return TooltipUtils.getTooltipText(ArrayUtil.mergeArrays((String[])TooltipUtils.getMessages(annotations), (String[])messages));
    }

    @InspectionMessage
    private static String[] getMessages(List<? extends DomElementProblemDescriptor> problems2) {
        String[] messages = new String[problems2.size()];
        for (int i = 0; i < problems2.size(); ++i) {
            messages[i] = problems2.get(i).getDescriptionTemplate();
        }
        return messages;
    }

    @NlsContexts.Tooltip
    public static String getTooltipText(@InspectionMessage String[] messages) {
        if (messages.length == 0) {
            return null;
        }
        HtmlChunk.Element contents = HtmlChunk.tag((String)"td");
        int len = Math.min(messages.length, 10);
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                contents = contents.child(MESSAGE_DELIMITER);
            }
            contents = contents.addText(messages[i]);
        }
        if (messages.length > 10) {
            contents = contents.child(MESSAGE_DELIMITER).addText("...");
        }
        HtmlChunk.Element emptyCell = HtmlChunk.tag((String)"td").addText("&nbsp;");
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{emptyCell, contents, emptyCell}))).wrapWithHtmlBody().toString();
    }
}

