/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflow;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandler;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.CommitSessionInfo;
import com.intellij.vcs.commit.CommitWorkflowUi;
import com.intellij.vcs.commit.DynamicCommitInfo;
import com.intellij.vcs.commit.StaticCommitInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/commit/DynamicCommitInfoImpl;", "Lcom/intellij/vcs/commit/DynamicCommitInfo;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "sessionInfo", "Lcom/intellij/vcs/commit/CommitSessionInfo;", "workflowUi", "Lcom/intellij/vcs/commit/CommitWorkflowUi;", "workflow", "Lcom/intellij/vcs/commit/AbstractCommitWorkflow;", "(Lcom/intellij/openapi/vcs/changes/CommitContext;Lcom/intellij/vcs/commit/CommitSessionInfo;Lcom/intellij/vcs/commit/CommitWorkflowUi;Lcom/intellij/vcs/commit/AbstractCommitWorkflow;)V", "affectedVcses", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "getAffectedVcses", "()Ljava/util/List;", "commitActionText", "", "getCommitActionText", "()Ljava/lang/String;", "getCommitContext", "()Lcom/intellij/openapi/vcs/changes/CommitContext;", "commitMessage", "getCommitMessage", "committedChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "getCommittedChanges", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "getExecutor", "()Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "isVcsCommit", "", "()Z", "asStaticInfo", "Lcom/intellij/vcs/commit/StaticCommitInfo;", "intellij.platform.vcs.impl"})
public final class DynamicCommitInfoImpl
implements DynamicCommitInfo {
    @NotNull
    private final CommitContext commitContext;
    @NotNull
    private final CommitSessionInfo sessionInfo;
    @NotNull
    private final CommitWorkflowUi workflowUi;
    @NotNull
    private final AbstractCommitWorkflow workflow;
    private final boolean isVcsCommit;

    public DynamicCommitInfoImpl(@NotNull CommitContext commitContext, @NotNull CommitSessionInfo sessionInfo, @NotNull CommitWorkflowUi workflowUi, @NotNull AbstractCommitWorkflow workflow) {
        Intrinsics.checkNotNullParameter((Object)((Object)commitContext), (String)"commitContext");
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        Intrinsics.checkNotNullParameter((Object)workflowUi, (String)"workflowUi");
        Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
        this.commitContext = commitContext;
        this.sessionInfo = sessionInfo;
        this.workflowUi = workflowUi;
        this.workflow = workflow;
        this.isVcsCommit = this.sessionInfo.isVcsCommit();
    }

    @Override
    @NotNull
    public CommitContext getCommitContext() {
        return this.commitContext;
    }

    @Override
    public boolean isVcsCommit() {
        return this.isVcsCommit;
    }

    @Override
    @Nullable
    public CommitExecutor getExecutor() {
        return this.sessionInfo.getExecutor();
    }

    @Override
    @NotNull
    public List<Change> getCommittedChanges() {
        List<Change> changes2 = this.workflowUi.getIncludedChanges();
        CommitExecutor executor = this.sessionInfo.getExecutor();
        if (executor != null && !executor.supportsPartialCommit()) {
            return changes2;
        }
        return PartialChangesUtil.wrapPartialChanges(this.workflow.getProject(), changes2);
    }

    @Override
    @NotNull
    public List<AbstractVcs> getAffectedVcses() {
        return CollectionsKt.toList((Iterable)this.workflow.getVcses());
    }

    @Override
    @NotNull
    public String getCommitMessage() {
        return this.workflowUi.getCommitMessageUi().getText();
    }

    @Override
    @NotNull
    public String getCommitActionText() {
        return AbstractCommitWorkflowHandler.Companion.getActionTextWithoutEllipsis((Collection<? extends AbstractVcs>)this.workflow.getVcses(), this.getExecutor(), AbstractCommitWorkflowKt.isAmendCommitMode(this.getCommitContext()), false, false);
    }

    @Override
    @NotNull
    public StaticCommitInfo asStaticInfo() {
        return new StaticCommitInfo(this.getCommitContext(), this.isVcsCommit(), this.getExecutor(), this.getCommitActionText(), this.getCommittedChanges(), this.getAffectedVcses(), this.getCommitMessage());
    }
}

