/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.PhmVcsLogStorageBackend;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsRefImpl;
import com.intellij.vcs.log.util.StorageId;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogStorageImpl
implements Disposable,
VcsLogStorage {
    @NotNull
    private static final Logger LOG = Logger.getInstance(VcsLogStorage.class);
    @NotNull
    @NonNls
    private static final String HASHES_STORAGE = "hashes";
    @NotNull
    @NonNls
    private static final String REFS_STORAGE = "refs";
    @NotNull
    @NonNls
    private static final String STORAGE = "storage";
    public static final int VERSION = 8;
    public static final int NO_INDEX = -1;
    private static final int REFS_VERSION = 2;
    @NotNull
    private final StorageId.Directory myHashesStorageId;
    @NotNull
    private final StorageId.Directory myRefsStorageId;
    @NotNull
    private final MyPersistentBTreeEnumerator myCommitIdEnumerator;
    @NotNull
    private final PersistentEnumerator<VcsRef> myRefsEnumerator;
    @NotNull
    private final VcsLogErrorHandler myErrorHandler;
    private volatile boolean myDisposed;

    private VcsLogStorageImpl(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull StorageId.Directory hashesStorageId, @NotNull StorageId.Directory refsStorageId, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable parent) throws IOException {
        if (logProviders == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(0);
        }
        if (hashesStorageId == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(1);
        }
        if (refsStorageId == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(2);
        }
        if (errorHandler2 == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(4);
        }
        this.myDisposed = false;
        this.myErrorHandler = errorHandler2;
        Disposer.register((Disposable)parent, (Disposable)this);
        try {
            StorageLockContext storageLockContext = new StorageLockContext();
            List<VirtualFile> roots = logProviders.keySet().stream().sorted(Comparator.comparing(VirtualFile::getPath)).toList();
            MyCommitIdKeyDescriptor commitIdKeyDescriptor = new MyCommitIdKeyDescriptor(roots);
            this.myHashesStorageId = hashesStorageId;
            this.myCommitIdEnumerator = new MyPersistentBTreeEnumerator(this.myHashesStorageId, commitIdKeyDescriptor, storageLockContext);
            Disposer.register((Disposable)this, () -> {
                try {
                    this.myCommitIdEnumerator.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            });
            VcsRefKeyDescriptor refsKeyDescriptor = new VcsRefKeyDescriptor(logProviders, commitIdKeyDescriptor);
            this.myRefsStorageId = refsStorageId;
            this.myRefsEnumerator = new PersistentEnumerator(this.myRefsStorageId.getStorageFile(STORAGE), (KeyDescriptor)refsKeyDescriptor, AbstractStorage.PAGE_SIZE, storageLockContext, this.myRefsStorageId.getVersion());
            Disposer.register((Disposable)this, () -> {
                try {
                    this.myRefsEnumerator.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            });
            Disposer.register((Disposable)this, () -> {
                this.myDisposed = true;
            });
        }
        catch (Throwable t) {
            this.myDisposed = true;
            Disposer.dispose((Disposable)this);
            throw t;
        }
    }

    @NotNull
    public static Function<Integer, Hash> createHashGetter(@NotNull VcsLogStorage storage) {
        if (storage == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(5);
        }
        Function function = commitIndex -> {
            CommitId commitId2 = storage.getCommitId((int)commitIndex);
            return commitId2 == null ? null : commitId2.getHash();
        };
        if (function == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(6);
        }
        return function;
    }

    @Nullable
    private CommitId doGetCommitId(int index) throws IOException {
        return (CommitId)this.myCommitIdEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash2, @NotNull VirtualFile root) throws IOException {
        if (hash2 == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(7);
        }
        if (root == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(8);
        }
        return this.myCommitIdEnumerator.enumerate(new CommitId(hash2, root));
    }

    @Override
    public int getCommitIndex(@NotNull Hash hash2, @NotNull VirtualFile root) {
        if (hash2 == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(9);
        }
        if (root == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(10);
        }
        this.checkDisposed();
        try {
            return this.getOrPut(hash2, root);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public CommitId getCommitId(int commitIndex) {
        this.checkDisposed();
        try {
            CommitId commitId2 = this.doGetCommitId(commitIndex);
            if (commitId2 == null) {
                this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, new RuntimeException("Unknown commit index: " + commitIndex));
            }
            return commitId2;
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return null;
        }
    }

    @Override
    public boolean containsCommit(@NotNull CommitId id) {
        if (id == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(11);
        }
        this.checkDisposed();
        try {
            return this.myCommitIdEnumerator.contains(id);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return false;
        }
    }

    @Override
    public void iterateCommits(final @NotNull Predicate<? super CommitId> consumer) {
        if (consumer == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(12);
        }
        this.checkDisposed();
        try {
            this.myCommitIdEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<CommitId>(){

                protected boolean accept(CommitId commitId2) {
                    return !consumer.test(commitId2);
                }
            });
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
        }
    }

    @Override
    public int getRefIndex(@NotNull VcsRef ref) {
        if (ref == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(13);
        }
        this.checkDisposed();
        try {
            return this.myRefsEnumerator.enumerate((Object)ref);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return -1;
        }
    }

    @Override
    @Nullable
    public VcsRef getVcsRef(int refIndex) {
        this.checkDisposed();
        try {
            return (VcsRef)this.myRefsEnumerator.valueOf(refIndex);
        }
        catch (IOException e) {
            this.myErrorHandler.handleError(VcsLogErrorHandler.Source.Storage, e);
            return null;
        }
    }

    @Override
    public void flush() {
        this.checkDisposed();
        this.myCommitIdEnumerator.force();
        this.myRefsEnumerator.force();
    }

    @NotNull
    public StorageId getHashesStorageId() {
        StorageId.Directory directory = this.myHashesStorageId;
        if (directory == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(14);
        }
        return directory;
    }

    @NotNull
    public StorageId getRefsStorageId() {
        StorageId.Directory directory = this.myRefsStorageId;
        if (directory == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(15);
        }
        return directory;
    }

    public void dispose() {
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    public static @NotNull Pair<VcsLogStorage, @Nullable VcsLogStorageBackend> createStorageAndIndexBackend(@NotNull Project project2, @NotNull String logId, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull Set<VirtualFile> indexingRoots, @NotNull VcsLogErrorHandler errorHandler2, @NotNull Disposable parent) throws IOException {
        if (project2 == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(16);
        }
        if (logId == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(17);
        }
        if (logProviders == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(18);
        }
        if (indexingRoots == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(19);
        }
        if (errorHandler2 == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(20);
        }
        if (parent == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(21);
        }
        StorageId.Directory hashesStorageId = new StorageId.Directory(project2.getName(), HASHES_STORAGE, logId, 8);
        StorageId.Directory refsStorageId = new StorageId.Directory(project2.getName(), REFS_STORAGE, logId, 10);
        StorageId.Directory indexStorageId = PhmVcsLogStorageBackend.getIndexStorageId(project2, logId);
        List<StorageId.Directory> storageIds = List.of(hashesStorageId, refsStorageId, indexStorageId);
        Pair pair = (Pair)IOUtil.openCleanOrResetBroken(() -> {
            VcsLogStorageImpl storage = new VcsLogStorageImpl(logProviders, hashesStorageId, refsStorageId, errorHandler2, parent);
            if (indexingRoots.isEmpty()) {
                return new Pair((Object)storage, null);
            }
            try {
                PhmVcsLogStorageBackend indexBackend = PhmVcsLogStorageBackend.create(project2, storage, indexStorageId, indexingRoots, errorHandler2, parent);
                return new Pair((Object)storage, (Object)indexBackend);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Could not create index storage backend", e);
                return new Pair((Object)storage, null);
            }
        }, () -> {
            for (StorageId.Directory storageId : storageIds) {
                if (storageId.cleanupAllStorageFiles()) continue;
                LOG.error("Could not clean up storage files in " + storageId.getStoragePath());
            }
        });
        if (pair == null) {
            VcsLogStorageImpl.$$$reportNull$$$0(22);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 14, 15, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashesStorageId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsStorageId";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = STORAGE;
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogStorageImpl";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexingRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashGetter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashesStorageId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefsStorageId";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorageAndIndexBackend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHashGetter";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 22: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrPut";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommitIndex";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsCommit";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "iterateCommits";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRefIndex";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createStorageAndIndexBackend";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 14, 15, 22 -> new IllegalStateException(string2);
        };
    }

    private static class MyCommitIdKeyDescriptor
    implements KeyDescriptor<CommitId> {
        @NotNull
        private final List<? extends VirtualFile> myRoots;
        @NotNull
        private final Object2IntMap<VirtualFile> myRootsReversed;

        MyCommitIdKeyDescriptor(@NotNull List<? extends VirtualFile> roots) {
            if (roots == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(0);
            }
            this.myRoots = roots;
            this.myRootsReversed = new Object2IntOpenHashMap();
            for (int i = 0; i < roots.size(); ++i) {
                this.myRootsReversed.put((Object)roots.get(i), i);
            }
        }

        public void save(@NotNull DataOutput out, CommitId value2) throws IOException {
            if (out == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(1);
            }
            ((HashImpl)value2.getHash()).write(out);
            out.writeInt(this.myRootsReversed.getInt((Object)value2.getRoot()));
        }

        public CommitId read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyCommitIdKeyDescriptor.$$$reportNull$$$0(2);
            }
            Hash hash2 = HashImpl.read(in);
            VirtualFile root = this.myRoots.get(in.readInt());
            if (root == null) {
                return null;
            }
            return new CommitId(hash2, root);
        }

        public int getHashCode(CommitId value2) {
            int result2 = value2.getHash().hashCode();
            result2 = 31 * result2 + this.myRootsReversed.getInt((Object)value2);
            return result2;
        }

        public boolean isEqual(@Nullable CommitId val1, @Nullable CommitId val2) {
            if (val1 == val2) {
                return true;
            }
            if (val1 == null || val2 == null) {
                return false;
            }
            return val1.getHash().equals(val2.getHash()) && this.myRootsReversed.getInt((Object)val1.getRoot()) == this.myRootsReversed.getInt((Object)val2.getRoot());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$MyCommitIdKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyPersistentBTreeEnumerator
    extends PersistentBTreeEnumerator<CommitId> {
        MyPersistentBTreeEnumerator(@NotNull StorageId.Directory storageId, @NotNull KeyDescriptor<CommitId> commitIdKeyDescriptor, @Nullable StorageLockContext storageLockContext) throws IOException {
            if (storageId == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(0);
            }
            if (commitIdKeyDescriptor == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(1);
            }
            super(storageId.getStorageFile(VcsLogStorageImpl.STORAGE), commitIdKeyDescriptor, AbstractStorage.PAGE_SIZE, storageLockContext, storageId.getVersion());
        }

        public boolean contains(@NotNull CommitId id) throws IOException {
            if (id == null) {
                MyPersistentBTreeEnumerator.$$$reportNull$$$0(2);
            }
            return this.tryEnumerate(id) != 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitIdKeyDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$MyPersistentBTreeEnumerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VcsRefKeyDescriptor
    implements KeyDescriptor<VcsRef> {
        @NotNull
        private final Map<VirtualFile, VcsLogProvider> myLogProviders;
        @NotNull
        private final KeyDescriptor<CommitId> myCommitIdKeyDescriptor;

        VcsRefKeyDescriptor(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull KeyDescriptor<CommitId> commitIdKeyDescriptor) {
            if (logProviders == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(0);
            }
            if (commitIdKeyDescriptor == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(1);
            }
            this.myLogProviders = logProviders;
            this.myCommitIdKeyDescriptor = commitIdKeyDescriptor;
        }

        public int getHashCode(@NotNull VcsRef value2) {
            if (value2 == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(2);
            }
            return value2.hashCode();
        }

        public boolean isEqual(@Nullable VcsRef val1, @Nullable VcsRef val2) {
            return Objects.equals(val1, val2);
        }

        public void save(@NotNull DataOutput out, @NotNull VcsRef value2) throws IOException {
            if (out == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(3);
            }
            if (value2 == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(4);
            }
            this.myCommitIdKeyDescriptor.save(out, (Object)new CommitId(value2.getCommitHash(), value2.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value2.getName());
            this.myLogProviders.get(value2.getRoot()).getReferenceManager().serialize(out, value2.getType());
        }

        public VcsRef read(@NotNull DataInput in) throws IOException {
            CommitId commitId2;
            if (in == null) {
                VcsRefKeyDescriptor.$$$reportNull$$$0(5);
            }
            if ((commitId2 = (CommitId)this.myCommitIdKeyDescriptor.read(in)) == null) {
                throw new IOException("Can not read commit id for reference");
            }
            String name = IOUtil.readUTF((DataInput)in);
            VcsRefType type2 = this.myLogProviders.get(commitId2.getRoot()).getReferenceManager().deserialize(in);
            return new VcsRefImpl(commitId2.getHash(), name, type2, commitId2.getRoot());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logProviders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitIdKeyDescriptor";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/VcsLogStorageImpl$VcsRefKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHashCode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

