/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.vcs.log.graph.GraphCommit;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DuplicateParentFixer {
    public static <CommitId> AbstractList<? extends GraphCommit<CommitId>> fixDuplicateParentCommits(final List<? extends GraphCommit<CommitId>> finalCommits) {
        return new AbstractList<GraphCommit<CommitId>>(){

            @Override
            public GraphCommit<CommitId> get(int index) {
                return DuplicateParentFixer.fixParentsDuplicate((GraphCommit)finalCommits.get(index));
            }

            @Override
            public int size() {
                return finalCommits.size();
            }
        };
    }

    @NotNull
    private static <CommitId> GraphCommit<CommitId> fixParentsDuplicate(@NotNull GraphCommit<CommitId> commit2) {
        List<CommitId> parents;
        if (commit2 == null) {
            DuplicateParentFixer.$$$reportNull$$$0(0);
        }
        if ((parents = commit2.getParents()).size() <= 1) {
            GraphCommit<CommitId> graphCommit = commit2;
            if (graphCommit == null) {
                DuplicateParentFixer.$$$reportNull$$$0(1);
            }
            return graphCommit;
        }
        if (parents.size() == 2) {
            CommitId commitId0 = parents.get(0);
            if (!commitId0.equals(parents.get(1))) {
                GraphCommit<CommitId> graphCommit = commit2;
                if (graphCommit == null) {
                    DuplicateParentFixer.$$$reportNull$$$0(2);
                }
                return graphCommit;
            }
            return new DelegateGraphCommit<CommitId>(commit2, Collections.singletonList(commitId0));
        }
        HashSet<CommitId> allParents = new HashSet<CommitId>(parents);
        if (parents.size() == allParents.size()) {
            GraphCommit<CommitId> graphCommit = commit2;
            if (graphCommit == null) {
                DuplicateParentFixer.$$$reportNull$$$0(3);
            }
            return graphCommit;
        }
        ArrayList<CommitId> correctParents = new ArrayList<CommitId>();
        for (CommitId commitId2 : parents) {
            if (!allParents.remove(commitId2)) continue;
            correctParents.add(commitId2);
        }
        return new DelegateGraphCommit<CommitId>(commit2, correctParents);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fixParentsDuplicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixParentsDuplicate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }

    private static final class DelegateGraphCommit<CommitId>
    implements GraphCommit<CommitId> {
        @NotNull
        private final GraphCommit<CommitId> myDelegate;
        @NotNull
        private final List<CommitId> myParents;

        private DelegateGraphCommit(@NotNull GraphCommit<CommitId> delegate, @NotNull List<CommitId> parents) {
            if (delegate == null) {
                DelegateGraphCommit.$$$reportNull$$$0(0);
            }
            if (parents == null) {
                DelegateGraphCommit.$$$reportNull$$$0(1);
            }
            this.myDelegate = delegate;
            this.myParents = parents;
        }

        @Override
        @NotNull
        public CommitId getId() {
            CommitId CommitId2 = this.myDelegate.getId();
            if (CommitId2 == null) {
                DelegateGraphCommit.$$$reportNull$$$0(2);
            }
            return CommitId2;
        }

        @Override
        @NotNull
        public List<CommitId> getParents() {
            List<CommitId> list2 = this.myParents;
            if (list2 == null) {
                DelegateGraphCommit.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        public long getTimestamp() {
            return this.myDelegate.getTimestamp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parents";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer$DelegateGraphCommit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer$DelegateGraphCommit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3 -> new IllegalStateException(string2);
            };
        }
    }
}

