/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.statistics.VcsLogIndexCollector;
import com.intellij.vcs.log.statistics.VcsLogIndexCollectorState;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/statistics/VcsLogIndexProjectStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "INDEXING_TIME", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "INDEXING_TIME_BY_ROOT", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "", "INDEX_DISABLED", "IS_PAUSED", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getGroup", "getIndexCollector", "Lcom/intellij/vcs/log/statistics/VcsLogIndexCollector;", "project", "Lcom/intellij/openapi/project/Project;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getSharedSettings", "Lcom/intellij/vcs/log/impl/VcsLogSharedSettings;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogIndexStatisticsCollectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogIndexStatisticsCollectors.kt\ncom/intellij/vcs/log/statistics/VcsLogIndexProjectStatisticsCollector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,150:1\n59#2:151\n59#2:152\n*S KotlinDebug\n*F\n+ 1 VcsLogIndexStatisticsCollectors.kt\ncom/intellij/vcs/log/statistics/VcsLogIndexProjectStatisticsCollector\n*L\n84#1:151\n86#1:152\n*E\n"})
public final class VcsLogIndexProjectStatisticsCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("vcs.log.index.project", 5, null, 4, null);
    @NotNull
    private final EventId1<Integer> INDEXING_TIME = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"indexing.time.minutes", (EventField)((EventField)EventFields.Count), null, (int)4, null);
    @NotNull
    private final BooleanEventField IS_PAUSED = EventFields.Boolean((String)"is_paused");
    @NotNull
    private final EventId3<String, Long, Boolean> INDEXING_TIME_BY_ROOT = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"indexing.time.by.root", (EventField)((EventField)EventFields.AnonymizedPath), (EventField)((EventField)EventFields.DurationMs), (EventField)((EventField)this.IS_PAUSED), null, (int)16, null);
    @NotNull
    private final EventId1<Boolean> INDEX_DISABLED = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"index.disabled.in.project", (EventField)((EventField)EventFields.Boolean((String)"value")), null, (int)4, null);

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Set usages;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (!TrustedProjects.isTrusted((Project)project2)) {
                return SetsKt.emptySet();
            }
            usages = new LinkedHashSet();
            Object object = this.getIndexCollector(project2);
            if (object != null && (object = ((VcsLogIndexCollector)object).getState()) != null) {
                Object indexCollectorState = object;
                boolean bl = false;
                int indexingTime = (int)TimeUnit.MILLISECONDS.toMinutes(((VcsLogIndexCollectorState)((Object)indexCollectorState)).getIndexTime());
                usages.add(this.INDEXING_TIME.metric((Object)indexingTime));
                for (Map.Entry<String, Long> entry2 : ((VcsLogIndexCollectorState)((Object)indexCollectorState)).getIndexTimeByRoot().entrySet()) {
                    String rootPath = entry2.getKey();
                    long time = ((Number)entry2.getValue()).longValue();
                    usages.add(this.INDEXING_TIME_BY_ROOT.metric((Object)rootPath, (Object)time, (Object)VcsLogBigRepositoriesList.getInstance().isBig(rootPath)));
                }
            }
            VcsLogSharedSettings vcsLogSharedSettings = this.getSharedSettings(project2);
            if (vcsLogSharedSettings == null) break block4;
            VcsLogSharedSettings sharedSettings = vcsLogSharedSettings;
            boolean bl = false;
            if (!sharedSettings.isIndexSwitchedOn()) {
                usages.add(this.INDEX_DISABLED.metric((Object)true));
            }
        }
        return usages;
    }

    private final VcsLogSharedSettings getSharedSettings(Project project2) {
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project2;
        boolean $i$f$serviceIfCreated = false;
        return (VcsLogSharedSettings)$this$serviceIfCreated$iv.getServiceIfCreated(VcsLogSharedSettings.class);
    }

    private final VcsLogIndexCollector getIndexCollector(Project project2) {
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project2;
        boolean $i$f$serviceIfCreated = false;
        return (VcsLogIndexCollector)$this$serviceIfCreated$iv.getServiceIfCreated(VcsLogIndexCollector.class);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }
}

