/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogUsageTriggerCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("vcs.log.trigger", 7);
    private static final StringEventField CONTEXT = EventFields.String((String)"context", List.of("history", "log"));
    private static final ClassEventField CLASS = EventFields.Class((String)"class");
    public static final BooleanEventField PARENT_COMMIT = EventFields.Boolean((String)"parent_commit");
    private static final VarargEventId ACTION_CALLED = GROUP.registerVarargEvent("action.called", new EventField[]{CONTEXT, EventFields.InputEventByAnAction, CLASS, PARENT_COMMIT});
    private static final StringEventField FILTER_NAME = EventFields.String((String)"filter_name", (List)ContainerUtil.map(VcsLogFilterCollection.STANDARD_KEYS, key2 -> key2.getName()));
    private static final VarargEventId FILTER_SET = GROUP.registerVarargEvent("filter.set", new EventField[]{CONTEXT, FILTER_NAME});
    private static final EventId1<FilterResetType> FILTER_RESET = GROUP.registerEvent("filter.reset", (EventField)EventFields.Enum((String)"type", FilterResetType.class));
    private static final EventId1<String> TABLE_CLICKED = GROUP.registerEvent("table.clicked", (EventField)EventFields.String((String)"target", List.of("node", "arrow", "root.column")));
    private static final EventId2<String, Boolean> HISTORY_SHOWN = GROUP.registerEvent("history.shown", (EventField)EventFields.String((String)"kind", List.of("multiple", "folder", "file")), (EventField)EventFields.Boolean((String)"has_revision"));
    private static final EventId COLUMN_RESET = GROUP.registerEvent("column.reset");
    private static final EventId TAB_NAVIGATED = GROUP.registerEvent("tab.navigated");
    private static final EventId IDLE_INDEXER_STARTED = GROUP.registerEvent("idle.indexer.started");
    private static final EventId PLACE_HISTORY_USED = GROUP.registerEvent("place.history.used");

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void triggerUsage(@NotNull AnActionEvent e, @NotNull Object action2) {
        if (e == null) {
            VcsLogUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        if (action2 == null) {
            VcsLogUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, action2, null);
    }

    public static void triggerUsage(@NotNull AnActionEvent e, @NotNull Object action2, @Nullable Consumer<? super List<EventPair<?>>> configurator) {
        if (e == null) {
            VcsLogUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        if (action2 == null) {
            VcsLogUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        ArrayList<Object> data2 = new ArrayList<Object>();
        data2.add(VcsLogUsageTriggerCollector.getContext(e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null));
        data2.add(EventFields.InputEventByAnAction.with((Object)e));
        data2.add(CLASS.with(action2.getClass()));
        if (configurator != null) {
            configurator.accept(data2);
        }
        ACTION_CALLED.log(e.getProject(), data2);
    }

    public static void triggerFilterSet(@NotNull String name) {
        if (name == null) {
            VcsLogUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        FILTER_SET.log(new EventPair[]{VcsLogUsageTriggerCollector.getContext(false), FILTER_NAME.with((Object)name)});
    }

    public static void triggerFilterReset(@NotNull FilterResetType resetType) {
        if (resetType == null) {
            VcsLogUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        FILTER_RESET.log((Object)resetType);
    }

    private static EventPair<String> getContext(boolean isFromHistory) {
        return CONTEXT.with((Object)(isFromHistory ? "history" : "log"));
    }

    public static void triggerFileHistoryUsage(@Nullable Project project2, @NotNull String kind, boolean hasRevision) {
        if (kind == null) {
            VcsLogUsageTriggerCollector.$$$reportNull$$$0(6);
        }
        HISTORY_SHOWN.log(project2, (Object)kind, (Object)hasRevision);
    }

    public static void triggerClick(@NonNls @NotNull String target) {
        if (target == null) {
            VcsLogUsageTriggerCollector.$$$reportNull$$$0(7);
        }
        TABLE_CLICKED.log((Object)target);
    }

    public static void triggerColumnReset(@Nullable Project project2) {
        COLUMN_RESET.log(project2);
    }

    public static void triggerTabNavigated(@Nullable Project project2) {
        TAB_NAVIGATED.log(project2);
    }

    public static void idleIndexerTriggered(@Nullable Project project2) {
        IDLE_INDEXER_STARTED.log(project2);
    }

    public static void triggerPlaceHistoryUsed(@Nullable Project project2) {
        PLACE_HISTORY_USED.log(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resetType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogUsageTriggerCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerFilterSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerFilterReset";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerFileHistoryUsage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerClick";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum FilterResetType {
        ALL_OPTION,
        CLOSE_BUTTON;

    }
}

