/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.highlighters;

import com.intellij.ui.ExperimentalUI;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogUserResolver;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogCommitList;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.Author;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.util.VcsUserUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collections;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MyCommitsHighlighter
implements VcsLogHighlighter {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUi myUi;
    @NotNull
    private final VcsLogUserResolver myResolver;
    private boolean myShouldHighlightUser;

    public MyCommitsHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi2, @NotNull VcsLogUserResolver userResolver) {
        if (logData == null) {
            MyCommitsHighlighter.$$$reportNull$$$0(0);
        }
        if (logUi2 == null) {
            MyCommitsHighlighter.$$$reportNull$$$0(1);
        }
        if (userResolver == null) {
            MyCommitsHighlighter.$$$reportNull$$$0(2);
        }
        this.myShouldHighlightUser = false;
        this.myLogData = logData;
        this.myUi = logUi2;
        this.myResolver = userResolver;
    }

    @Override
    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId2, @NotNull VcsShortCommitDetails details, int column, boolean isSelected) {
        Set<VcsUser> currentUsers;
        if (details == null) {
            MyCommitsHighlighter.$$$reportNull$$$0(3);
        }
        if (details instanceof LoadingDetails) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                MyCommitsHighlighter.$$$reportNull$$$0(4);
            }
            return vcsCommitStyle;
        }
        if (this.myShouldHighlightUser && (currentUsers = this.myResolver.resolveCurrentUser(details.getRoot())).contains(details.getAuthor())) {
            if (ExperimentalUI.isNewUI() && this.isAuthorColumnVisible() && !MyCommitsHighlighter.isAuthorColumn(column)) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
                if (vcsCommitStyle == null) {
                    MyCommitsHighlighter.$$$reportNull$$$0(5);
                }
                return vcsCommitStyle;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.bold();
            if (vcsCommitStyle == null) {
                MyCommitsHighlighter.$$$reportNull$$$0(6);
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            MyCommitsHighlighter.$$$reportNull$$$0(7);
        }
        return vcsCommitStyle;
    }

    private boolean isAuthorColumnVisible() {
        VcsLogUiEx ui2;
        VcsLogCommitList vcsLogCommitList;
        VcsLogUi vcsLogUi = this.myUi;
        if (vcsLogUi instanceof VcsLogUiEx && (vcsLogCommitList = (ui2 = (VcsLogUiEx)vcsLogUi).getTable()) instanceof VcsLogGraphTable) {
            VcsLogGraphTable table = (VcsLogGraphTable)vcsLogCommitList;
            return table.isColumnVisible(Author.INSTANCE);
        }
        return true;
    }

    private static boolean isAuthorColumn(int column) {
        return VcsLogColumnManager.getInstance().getModelIndex(Author.INSTANCE) == column;
    }

    @Override
    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (dataPack == null) {
            MyCommitsHighlighter.$$$reportNull$$$0(8);
        }
        this.myShouldHighlightUser = !this.isSingleUser() && !MyCommitsHighlighter.isFilteredByCurrentUser(dataPack.getFilters());
    }

    private boolean isSingleUser() {
        ObjectOpenCustomHashSet users = new ObjectOpenCustomHashSet(this.myLogData.getCurrentUser().values(), (Hash.Strategy)new VcsUserUtil.VcsUserHashingStrategy());
        return this.myLogData.getUserRegistry().all((Function1<? super VcsUser, Boolean>)((Function1)arg_0 -> MyCommitsHighlighter.lambda$isSingleUser$0((Set)users, arg_0)));
    }

    private static boolean isFilteredByCurrentUser(@NotNull VcsLogFilterCollection filters) {
        VcsLogUserFilter userFilter;
        if (filters == null) {
            MyCommitsHighlighter.$$$reportNull$$$0(9);
        }
        if ((userFilter = filters.get(VcsLogFilterCollection.USER_FILTER)) == null) {
            return false;
        }
        return Collections.singleton("*").containsAll(userFilter.getValuesAsText());
    }

    private static /* synthetic */ Boolean lambda$isSingleUser$0(Set users, VcsUser user) {
        return users.contains(user);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/highlighters/MyCommitsHighlighter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/highlighters/MyCommitsHighlighter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStyle";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFilteredByCurrentUser";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6, 7 -> new IllegalStateException(string2);
        };
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        @NonNls
        public static final String ID = "MY_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi2) {
            if (logData == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (logUi2 == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new MyCommitsHighlighter(logData, logUi2, logData.getUserNameResolver());
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            String string2 = VcsLogBundle.message("vcs.log.action.highlight.my.commits", new Object[0]);
            if (string2 == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logUi";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/highlighters/MyCommitsHighlighter$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/highlighters/MyCommitsHighlighter$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createHighlighter";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

