/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.warmup.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManagerListener;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.warmup.util.ChannelingProgressIndicator;
import com.intellij.warmup.util.WarmupLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/warmup/util/WarmupProgressListener;", "Lcom/intellij/openapi/progress/ProgressManagerListener;", "()V", "taskDurationMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "afterTaskFinished", "", "task", "Lcom/intellij/openapi/progress/Task;", "beforeTaskStart", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.warmup"})
public final class WarmupProgressListener
implements ProgressManagerListener {
    @NotNull
    private final ConcurrentHashMap<Integer, Long> taskDurationMap = new ConcurrentHashMap();

    public void beforeTaskStart(@NotNull Task task2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!(indicator instanceof ProgressIndicatorEx)) {
            return;
        }
        WarmupLogger.INSTANCE.logInfo("[IDE]: Task '" + task2.getTitle() + "' started");
        ((Map)this.taskDurationMap).put(System.identityHashCode(task2), System.currentTimeMillis());
        ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new ChannelingProgressIndicator("IDE"));
        super.beforeTaskStart(task2, indicator);
    }

    public void afterTaskFinished(@NotNull Task task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        long currentTime = System.currentTimeMillis();
        Long startTime = this.taskDurationMap.remove(System.identityHashCode(task2));
        String elapsedTimeSuffix = startTime == null ? "" : " in " + Formats.formatDuration((long)(currentTime - startTime));
        WarmupLogger.INSTANCE.logInfo("[IDE]: Task '" + task2.getTitle() + "' ended" + elapsedTimeSuffix);
    }
}

