/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.patterns.impl;

import com.intellij.webSymbols.WebSymbolNameSegment;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/webSymbols/patterns/impl/MatchResult;", "", "segment", "Lcom/intellij/webSymbols/WebSymbolNameSegment;", "(Lcom/intellij/webSymbols/WebSymbolNameSegment;)V", "segments", "", "(Ljava/util/List;)V", "end", "", "getEnd", "()I", "getSegments", "()Ljava/util/List;", "start", "getStart", "toString", "", "intellij.platform.webSymbols"})
public class MatchResult {
    @NotNull
    private final List<WebSymbolNameSegment> segments;
    private final int start;
    private final int end;

    public MatchResult(@NotNull List<WebSymbolNameSegment> segments) {
        boolean bl;
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = segments;
        boolean bl2 = bl = !((Collection)this.segments).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.start = ((WebSymbolNameSegment)CollectionsKt.first(this.segments)).getStart();
        this.end = ((WebSymbolNameSegment)CollectionsKt.last(this.segments)).getEnd();
    }

    @NotNull
    public final List<WebSymbolNameSegment> getSegments() {
        return this.segments;
    }

    public MatchResult(@NotNull WebSymbolNameSegment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        this(CollectionsKt.listOf((Object)segment));
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    @NotNull
    public String toString() {
        return this.segments.toString();
    }
}

