/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.utils;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J(\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J0\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J(\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/webSymbols/utils/NameCaseUtils;", "", "()V", "isCaseSeparator", "", "codePoint", "", "isRegularDigit", "toCamelCase", "", "str", "preserveConsecutiveUppercase", "pascalCase", "toKebabCase", "noHyphenBeforeDigit", "noHyphenBetweenDigitAndLowercase", "splitConsecutiveUppercase", "toPascalCase", "toSeparatorBasedCase", "separator", "", "noSeparatorBeforeDigit", "noSeparatorBetweenDigitAndLowercase", "toSnakeCase", "noUnderscoreBeforeDigit", "noUnderscoreBetweenDigitAndLowercase", "intellij.platform.webSymbols"})
public final class NameCaseUtils {
    @NotNull
    public static final NameCaseUtils INSTANCE = new NameCaseUtils();

    private NameCaseUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String toPascalCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toCamelCase(str, false, true);
    }

    @JvmStatic
    @NotNull
    public static final String toPascalCase(@NotNull String str, boolean preserveConsecutiveUppercase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toCamelCase(str, preserveConsecutiveUppercase, true);
    }

    @JvmStatic
    @NotNull
    public static final String toCamelCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toCamelCase(str, false, false);
    }

    @JvmStatic
    @NotNull
    public static final String toCamelCase(@NotNull String str, boolean preserveConsecutiveUppercase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toCamelCase(str, preserveConsecutiveUppercase, false);
    }

    @JvmStatic
    @NotNull
    public static final String toKebabCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toSeparatorBasedCase('-', str, false, false, false);
    }

    @JvmStatic
    @NotNull
    public static final String toKebabCase(@NotNull String str, boolean noHyphenBeforeDigit, boolean noHyphenBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toSeparatorBasedCase('-', str, noHyphenBeforeDigit, noHyphenBetweenDigitAndLowercase, splitConsecutiveUppercase);
    }

    @JvmStatic
    @NotNull
    public static final String toSnakeCase(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toSeparatorBasedCase('_', str, false, false, false);
    }

    @JvmStatic
    @NotNull
    public static final String toSnakeCase(@NotNull String str, boolean noUnderscoreBeforeDigit, boolean noUnderscoreBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return INSTANCE.toSeparatorBasedCase('_', str, noUnderscoreBeforeDigit, noUnderscoreBetweenDigitAndLowercase, splitConsecutiveUppercase);
    }

    private final String toCamelCase(String str, boolean preserveConsecutiveUppercase, boolean pascalCase) {
        StringBuilder result2 = new StringBuilder();
        int[] codePoints = str.codePoints().toArray();
        int n = codePoints.length;
        for (int i = 0; i < n; ++i) {
            int prevChar;
            int ch = codePoints[i];
            if (Character.isUpperCase(ch)) {
                prevChar = i > 0 ? codePoints[i - 1] : 0;
                int nextChar = i < codePoints.length - 1 ? codePoints[i + 1] : 0;
                if (((CharSequence)result2).length() == 0 && (pascalCase || preserveConsecutiveUppercase && Character.isUpperCase(nextChar)) || ((CharSequence)result2).length() > 0 && (preserveConsecutiveUppercase || this.isCaseSeparator(prevChar) || this.isRegularDigit(prevChar) || !Character.isUpperCase(prevChar) || Character.isLowerCase(nextChar))) {
                    result2.appendCodePoint(ch);
                    continue;
                }
                result2.appendCodePoint(Character.toLowerCase(ch));
                continue;
            }
            if (Character.isLowerCase(ch)) {
                prevChar = i > 0 ? codePoints[i - 1] : 0;
                if (((CharSequence)result2).length() == 0 && pascalCase || ((CharSequence)result2).length() > 0 && (this.isCaseSeparator(prevChar) || this.isRegularDigit(prevChar))) {
                    result2.appendCodePoint(Character.toUpperCase(ch));
                    continue;
                }
                result2.appendCodePoint(ch);
                continue;
            }
            if (this.isCaseSeparator(ch)) continue;
            result2.appendCodePoint(ch);
        }
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String toSeparatorBasedCase(char separator, String str, boolean noSeparatorBeforeDigit, boolean noSeparatorBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        StringBuilder result2 = new StringBuilder();
        int[] codePoints = str.codePoints().toArray();
        int n = codePoints.length;
        for (int i = 0; i < n; ++i) {
            int nextChar;
            int ch = codePoints[i];
            int prevChar = i > 0 ? codePoints[i - 1] : 0;
            int n2 = nextChar = i + 1 < codePoints.length ? codePoints[i + 1] : 0;
            if (this.isCaseSeparator(ch)) {
                if (this.isCaseSeparator(nextChar) || nextChar == 0 || !(((CharSequence)result2).length() > 0)) continue;
                result2.append(separator);
                continue;
            }
            if (Character.isUpperCase(ch)) {
                if (!this.isCaseSeparator(prevChar) && ((CharSequence)result2).length() > 0 && (this.isRegularDigit(prevChar) || !Character.isUpperCase(prevChar) || splitConsecutiveUppercase || Character.isLowerCase(nextChar))) {
                    result2.append(separator);
                }
                result2.appendCodePoint(Character.toLowerCase(ch));
                continue;
            }
            if (Character.isLowerCase(ch)) {
                if (!noSeparatorBetweenDigitAndLowercase && this.isRegularDigit(prevChar)) {
                    result2.append(separator);
                }
                result2.appendCodePoint(ch);
                continue;
            }
            if (!noSeparatorBeforeDigit && this.isRegularDigit(ch)) {
                if (!this.isCaseSeparator(prevChar) && !this.isRegularDigit(prevChar) && ((CharSequence)result2).length() > 0) {
                    result2.append(separator);
                }
                result2.appendCodePoint(ch);
                continue;
            }
            result2.appendCodePoint(ch);
        }
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final boolean isCaseSeparator(int codePoint) {
        return codePoint == 95 || codePoint == 46 || codePoint == 45 || codePoint == 32;
    }

    private final boolean isRegularDigit(int codePoint) {
        return 48 <= codePoint && codePoint <= 57;
    }
}

