/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaProjectSelfProviderFactory
implements JsonSchemaProviderFactory,
DumbAware {
    public static final int TOTAL_PROVIDERS = 3;
    private static final String SCHEMA_JSON_FILE_NAME = "schema.json";
    private static final String SCHEMA06_JSON_FILE_NAME = "schema06.json";
    private static final String SCHEMA07_JSON_FILE_NAME = "schema07.json";

    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project2) {
        if (project2 == null) {
            JsonSchemaProjectSelfProviderFactory.$$$reportNull$$$0(0);
        }
        List<JsonSchemaFileProvider> list2 = Arrays.asList(new MyJsonSchemaFileProvider(project2, SCHEMA_JSON_FILE_NAME), new MyJsonSchemaFileProvider(project2, SCHEMA06_JSON_FILE_NAME), new MyJsonSchemaFileProvider(project2, SCHEMA07_JSON_FILE_NAME));
        if (list2 == null) {
            JsonSchemaProjectSelfProviderFactory.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    public static final class MyJsonSchemaFileProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        @Nls
        private final String myFileName;

        public boolean isSchemaV4() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA_JSON_FILE_NAME.equals(this.myFileName);
        }

        public boolean isSchemaV6() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA06_JSON_FILE_NAME.equals(this.myFileName);
        }

        public boolean isSchemaV7() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA07_JSON_FILE_NAME.equals(this.myFileName);
        }

        private MyJsonSchemaFileProvider(@NotNull Project project2, @NotNull @Nls String fileName) {
            if (project2 == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(0);
            }
            if (fileName == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myFileName = fileName;
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file) {
            if (file == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(2);
            }
            if (this.myProject.isDisposed()) {
                return false;
            }
            JsonSchemaService service = JsonSchemaService.Impl.get(this.myProject);
            if (!service.isApplicableToFile(file)) {
                return false;
            }
            JsonSchemaVersion schemaVersion = service.getSchemaVersion(file);
            if (schemaVersion == null) {
                return false;
            }
            return switch (schemaVersion) {
                default -> throw new IncompatibleClassChangeError();
                case JsonSchemaVersion.SCHEMA_4 -> this.isSchemaV4();
                case JsonSchemaVersion.SCHEMA_6 -> this.isSchemaV6();
                case JsonSchemaVersion.SCHEMA_7 -> this.isSchemaV7();
            };
        }

        @Override
        public JsonSchemaVersion getSchemaVersion() {
            return this.isSchemaV4() ? JsonSchemaVersion.SCHEMA_4 : (this.isSchemaV7() ? JsonSchemaVersion.SCHEMA_7 : JsonSchemaVersion.SCHEMA_6);
        }

        @Override
        @NotNull
        public String getName() {
            String string2 = this.myFileName;
            if (string2 == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Override
        @Nullable
        public VirtualFile getSchemaFile() {
            return JsonSchemaProviderFactory.getResourceFile(JsonSchemaProjectSelfProviderFactory.class, "/jsonSchema/" + this.myFileName);
        }

        @Override
        @NotNull
        public SchemaType getSchemaType() {
            SchemaType schemaType = SchemaType.schema;
            if (schemaType == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(4);
            }
            return schemaType;
        }

        @Override
        @Nullable
        public String getRemoteSource() {
            return switch (this.myFileName) {
                case JsonSchemaProjectSelfProviderFactory.SCHEMA_JSON_FILE_NAME -> "http://json-schema.org/draft-04/schema";
                case JsonSchemaProjectSelfProviderFactory.SCHEMA06_JSON_FILE_NAME -> "http://json-schema.org/draft-06/schema";
                case JsonSchemaProjectSelfProviderFactory.SCHEMA07_JSON_FILE_NAME -> "http://json-schema.org/draft-07/schema";
                default -> null;
            };
        }

        @Override
        @NotNull
        public String getPresentableName() {
            String string2 = switch (this.myFileName) {
                case JsonSchemaProjectSelfProviderFactory.SCHEMA_JSON_FILE_NAME -> JsonBundle.message("schema.of.version", 4);
                case JsonSchemaProjectSelfProviderFactory.SCHEMA06_JSON_FILE_NAME -> JsonBundle.message("schema.of.version", 6);
                case JsonSchemaProjectSelfProviderFactory.SCHEMA07_JSON_FILE_NAME -> JsonBundle.message("schema.of.version", 7);
                default -> this.getName();
            };
            if (string2 == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(5);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5 -> new IllegalStateException(string2);
            };
        }
    }
}

