/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.fixes.AddMissingPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.RemoveProhibitedPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.SuggestEnumValuesFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonValidationError {
    private final @InspectionMessage String myMessage;
    private final FixableIssueKind myFixableIssueKind;
    private final IssueData myIssueData;
    private final JsonErrorPriority myPriority;

    public IssueData getIssueData() {
        return this.myIssueData;
    }

    public JsonErrorPriority getPriority() {
        return this.myPriority;
    }

    public JsonValidationError(@InspectionMessage String message2, FixableIssueKind fixableIssueKind, IssueData issueData, JsonErrorPriority priority2) {
        this.myMessage = message2;
        this.myFixableIssueKind = fixableIssueKind;
        this.myIssueData = issueData;
        this.myPriority = priority2;
    }

    @InspectionMessage
    public String getMessage() {
        return this.myMessage;
    }

    public FixableIssueKind getFixableIssueKind() {
        return this.myFixableIssueKind;
    }

    public LocalQuickFix @NotNull [] createFixes(@Nullable JsonLikeSyntaxAdapter quickFixAdapter) {
        LocalQuickFix[] localQuickFixArray;
        if (quickFixAdapter == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                JsonValidationError.$$$reportNull$$$0(0);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        switch (this.myFixableIssueKind) {
            case MissingProperty: {
                AddMissingPropertyFix[] addMissingPropertyFixArray = new AddMissingPropertyFix[1];
                localQuickFixArray = addMissingPropertyFixArray;
                addMissingPropertyFixArray[0] = new AddMissingPropertyFix((MissingMultiplePropsIssueData)this.myIssueData, quickFixAdapter);
                break;
            }
            case MissingOneOfProperty: 
            case MissingAnyOfProperty: {
                localQuickFixArray = (LocalQuickFix[])((MissingOneOfPropsIssueData)this.myIssueData).myExclusiveOptions.stream().map(d -> new AddMissingPropertyFix((MissingMultiplePropsIssueData)d, quickFixAdapter)).toArray(LocalQuickFix[]::new);
                break;
            }
            case ProhibitedProperty: {
                RemoveProhibitedPropertyFix[] removeProhibitedPropertyFixArray = new RemoveProhibitedPropertyFix[1];
                localQuickFixArray = removeProhibitedPropertyFixArray;
                removeProhibitedPropertyFixArray[0] = new RemoveProhibitedPropertyFix((ProhibitedPropertyIssueData)this.myIssueData, quickFixAdapter);
                break;
            }
            case NonEnumValue: {
                SuggestEnumValuesFix[] suggestEnumValuesFixArray = new SuggestEnumValuesFix[1];
                localQuickFixArray = suggestEnumValuesFixArray;
                suggestEnumValuesFixArray[0] = new SuggestEnumValuesFix(quickFixAdapter);
                break;
            }
            default: {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
        }
        if (localQuickFixArray == null) {
            JsonValidationError.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonValidationError", "createFixes"));
    }

    public static interface IssueData {
    }

    public static enum FixableIssueKind {
        MissingProperty,
        MissingOptionalProperty,
        MissingOneOfProperty,
        MissingAnyOfProperty,
        ProhibitedProperty,
        NonEnumValue,
        ProhibitedType,
        TypeMismatch,
        None;

    }

    public static final class MissingMultiplePropsIssueData
    implements IssueData {
        public final Collection<MissingPropertyIssueData> myMissingPropertyIssues;

        public MissingMultiplePropsIssueData(Collection<MissingPropertyIssueData> missingPropertyIssues) {
            this.myMissingPropertyIssues = missingPropertyIssues;
        }

        private static String getPropertyNameWithComment(MissingPropertyIssueData prop) {
            Object comment = "";
            if (prop.enumItemsCount == 1) {
                comment = " = " + prop.defaultValue.toString();
            }
            return "'" + prop.propertyName + "'" + (String)comment;
        }

        public String getMessage(boolean trimIfNeeded) {
            if (this.myMissingPropertyIssues.size() == 1) {
                MissingPropertyIssueData prop = this.myMissingPropertyIssues.iterator().next();
                return JsonBundle.message("schema.validation.property", MissingMultiplePropsIssueData.getPropertyNameWithComment(prop));
            }
            Collection<MissingPropertyIssueData> namesToDisplay = this.myMissingPropertyIssues;
            boolean trimmed = false;
            if (trimIfNeeded && namesToDisplay.size() > 3) {
                namesToDisplay = new ArrayList<MissingPropertyIssueData>();
                Iterator<MissingPropertyIssueData> iterator = this.myMissingPropertyIssues.iterator();
                for (int i = 0; i < 3; ++i) {
                    namesToDisplay.add(iterator.next());
                }
                trimmed = true;
            }
            Object allNames = this.myMissingPropertyIssues.stream().map(MissingMultiplePropsIssueData::getPropertyNameWithComment).sorted((s1, s2) -> {
                boolean secondHasEq;
                boolean firstHasEq = s1.contains("=");
                if (firstHasEq == (secondHasEq = s2.contains("="))) {
                    return s1.compareTo((String)s2);
                }
                return firstHasEq ? -1 : 1;
            }).collect(Collectors.joining(", "));
            if (trimmed) {
                allNames = (String)allNames + ", ...";
            }
            return JsonBundle.message("schema.validation.properties", allNames);
        }
    }

    public static final class MissingOneOfPropsIssueData
    implements IssueData {
        public final Collection<MissingMultiplePropsIssueData> myExclusiveOptions;

        public MissingOneOfPropsIssueData(Collection<MissingMultiplePropsIssueData> options) {
            this.myExclusiveOptions = options;
        }
    }

    public static final class ProhibitedPropertyIssueData
    implements IssueData {
        @NlsSafe
        public final String propertyName;

        public ProhibitedPropertyIssueData(@NlsSafe String propertyName) {
            this.propertyName = propertyName;
        }
    }

    public static final class TypeMismatchIssueData
    implements IssueData {
        public final JsonSchemaType[] expectedTypes;

        public TypeMismatchIssueData(JsonSchemaType[] expectedTypes) {
            this.expectedTypes = expectedTypes;
        }
    }

    public static final class MissingPropertyIssueData
    implements IssueData {
        public final String propertyName;
        public final JsonSchemaType propertyType;
        public final Object defaultValue;
        public final int enumItemsCount;

        public MissingPropertyIssueData(String propertyName, JsonSchemaType propertyType, Object defaultValue, int enumItemsCount) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.defaultValue = defaultValue;
            this.enumItemsCount = enumItemsCount;
        }
    }
}

