/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.Collection;

public final class NotValidation
implements JsonSchemaValidation {
    public static final NotValidation INSTANCE = new NotValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        MatchResult result2 = consumer.resolve(schema.getNot());
        if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
            return;
        }
        if (result2.mySchemas.stream().anyMatch(s -> schema.equals(s)) || result2.myExcludingSchemas.stream().flatMap(Collection::stream).anyMatch(s -> schema.equals(s))) {
            return;
        }
        JsonValidationHost checker = consumer.checkByMatchResult(propValue, result2, options.withForcedStrict());
        if (checker == null || checker.isValid()) {
            consumer.error(JsonBundle.message("schema.validation.against.not", new Object[0]), propValue.getDelegate(), JsonErrorPriority.NOT_SCHEMA);
        }
    }
}

