/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.relaxng.output.xsd.basic.AbstractAttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.Facet;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Occurs;
import com.thaiopensource.relaxng.output.xsd.basic.OptionalAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaTransformer;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.SingleAttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import com.thaiopensource.util.Equal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class Transformer
extends SchemaTransformer {
    private final AttributeMapper attributeMapper = new AttributeMapper();
    private final Set transformedAttributeGroups = new HashSet();
    private final ErrorReporter er;
    private boolean preserveAllGroup = false;

    Transformer(Schema schema, ErrorReporter errorReporter) {
        super(schema);
        this.er = errorReporter;
    }

    public Object visitUnion(SimpleTypeUnion simpleTypeUnion) {
        List list2 = this.transformSimpleTypeList(simpleTypeUnion.getChildren());
        SimpleType simpleType = Transformer.combineEnumeration(simpleTypeUnion, list2);
        if (simpleType != null) {
            return simpleType;
        }
        return new SimpleTypeUnion(simpleTypeUnion.getLocation(), simpleTypeUnion.getAnnotation(), list2);
    }

    private static SimpleType combineEnumeration(SimpleTypeUnion simpleTypeUnion, List list2) {
        if (list2.size() < 2) {
            return null;
        }
        Object e = list2.get(0);
        if (!(e instanceof SimpleTypeRestriction)) {
            return null;
        }
        String string2 = ((SimpleTypeRestriction)e).getName();
        Vector<Facet> vector = new Vector<Facet>();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof SimpleTypeRestriction)) {
                return null;
            }
            SimpleTypeRestriction simpleTypeRestriction = (SimpleTypeRestriction)e2;
            if (!simpleTypeRestriction.getName().equals(string2)) {
                return null;
            }
            if (simpleTypeRestriction.getFacets().isEmpty()) {
                return null;
            }
            Iterator iterator2 = simpleTypeRestriction.getFacets().iterator();
            while (iterator2.hasNext()) {
                Facet facet = (Facet)iterator2.next();
                if (!facet.getName().equals("enumeration")) {
                    return null;
                }
                vector.add(facet);
            }
        }
        return new SimpleTypeRestriction(simpleTypeUnion.getLocation(), simpleTypeUnion.getAnnotation(), string2, vector);
    }

    public Object visitAll(ParticleAll particleAll) {
        if (this.preserveAllGroup) {
            this.preserveAllGroup = false;
            return super.visitAll(particleAll);
        }
        return new ParticleRepeat(particleAll.getLocation(), particleAll.getAnnotation(), new ParticleChoice(particleAll.getLocation(), null, new AllBodyTransformer(this.getSchema()).transformParticleList(this.transformParticleList(particleAll.getChildren()))), Occurs.ZERO_OR_MORE);
    }

    public Object visitAttributeGroup(AttributeGroup attributeGroup) {
        Object object;
        List list2 = this.transformAttributeUseList(attributeGroup.getChildren());
        Object object2 = null;
        boolean[] blArray = new boolean[list2.size()];
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        while (n2 < blArray.length) {
            object = this.attributeMapper.getAttributeWildcard((AttributeUse)list2.get(n2));
            if (object != null) {
                if (object2 == null) {
                    object2 = object;
                    n = n2;
                } else {
                    bl = true;
                    Wildcard wildcard = Wildcard.union((Wildcard)object2, (Wildcard)object);
                    if (wildcard.equals(object2)) {
                        blArray[n2] = true;
                    } else if (wildcard.equals(object)) {
                        if (n >= 0) {
                            blArray[n] = true;
                        }
                        n = n2;
                        object2 = object;
                    } else {
                        blArray[n2] = true;
                        if (n >= 0) {
                            blArray[n] = true;
                        }
                        object2 = wildcard;
                        n = -1;
                    }
                }
            }
            ++n2;
        }
        if (!bl) {
            if (list2 == attributeGroup.getChildren()) {
                return attributeGroup;
            }
            return new AttributeGroup(attributeGroup.getLocation(), attributeGroup.getAnnotation(), list2);
        }
        object = new Vector();
        int n3 = 0;
        while (n3 < blArray.length) {
            AttributeUse attributeUse = (AttributeUse)list2.get(n3);
            if (blArray[n3]) {
                attributeUse = (AttributeUse)attributeUse.accept(new AttributeTransformer(null, null, false));
            }
            object.add(attributeUse);
            ++n3;
        }
        if (n == -1) {
            object.add(new WildcardAttribute(attributeGroup.getLocation(), null, (Wildcard)object2));
        }
        return new AttributeGroup(attributeGroup.getLocation(), attributeGroup.getAnnotation(), (List)object);
    }

    public Object visitAttributeUseChoice(AttributeUseChoice attributeUseChoice) {
        Object object;
        Object object2;
        Object object3;
        List list2 = this.transformAttributeUseList(attributeUseChoice.getChildren());
        Map[] mapArray = new Map[list2.size()];
        int n = -1;
        Object object4 = null;
        int n2 = 0;
        while (n2 < mapArray.length) {
            mapArray[n2] = this.attributeMapper.getAttributeMap((AttributeUse)list2.get(n2));
            object3 = this.attributeMapper.getAttributeWildcard((AttributeUse)list2.get(n2));
            if (object3 != null) {
                if (object4 == null) {
                    object4 = object3;
                    n = n2;
                } else {
                    object2 = Wildcard.union((Wildcard)object4, (Wildcard)object3);
                    if (!((Wildcard)object2).equals(object4)) {
                        n = ((Wildcard)object2).equals(object3) ? n2 : -1;
                        object4 = object2;
                    }
                }
            }
            ++n2;
        }
        object3 = new HashSet();
        object2 = new HashSet(mapArray[0].keySet());
        int n3 = 1;
        while (n3 < mapArray.length) {
            object2.addAll(mapArray[n3].keySet());
            ++n3;
        }
        Set[] setArray = new Set[list2.size()];
        int n4 = 0;
        while (n4 < setArray.length) {
            setArray[n4] = new HashSet();
            ++n4;
        }
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            if (object4 != null && ((Wildcard)object4).contains(name)) continue;
            object = new SingleAttributeUse[mapArray.length];
            int n5 = -1;
            boolean bl = true;
            int n6 = 0;
            while (n6 < mapArray.length) {
                object[n6] = (SingleAttributeUse)mapArray[n6].get(name);
                if (object[n6] != null) {
                    if (n5 >= 0) {
                        n5 = -2;
                    } else if (n5 == -1) {
                        n5 = n6;
                    }
                    if (object[n6].isOptional()) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                ++n6;
            }
            if (bl) {
                object3.add(name);
            }
            if (n5 < 0) {
                n5 = Transformer.chooseUseIndex(object);
            }
            if (n5 >= 0) {
                setArray[n5].add(name);
                continue;
            }
            Vector<SimpleType> vector2 = new Vector<SimpleType>();
            int n7 = 0;
            while (n7 < ((SingleAttributeUse[])object).length) {
                if (object[n7] != null && object[n7].getType() != null) {
                    vector2.add(object[n7].getType());
                }
                ++n7;
            }
            Attribute attribute = new Attribute(attributeUseChoice.getLocation(), null, name, (SimpleType)new SimpleTypeUnion(attributeUseChoice.getLocation(), null, vector2).accept(this));
            if (bl) {
                vector.add(attribute);
                continue;
            }
            vector.add(new OptionalAttribute(attributeUseChoice.getLocation(), null, attribute, null));
        }
        int n8 = 0;
        while (n8 < setArray.length) {
            object = ((AttributeUse)list2.get(n8)).accept(new AttributeTransformer(setArray[n8], (Set)object3, n8 == n));
            if (!object.equals(AttributeGroup.EMPTY)) {
                vector.add(object);
            }
            ++n8;
        }
        if (object4 != null && n == -1) {
            vector.add(new WildcardAttribute(attributeUseChoice.getLocation(), null, (Wildcard)object4));
        }
        return new AttributeGroup(attributeUseChoice.getLocation(), attributeUseChoice.getAnnotation(), vector);
    }

    private static int chooseUseIndex(SingleAttributeUse[] singleAttributeUseArray) {
        int n = 0;
        while (n < singleAttributeUseArray.length) {
            if (singleAttributeUseArray[n] != null && singleAttributeUseArray[n].getType() == null && singleAttributeUseArray[n].getDefaultValue() == null) {
                return n;
            }
            ++n;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < singleAttributeUseArray.length) {
            if (singleAttributeUseArray[n3] != null) {
                if (n2 == -1) {
                    n2 = n3;
                } else if (!Equal.equal(singleAttributeUseArray[n3].getType(), singleAttributeUseArray[n2].getType()) || !Equal.equal(singleAttributeUseArray[n3].getDefaultValue(), singleAttributeUseArray[n2].getDefaultValue())) {
                    return -1;
                }
            }
            ++n3;
        }
        return n2;
    }

    public void visitAttributeGroup(AttributeGroupDefinition attributeGroupDefinition) {
        attributeGroupDefinition.setAttributeUses(this.getTransformedAttributeGroup(attributeGroupDefinition.getName()));
    }

    private AttributeUse getTransformedAttributeGroup(String string2) {
        AttributeGroupDefinition attributeGroupDefinition = this.getSchema().getAttributeGroup(string2);
        if (!this.transformedAttributeGroups.contains(string2)) {
            attributeGroupDefinition.setAttributeUses((AttributeUse)attributeGroupDefinition.getAttributeUses().accept(this));
            this.transformedAttributeGroups.add(string2);
        }
        return attributeGroupDefinition.getAttributeUses();
    }

    public Object visitElement(Element element) {
        if (Transformer.containsLegalAllGroup(element)) {
            this.preserveAllGroup = true;
        }
        return super.visitElement(element);
    }

    private static boolean containsLegalAllGroup(Element element) {
        ComplexType complexType = element.getComplexType();
        if (!(complexType instanceof ComplexTypeComplexContent)) {
            return false;
        }
        Particle particle = ((ComplexTypeComplexContent)complexType).getParticle();
        if (!(particle instanceof ParticleAll)) {
            return false;
        }
        String string2 = element.getName().getNamespaceUri();
        Iterator iterator = ((ParticleAll)particle).getChildren().iterator();
        while (iterator.hasNext()) {
            Particle particle2 = (Particle)iterator.next();
            if (particle2 instanceof ParticleRepeat) {
                Occurs occurs = ((ParticleRepeat)particle2).getOccurs();
                if (occurs.getMin() > 1 || occurs.getMax() > 1) {
                    return false;
                }
                particle2 = ((ParticleRepeat)particle2).getChild();
            }
            if (!(particle2 instanceof Element)) {
                return false;
            }
            if (((Element)particle2).getName().getNamespaceUri().equals(string2)) continue;
            return false;
        }
        return true;
    }

    class AttributeTransformer
    extends AbstractAttributeUseVisitor {
        private final Set retainNames;
        private final Set requiredNames;
        private final boolean retainWildcard;

        public AttributeTransformer(Set set, Set set2, boolean bl) {
            this.retainNames = set;
            this.requiredNames = set2;
            this.retainWildcard = bl;
        }

        public Object visitAttribute(Attribute attribute) {
            if (this.retainNames != null && !this.retainNames.contains(attribute.getName())) {
                return AttributeGroup.EMPTY;
            }
            if (this.requiredNames != null && !this.requiredNames.contains(attribute.getName())) {
                return new OptionalAttribute(attribute.getLocation(), null, attribute, null);
            }
            return attribute;
        }

        public Object visitOptionalAttribute(OptionalAttribute optionalAttribute) {
            if (this.retainNames != null && !this.retainNames.contains(optionalAttribute.getName())) {
                return AttributeGroup.EMPTY;
            }
            return optionalAttribute;
        }

        public Object visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            if (!this.retainWildcard) {
                return AttributeGroup.EMPTY;
            }
            return wildcardAttribute;
        }

        public Object visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            AttributeUse attributeUse = Transformer.this.getTransformedAttributeGroup(attributeGroupRef.getName());
            if (this.isOk(Transformer.this.attributeMapper.getAttributeMap(attributeUse)) && (this.retainWildcard || Transformer.this.attributeMapper.getAttributeWildcard(attributeUse) == null)) {
                return attributeGroupRef;
            }
            return attributeUse.accept(this);
        }

        private boolean isOk(Map map2) {
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                Name name = (Name)entry2.getKey();
                SingleAttributeUse singleAttributeUse = (SingleAttributeUse)entry2.getValue();
                if (this.retainNames != null && !this.retainNames.contains(name)) {
                    return false;
                }
                if (this.requiredNames == null || singleAttributeUse.isOptional() || this.requiredNames.contains(name)) continue;
                return false;
            }
            return true;
        }

        public Object visitAttributeGroup(AttributeGroup attributeGroup) {
            List list2 = attributeGroup.getChildren();
            Vector<Object> vector = null;
            int n = 0;
            int n2 = list2.size();
            while (n < n2) {
                Object object = ((AttributeUse)list2.get(n)).accept(this);
                if (vector != null) {
                    if (!object.equals(AttributeGroup.EMPTY)) {
                        vector.add(object);
                    }
                } else if (object != list2.get(n)) {
                    vector = new Vector<Object>();
                    int n3 = 0;
                    while (n3 < n) {
                        vector.add(list2.get(n3));
                        ++n3;
                    }
                    if (!object.equals(AttributeGroup.EMPTY)) {
                        vector.add(object);
                    }
                }
                ++n;
            }
            if (vector == null) {
                return attributeGroup;
            }
            return new AttributeGroup(attributeGroup.getLocation(), attributeGroup.getAnnotation(), vector);
        }
    }

    class AttributeMapper
    extends AbstractAttributeUseVisitor {
        private final Map cache = new HashMap();

        AttributeMapper() {
        }

        Map getAttributeMap(AttributeUse attributeUse) {
            return this.getAttributeInfo((AttributeUse)attributeUse).map;
        }

        Wildcard getAttributeWildcard(AttributeUse attributeUse) {
            return this.getAttributeInfo((AttributeUse)attributeUse).wildcard;
        }

        private AttributeInfo getAttributeInfo(AttributeUse attributeUse) {
            AttributeInfo attributeInfo = (AttributeInfo)this.cache.get(attributeUse);
            if (attributeInfo == null) {
                attributeInfo = (AttributeInfo)attributeUse.accept(this);
                this.cache.put(attributeUse, attributeInfo);
            }
            return attributeInfo;
        }

        public Object visitAttribute(Attribute attribute) {
            HashMap<Name, Attribute> hashMap = new HashMap<Name, Attribute>();
            hashMap.put(attribute.getName(), attribute);
            return new AttributeInfo(hashMap, null);
        }

        public Object visitAttributeGroup(AttributeGroup attributeGroup) {
            HashMap hashMap = new HashMap();
            Wildcard wildcard = null;
            Iterator iterator = attributeGroup.getChildren().iterator();
            while (iterator.hasNext()) {
                AttributeInfo attributeInfo = this.getAttributeInfo((AttributeUse)iterator.next());
                if (attributeInfo.wildcard != null) {
                    wildcard = attributeInfo.wildcard;
                }
                hashMap.putAll(attributeInfo.map);
            }
            return new AttributeInfo(hashMap, wildcard);
        }

        public Object visitOptionalAttribute(OptionalAttribute optionalAttribute) {
            HashMap<Name, OptionalAttribute> hashMap = new HashMap<Name, OptionalAttribute>();
            hashMap.put(optionalAttribute.getAttribute().getName(), optionalAttribute);
            return new AttributeInfo(hashMap, null);
        }

        public Object visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            return this.getAttributeInfo(Transformer.this.getTransformedAttributeGroup(attributeGroupRef.getName()));
        }

        public Object visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            return new AttributeInfo(Collections.EMPTY_MAP, wildcardAttribute.getWildcard());
        }
    }

    static class AttributeInfo {
        final Map map;
        final Wildcard wildcard;

        AttributeInfo(Map map2, Wildcard wildcard) {
            this.map = map2;
            this.wildcard = wildcard;
        }
    }

    class AllBodyTransformer
    extends SchemaTransformer {
        public AllBodyTransformer(Schema schema) {
            super(schema);
        }

        public Object visitGroupRef(GroupRef groupRef) {
            if (new SequenceDetector().visitGroupRef(groupRef) == Boolean.FALSE) {
                return groupRef;
            }
            return this.getSchema().getGroup(groupRef.getName()).getParticle().accept(this);
        }

        public Object visitSequence(ParticleSequence particleSequence) {
            return new ParticleChoice(particleSequence.getLocation(), particleSequence.getAnnotation(), this.transformParticleList(particleSequence.getChildren()));
        }

        public Object visitRepeat(ParticleRepeat particleRepeat) {
            return particleRepeat.getChild().accept(this);
        }

        public Object visitElement(Element element) {
            return Transformer.this.visitElement(element);
        }
    }

    class SequenceDetector
    implements ParticleVisitor {
        SequenceDetector() {
        }

        public Object visitElement(Element element) {
            return Boolean.FALSE;
        }

        public Object visitWildcardElement(WildcardElement wildcardElement) {
            return Boolean.FALSE;
        }

        public Object visitSequence(ParticleSequence particleSequence) {
            return Boolean.TRUE;
        }

        public Object visitGroupRef(GroupRef groupRef) {
            return Transformer.this.getSchema().getGroup(groupRef.getName()).getParticle().accept(this);
        }

        public Object visitAll(ParticleAll particleAll) {
            return Boolean.FALSE;
        }

        public Object visitRepeat(ParticleRepeat particleRepeat) {
            return particleRepeat.getChild().accept(this);
        }

        public Object visitChoice(ParticleChoice particleChoice) {
            Iterator iterator = particleChoice.getChildren().iterator();
            while (iterator.hasNext()) {
                if (((Particle)iterator.next()).accept(this) != Boolean.TRUE) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

