/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0014"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "collectData", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "suggestBranchName", "", "repository", "Lgit4idea/repo/GitRepository;", "branches", "", "Lcom/intellij/vcs/log/VcsRef;", "update", "Data", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCreateNewBranchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCreateNewBranchAction.kt\ngit4idea/actions/GitCreateNewBranchAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1747#3,3:110\n766#3:113\n857#3,2:114\n1549#3:116\n1620#3,3:117\n*S KotlinDebug\n*F\n+ 1 GitCreateNewBranchAction.kt\ngit4idea/actions/GitCreateNewBranchAction\n*L\n88#1:110,3\n95#1:113\n95#1:114,2\n96#1:116\n96#1:117,3\n*E\n"})
public final class GitCreateNewBranchAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Data data2 = this.collectData(e);
        if (data2 instanceof Data.WithCommit) {
            Project project = ((Data.WithCommit)data2).getRepository().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            List list2 = CollectionsKt.listOf((Object)((Data.WithCommit)data2).getRepository());
            String string = ((Data.WithCommit)data2).getHash().toString();
            Object[] objectArray = new Object[]{((Data.WithCommit)data2).getHash().toShortString()};
            String string2 = GitBundle.message("action.Git.New.Branch.dialog.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(project, list2, string, string2, ((Data.WithCommit)data2).getName());
        } else if (data2 instanceof Data.NoCommit) {
            GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(((Data.NoCommit)data2).getProject(), ((Data.NoCommit)data2).getRepositories(), "HEAD", null, MultiRootBranches.getCommonCurrentBranch((Collection)((Data.NoCommit)data2).getRepositories()), 8, null);
        } else if (data2 instanceof Data.Disabled ? true : Intrinsics.areEqual((Object)data2, (Object)Data.Invisible.INSTANCE)) {
            // empty if block
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Data data2 = this.collectData(e);
        if (data2 instanceof Data.Invisible) {
            e.getPresentation().setEnabledAndVisible(false);
        } else if (data2 instanceof Data.Disabled) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription(((Data.Disabled)data2).getDescription());
        } else {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    private final Data collectData(AnActionEvent e) {
        List repositories2;
        Project project;
        block21: {
            block20: {
                boolean bl;
                block19: {
                    GitRepository repository;
                    Project project2 = e.getProject();
                    if (project2 == null) {
                        return Data.Invisible.INSTANCE;
                    }
                    project = project2;
                    GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(...)");
                    GitRepositoryManager manager2 = gitRepositoryManager;
                    if (manager2.getRepositories().isEmpty()) {
                        return Data.Invisible.INSTANCE;
                    }
                    VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
                    if (selection != null) {
                        if (VcsLogCommitSelectionUtils.isEmpty((VcsLogCommitSelection)selection)) {
                            return Data.Invisible.INSTANCE;
                        }
                        if (VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)selection) > 1) {
                            String string = GitBundle.message("action.New.Branch.disabled.several.commits.description", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            return new Data.Disabled(string);
                        }
                        CommitId commit = (CommitId)CollectionsKt.first((List)selection.getCommits());
                        repository = (GitRepository)manager2.getRepositoryForRootQuick(commit.getRoot());
                        if (repository != null) {
                            String initialName = this.suggestBranchName(repository, (List)e.getData(VcsLogDataKeys.VCS_LOG_BRANCHES));
                            Hash hash = commit.getHash();
                            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
                            return new Data.WithCommit(repository, hash, initialName);
                        }
                    }
                    if (manager2.moreThanOneRoot()) {
                        if (GitVcsSettings.getInstance(project).getSyncSetting() == DvcsSyncSettings.Value.SYNC) {
                            v4 = manager2.getRepositories();
                        } else {
                            GitRepository gitRepository = repository = GitBranchUtil.guessRepositoryForOperation(project, e.getDataContext());
                            if (gitRepository != null) {
                                GitRepository it = gitRepository;
                                boolean bl2 = false;
                                v4 = CollectionsKt.listOf((Object)repository);
                            } else {
                                v4 = null;
                            }
                        }
                    } else {
                        List<GitRepository> list2 = manager2.getRepositories();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRepositories(...)");
                        v4 = repositories2 = CollectionsKt.listOf((Object)CollectionsKt.first(list2));
                    }
                    if (repositories2 == null) break block20;
                    Iterable $this$any$iv = repositories2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            GitRepository it = (GitRepository)element$iv;
                            boolean bl3 = false;
                            if (!it.isFresh()) continue;
                            bl = true;
                            break block19;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block21;
            }
            String string = GitBundle.message("action.New.Branch.disabled.fresh.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new Data.Disabled(string);
        }
        return new Data.NoCommit(project, repositories2);
    }

    /*
     * WARNING - void declaration
     */
    private final String suggestBranchName(GitRepository repository, List<? extends VcsRef> branches2) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List list2 = branches2;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable iterable = list2;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsRef it = (VcsRef)element$iv$iv;
            boolean bl = false;
            if (!it.getType().isBranch()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingBranches = (List)destination$iv$iv;
        Iterable $this$map$iv = existingBranches;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            VcsRef bl = (VcsRef)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            if (repository.getBranches().findBranchByName(it.getName()) == null) {
                string = null;
            } else {
                GitBranch gitBranch;
                Intrinsics.checkNotNull((Object)gitBranch);
                GitBranch branch = gitBranch;
                string = branch.isRemote() ? ((GitRemoteBranch)branch).getNameForRemoteOperations() : branch.getName();
            }
            collection.add(string);
        }
        List suggestedNames = (List)destination$iv$iv2;
        return (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)suggestedNames));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data;", "", "()V", "Disabled", "Invisible", "NoCommit", "WithCommit", "Lgit4idea/actions/GitCreateNewBranchAction$Data$Disabled;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$Invisible;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$NoCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data$WithCommit;", "intellij.vcs.git"})
    private static abstract class Data {
        private Data() {
        }

        public /* synthetic */ Data(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0012\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$Disabled;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "description", "", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Disabled
        extends Data {
            @NotNull
            private final String description;

            public Disabled(@NotNull String description2) {
                Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
                super(null);
                this.description = description2;
            }

            @NotNull
            public final String getDescription() {
                return this.description;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$Invisible;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "()V", "intellij.vcs.git"})
        public static final class Invisible
        extends Data {
            @NotNull
            public static final Invisible INSTANCE = new Invisible();

            private Invisible() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$NoCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepositories", "()Ljava/util/List;", "intellij.vcs.git"})
        public static final class NoCommit
        extends Data {
            @NotNull
            private final Project project;
            @NotNull
            private final List<GitRepository> repositories;

            public NoCommit(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
                super(null);
                this.project = project;
                this.repositories = repositories2;
            }

            @NotNull
            public final Project getProject() {
                return this.project;
            }

            @NotNull
            public final List<GitRepository> getRepositories() {
                return this.repositories;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lgit4idea/actions/GitCreateNewBranchAction$Data$WithCommit;", "Lgit4idea/actions/GitCreateNewBranchAction$Data;", "repository", "Lgit4idea/repo/GitRepository;", "hash", "Lcom/intellij/vcs/log/Hash;", "name", "", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/Hash;Ljava/lang/String;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getName", "()Ljava/lang/String;", "getRepository", "()Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
        public static final class WithCommit
        extends Data {
            @NotNull
            private final GitRepository repository;
            @NotNull
            private final Hash hash;
            @Nullable
            private final String name;

            public WithCommit(@NotNull GitRepository repository, @NotNull Hash hash, @Nullable String name) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                super(null);
                this.repository = repository;
                this.hash = hash;
                this.name = name;
            }

            @NotNull
            public final GitRepository getRepository() {
                return this.repository;
            }

            @NotNull
            public final Hash getHash() {
                return this.hash;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }
        }
    }
}

