/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.CachingFileTester;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.text.ParseException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableManager {
    private static final Logger LOG = Logger.getInstance(GitExecutableManager.class);
    @NotNull
    private final GitExecutableDetector myExecutableDetector = new GitExecutableDetector();
    @NotNull
    private final CachingFileTester myVersionCache = new CachingFileTester(){

        @Override
        @NotNull
        protected GitVersion testExecutable(@NotNull GitExecutable executable) throws VcsException, ParseException {
            if (executable == null) {
                1.$$$reportNull$$$0(0);
            }
            GitVersion gitVersion = GitExecutableManager.doGetGitVersion(executable);
            if (gitVersion == null) {
                1.$$$reportNull$$$0(1);
            }
            return gitVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/config/GitExecutableManager$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/config/GitExecutableManager$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "testExecutable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "testExecutable";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    @Topic.AppLevel
    public static final Topic<GitExecutableListener> TOPIC = new Topic(GitExecutableListener.class, Topic.BroadcastDirection.NONE);

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ApplicationManager.getApplication().getService(GitExecutableManager.class);
    }

    private static GitVersion doGetGitVersion(@NotNull GitExecutable executable) throws VcsException, ParseException {
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(0);
        }
        GitVersion.Type type = null;
        if (executable instanceof GitExecutable.Unknown) {
            type = GitVersion.Type.UNDEFINED;
        } else if (executable instanceof GitExecutable.Wsl) {
            WSLDistribution distribution = ((GitExecutable.Wsl)executable).getDistribution();
            type = distribution.getVersion() == 1 ? GitVersion.Type.WSL1 : GitVersion.Type.WSL2;
        }
        LOG.debug("Acquiring git version for " + executable);
        GitLineHandler handler = new GitLineHandler(null, new File("."), executable, GitCommand.VERSION, Collections.emptyList());
        handler.setPreValidateExecutable(false);
        handler.setSilent(false);
        handler.setTerminationTimeout(1000);
        handler.setStdoutSuppressed(false);
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String rawResult = result2.getOutputOrThrow(new int[0]);
        GitVersion version = GitVersion.parse(rawResult, type);
        LOG.info("Git version for " + executable + ": " + version);
        return version;
    }

    @NotNull
    public String getPathToGit() {
        String string = this.getPathToGit(null);
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPathToGit(@Nullable Project project) {
        String pathToGit = this.getPathToGit(project, null, true);
        if (pathToGit == null) {
            pathToGit = GitExecutableDetector.getDefaultExecutable();
        }
        String string = pathToGit;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private String getPathToGit(@Nullable Project project, @Nullable File gitDirectory, boolean detectIfNeeded) {
        String path = null;
        if (project != null && (project.isDefault() || TrustedProjects.isTrusted((Project)project))) {
            path = GitVcsSettings.getInstance(project).getPathToGit();
        }
        if (path == null) {
            path = GitVcsApplicationSettings.getInstance().getSavedPathToGit();
        }
        if (path == null) {
            WSLDistribution distribution = gitDirectory != null ? WslPath.getDistributionByWindowsUncPath((String)gitDirectory.getPath()) : GitExecutableManager.getProjectWslDistribution(project);
            path = this.myExecutableDetector.getExecutable(distribution, detectIfNeeded);
        }
        return path;
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project) {
        GitExecutable gitExecutable = this.getExecutable(project, null);
        if (gitExecutable == null) {
            GitExecutableManager.$$$reportNull$$$0(3);
        }
        return gitExecutable;
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project, @Nullable File gitDirectory) {
        String path = this.getPathToGit(project, gitDirectory, true);
        if (path == null) {
            path = GitExecutableDetector.getDefaultExecutable();
        }
        GitExecutable gitExecutable = this.getExecutable(path);
        if (gitExecutable == null) {
            GitExecutableManager.$$$reportNull$$$0(4);
        }
        return gitExecutable;
    }

    @NotNull
    public GitExecutable getExecutable(@NotNull String pathToGit) {
        WslPath wslPath;
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(5);
        }
        if ((wslPath = WslPath.parseWindowsUncPath((String)pathToGit)) != null) {
            return new GitExecutable.Wsl(wslPath.getLinuxPath(), wslPath.getDistribution());
        }
        return new GitExecutable.Local(pathToGit);
    }

    public static boolean supportWslExecutable() {
        return WSLUtil.isSystemCompatible() && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser");
    }

    @Nullable
    private static WSLDistribution getProjectWslDistribution(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        return WslPath.getDistributionByWindowsUncPath((String)basePath);
    }

    @Nullable
    public String getDetectedExecutable(@Nullable Project project, boolean detectIfNeeded) {
        WSLDistribution distribution = GitExecutableManager.getProjectWslDistribution(project);
        return this.myExecutableDetector.getExecutable(distribution, detectIfNeeded);
    }

    @RequiresBackgroundThread
    public void dropExecutableCache() {
        ThreadingAssertions.assertBackgroundThread();
        this.myExecutableDetector.clear();
    }

    @NotNull
    public GitVersion getVersion(@NotNull Project project) {
        String pathToGit;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(6);
        }
        if ((pathToGit = this.getPathToGit(project, null, false)) == null) {
            GitVersion gitVersion = GitVersion.NULL;
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(7);
            }
            return gitVersion;
        }
        GitExecutable executable = this.getExecutable(pathToGit);
        GitVersion gitVersion = this.getVersion(executable);
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(8);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion getVersion(@NotNull GitExecutable executable) {
        CachingFileTester.TestResult result2;
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(9);
        }
        if ((result2 = this.myVersionCache.getCachedResultFor(executable)) == null || result2.getResult() == null) {
            GitVersion gitVersion = GitVersion.NULL;
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(10);
            }
            return gitVersion;
        }
        GitVersion gitVersion = result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(11);
        }
        return gitVersion;
    }

    @RequiresEdt
    @NotNull
    public GitVersion getVersionUnderModalProgressOrCancel(@NotNull Project project) throws ProcessCanceledException {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        GitVersion gitVersion = (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GitVersion version;
            GitExecutable executable = this.getExecutable(project);
            try {
                version = this.identifyVersion(executable);
            }
            catch (GitVersionIdentificationException e) {
                throw new ProcessCanceledException();
            }
            return version;
        }, GitBundle.message("git.executable.version.progress.title", new Object[0]), true, project);
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(13);
        }
        return gitVersion;
    }

    @Nullable
    public GitVersion tryGetVersion(@NotNull Project project) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(14);
        }
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.message("git.executable.version.progress.title", new Object[0]), () -> {
            try {
                GitExecutable executable = this.getExecutable(project);
                return this.identifyVersion(executable);
            }
            catch (ProcessCanceledException | GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    @Nullable
    public GitVersion tryGetVersion(@Nullable Project project, @NotNull GitExecutable executable) {
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(15);
        }
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.message("git.executable.version.progress.title", new Object[0]), () -> {
            try {
                return this.identifyVersion(executable);
            }
            catch (ProcessCanceledException | GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    static <T> T runUnderProgressIfNeeded(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String title, @NotNull ThrowableComputable<T, RuntimeException> task) {
        if (title == null) {
            GitExecutableManager.$$$reportNull$$$0(16);
        }
        if (task == null) {
            GitExecutableManager.$$$reportNull$$$0(17);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(task, title, true, project);
        }
        return (T)task.compute();
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion getVersionOrIdentifyIfNeeded(@NotNull Project project) {
        GitVersion version;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(18);
        }
        if ((version = this.getVersion(project)).isNull()) {
            version = this.tryGetVersion(project);
        }
        GitVersion gitVersion = version != null ? version : GitVersion.NULL;
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(19);
        }
        return gitVersion;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion identifyVersion(@NotNull String pathToGit) throws GitVersionIdentificationException {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(20);
        }
        GitVersion gitVersion = this.identifyVersion(this.getExecutable(pathToGit));
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(21);
        }
        return gitVersion;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion identifyVersion(@NotNull GitExecutable executable) throws GitVersionIdentificationException {
        CachingFileTester.TestResult result2;
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(22);
        }
        if ((result2 = this.myVersionCache.getResultFor(executable)).getResult() == null) {
            Exception e = result2.getException();
            if (e instanceof NoSuchFileException && executable.getExePath().equals(GitExecutableDetector.getDefaultExecutable())) {
                throw new GitNotInstalledException(GitBundle.message("executable.error.git.not.installed", new Object[0]), e);
            }
            throw new GitVersionIdentificationException(GitBundle.message("git.executable.validation.cant.identify.executable.message", executable), e);
        }
        GitVersion gitVersion = result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(23);
        }
        return gitVersion;
    }

    public void dropVersionCache(@NotNull GitExecutable executable) {
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(24);
        }
        this.myVersionCache.dropCache(executable);
    }

    @RequiresBackgroundThread
    public boolean testGitExecutableVersionValid(@NotNull Project project) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.assertBackgroundThread();
        GitExecutable executable = this.getExecutable(project);
        GitVersion version = this.identifyVersionOrDisplayError(project, executable);
        if (version == null) {
            return false;
        }
        GitExecutableProblemsNotifier executableProblemsNotifier = GitExecutableProblemsNotifier.getInstance(project);
        if (version.isSupported()) {
            executableProblemsNotifier.expireNotifications();
            return true;
        }
        GitExecutableProblemHandlersKt.showUnsupportedVersionError(project, version, new NotificationErrorNotifier(project));
        return false;
    }

    @RequiresBackgroundThread
    @Nullable
    private GitVersion identifyVersionOrDisplayError(@NotNull Project project, @NotNull GitExecutable executable) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(26);
        }
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertBackgroundThread();
        try {
            return this.identifyVersion(executable);
        }
        catch (GitVersionIdentificationException e) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7, 8, 10, 11, 13, 19, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToGit";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 18: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToGit";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionUnderModalProgressOrCancel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionOrIdentifyIfNeeded";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetGitVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 19: 
            case 21: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExecutable";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVersionUnderModalProgressOrCancel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryGetVersion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgressIfNeeded";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getVersionOrIdentifyIfNeeded";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "dropVersionCache";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "testGitExecutableVersionValid";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersionOrDisplayError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7, 8, 10, 11, 13, 19, 21, 23 -> new IllegalStateException(string);
        };
    }
}

