/*
 * Decompiled with CFR 0.152.
 */
package git4idea.console;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.console.VcsConsoleFolding;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/console/GitConsoleFolding;", "Lcom/intellij/vcs/console/VcsConsoleFolding;", "()V", "CONFIG_OPTIONS_REGEX", "Ljava/util/regex/Pattern;", "GIT_LINE_REGEX", "getFoldingsForLine", "", "Lcom/intellij/vcs/console/VcsConsoleFolding$Placeholder;", "project", "Lcom/intellij/openapi/project/Project;", "line", "", "isGitCommandLine", "", "intellij.vcs.git"})
public final class GitConsoleFolding
implements VcsConsoleFolding {
    @NotNull
    private final Pattern CONFIG_OPTIONS_REGEX;
    @NotNull
    private final Pattern GIT_LINE_REGEX;

    public GitConsoleFolding() {
        Pattern pattern = Pattern.compile("(\\s-c\\s[\\w.]+=[^ ]*)+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.CONFIG_OPTIONS_REGEX = pattern;
        Pattern pattern2 = Pattern.compile("\\[.*] git ");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        this.GIT_LINE_REGEX = pattern2;
    }

    @NotNull
    public List<VcsConsoleFolding.Placeholder> getFoldingsForLine(@NotNull Project project, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!this.isGitCommandLine(line)) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        Matcher matcher = this.CONFIG_OPTIONS_REGEX.matcher(line);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        while (matcher2.find()) {
            int end;
            int start = matcher2.start();
            if (start < (end = matcher2.end()) && StringUtil.isWhiteSpace((char)line.charAt(start))) {
                ++start;
            }
            if (start >= end) continue;
            result2.add(new VcsConsoleFolding.Placeholder("-c ...", new TextRange(start, end)));
        }
        return result2;
    }

    private final boolean isGitCommandLine(String line) {
        return this.GIT_LINE_REGEX.matcher(line).find();
    }
}

