/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.execution.CommandLineUtil;
import com.intellij.externalProcessAuthHelper.ScriptGenerator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import git4idea.GitUtil;
import git4idea.commands.GitHandler;
import git4idea.commands.GitScriptGenerator;
import git4idea.config.GitExecutable;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class GitHandlerRebaseEditorManager
implements AutoCloseable {
    private static final Logger LOG = Logger.getInstance(GitHandlerRebaseEditorManager.class);
    @NotNull
    private final GitHandler myHandler;
    @NotNull
    private final GitRebaseEditorHandler myEditorHandler;
    @NotNull
    private final GitRebaseEditorService myService;
    private final Disposable myDisposable;

    @NotNull
    public static GitHandlerRebaseEditorManager prepareEditor(GitHandler h, @NotNull GitRebaseEditorHandler editorHandler) {
        if (editorHandler == null) {
            GitHandlerRebaseEditorManager.$$$reportNull$$$0(0);
        }
        GitHandlerRebaseEditorManager manager2 = new GitHandlerRebaseEditorManager(h, editorHandler);
        GitUtil.tryRunOrClose(manager2, () -> manager2.prepareEditor());
        GitHandlerRebaseEditorManager gitHandlerRebaseEditorManager = manager2;
        if (gitHandlerRebaseEditorManager == null) {
            GitHandlerRebaseEditorManager.$$$reportNull$$$0(1);
        }
        return gitHandlerRebaseEditorManager;
    }

    private GitHandlerRebaseEditorManager(@NotNull GitHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        if (handler == null) {
            GitHandlerRebaseEditorManager.$$$reportNull$$$0(2);
        }
        if (editorHandler == null) {
            GitHandlerRebaseEditorManager.$$$reportNull$$$0(3);
        }
        this.myDisposable = Disposer.newDisposable();
        this.myHandler = handler;
        this.myEditorHandler = editorHandler;
        this.myService = GitRebaseEditorService.getInstance();
    }

    private void prepareEditor() {
        if (this.myHandler.containsCustomEnvironmentVariable("GIT_EDITOR")) {
            return;
        }
        try {
            GitExecutable executable = this.myHandler.getExecutable();
            UUID handlerId = this.myService.registerHandler(this.myEditorHandler, executable, this.myDisposable);
            int port = this.myService.getIdePort();
            File scriptFile = this.myService.getCallbackScriptPath(executable.getId(), (ScriptGenerator)new GitScriptGenerator(executable), false);
            String scriptPath = executable.convertFilePath(scriptFile);
            this.myHandler.addCustomEnvironmentVariable("GIT_EDITOR", CommandLineUtil.posixQuote((String)scriptPath));
            this.myHandler.addCustomEnvironmentVariable("INTELLIJ_REBASE_HANDER_NO", handlerId.toString());
            this.myHandler.addCustomEnvironmentVariable("INTELLIJ_REBASE_HANDER_PORT", Integer.toString(port));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void close() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitHandlerRebaseEditorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitHandlerRebaseEditorManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareEditor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

