/*
 * Decompiled with CFR 0.152.
 */
package git4idea.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class GitRootChecker
extends VcsRootChecker {
    GitRootChecker() {
    }

    public boolean isRoot(@NotNull VirtualFile path) {
        if (path == null) {
            GitRootChecker.$$$reportNull$$$0(0);
        }
        return path.findChild(".git") != null && GitUtil.isGitRoot(path.toNioPath());
    }

    public boolean validateRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GitRootChecker.$$$reportNull$$$0(1);
        }
        return GitUtil.isGitRoot(file2.toNioPath());
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            GitRootChecker.$$$reportNull$$$0(2);
        }
        return vcsKey;
    }

    public boolean isVcsDir(@NotNull String dirName) {
        if (dirName == null) {
            GitRootChecker.$$$reportNull$$$0(3);
        }
        return dirName.equalsIgnoreCase(".git");
    }

    public boolean isIgnored(@NotNull VirtualFile root, @NotNull VirtualFile checkForIgnore) {
        if (root == null) {
            GitRootChecker.$$$reportNull$$$0(4);
        }
        if (checkForIgnore == null) {
            GitRootChecker.$$$reportNull$$$0(5);
        }
        GitLineHandler handler = new GitLineHandler(null, root, GitCommand.CHECK_IGNORE);
        handler.addParameters("--quiet");
        handler.addRelativeFiles(Collections.singletonList(checkForIgnore));
        return Git.getInstance().runCommand(handler).success();
    }

    @NotNull
    public List<VirtualFile> suggestDependentRoots(@NotNull VirtualFile vcsRoot) {
        ArrayList<VirtualFile> arrayList;
        GitCommandResult result2;
        block9: {
            if (vcsRoot == null) {
                GitRootChecker.$$$reportNull$$$0(6);
            }
            GitLineHandler handler = new GitLineHandler(null, vcsRoot, GitCommand.SUBMODULE_HELPER);
            handler.addParameters("list");
            result2 = Git.getInstance().runCommand(handler);
            if (result2.success()) break block9;
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                GitRootChecker.$$$reportNull$$$0(7);
            }
            return list2;
        }
        try {
            ArrayList<VirtualFile> submodules = new ArrayList<VirtualFile>();
            for (String line : result2.getOutput()) {
                StringScanner scanner = new StringScanner(line);
                scanner.tabToken();
                String path = scanner.line();
                ContainerUtil.addIfNotNull(submodules, (Object)VcsUtil.getFilePath((VirtualFile)vcsRoot, (String)path).getVirtualFile());
            }
            arrayList = submodules;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(GitRootChecker.class).warn((Throwable)e);
            List<VirtualFile> list3 = Collections.emptyList();
            if (list3 == null) {
                GitRootChecker.$$$reportNull$$$0(9);
            }
            return list3;
        }
        if (arrayList == null) {
            GitRootChecker.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/roots/GitRootChecker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkForIgnore";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/roots/GitRootChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestDependentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validateRoot";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isVcsDir";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestDependentRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

