/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.impl;

import com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.IRegistryKey;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.impl.RegistryRoot;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.registryUtils.impl.RegistryRootKt;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.List;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0016\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0003H\u0016JG\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0015\"\u00020\u00032\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u00130\u0017j\b\u0012\u0004\u0012\u0002H\u0013`\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/registryUtils/impl/RegistryKey;", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/registryUtils/IRegistryKey;", "key", "", "registryRoot", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/registryUtils/impl/RegistryRoot;", "(Ljava/lang/String;Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/registryUtils/impl/RegistryRoot;)V", "getKey", "()Ljava/lang/String;", "getKeys", "", "getStringValue", "value", "getValues", "Ljava/util/TreeMap;", "", "inChild", "child", "tryExecuteWithHKEY", "T", "args", "", "action", "Lkotlin/Function1;", "Lcom/sun/jna/platform/win32/WinReg$HKEY;", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/registryUtils/impl/WinRegAction;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withSuffix", "suffix", "intellij.ide.startup.importSettings"})
public final class RegistryKey
implements IRegistryKey {
    @NotNull
    private final String key;
    @NotNull
    private final RegistryRoot registryRoot;

    public RegistryKey(@NotNull String key, @NotNull RegistryRoot registryRoot) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)registryRoot, (String)"registryRoot");
        this.key = key;
        this.registryRoot = registryRoot;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public IRegistryKey withSuffix(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return new RegistryKey(this.key + suffix, this.registryRoot);
    }

    @Override
    @NotNull
    public IRegistryKey inChild(@NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return new RegistryKey(this.key + "\\" + child, this.registryRoot);
    }

    @Override
    @Nullable
    public String getStringValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String[] stringArray = new String[]{this.key, value};
        return (String)this.tryExecuteWithHKEY(stringArray, (Function1)new Function1<WinReg.HKEY, String>(this, value){
            final /* synthetic */ RegistryKey this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull WinReg.HKEY it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Advapi32Util.registryKeyExists((WinReg.HKEY)it, (String)this.this$0.getKey())) {
                    return null;
                }
                return Advapi32Util.registryGetStringValue((WinReg.HKEY)it, (String)this.this$0.getKey(), (String)this.$value);
            }
        });
    }

    @Override
    @Nullable
    public List<String> getKeys() {
        String[] stringArray = new String[]{this.key};
        Object[] objectArray = (String[])this.tryExecuteWithHKEY(stringArray, (Function1)new Function1<WinReg.HKEY, String[]>(this){
            final /* synthetic */ RegistryKey this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String[] invoke(@NotNull WinReg.HKEY it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Advapi32Util.registryGetKeys((WinReg.HKEY)it, (String)this.this$0.getKey());
            }
        });
        return objectArray != null ? ArraysKt.toList((Object[])objectArray) : null;
    }

    @Nullable
    public TreeMap<String, Object> getValues() {
        String[] stringArray = new String[]{this.key};
        return (TreeMap)this.tryExecuteWithHKEY(stringArray, (Function1)new Function1<WinReg.HKEY, TreeMap<String, Object>>(this){
            final /* synthetic */ RegistryKey this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final TreeMap<String, Object> invoke(@NotNull WinReg.HKEY it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Advapi32Util.registryGetValues((WinReg.HKEY)it, (String)this.this$0.getKey());
            }
        });
    }

    private final <T> T tryExecuteWithHKEY(String[] args, Function1<? super WinReg.HKEY, ? extends T> action2) {
        return this.registryRoot.executeWithHKEY((Function1)new Function1<WinReg.HKEY, T>(action2, args){
            final /* synthetic */ Function1<WinReg.HKEY, T> $action;
            final /* synthetic */ String[] $args;
            {
                this.$action = $action;
                this.$args = $args;
                super(1);
            }

            @Nullable
            public final T invoke(@NotNull WinReg.HKEY it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    return (T)this.$action.invoke((Object)it);
                }
                catch (Win32Exception t) {
                    RegistryRootKt.access$getLogger$p().info("registry arguments: " + ArraysKt.joinToString$default((Object[])this.$args, null, null, null, (int)0, null, null, (int)63, null));
                    RegistryRootKt.access$getLogger$p().warn("Failed to work with registry", (Throwable)t);
                    return null;
                }
            }
        });
    }
}

