/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac;

import com.intellij.icons.AllIcons;
import com.intellij.ide.startup.importSettings.TransferableIdeId;
import com.intellij.ide.startup.importSettings.models.IdeVersion;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.vsmac.VSMacSettingsProcessor;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.VSMacTransferSettingsProviderKt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.SmartList;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0016J\u0018\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u000e\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/VSMacTransferSettingsProvider;", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsProvider;", "()V", "name", "", "getName", "()Ljava/lang/String;", "transferableIdeId", "Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "getTransferableIdeId", "()Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "detectVSForMacVersion", "getIdeVersion", "Lcom/intellij/ide/startup/importSettings/models/IdeVersion;", "version", "getIdeVersions", "Lcom/intellij/util/SmartList;", "skipIds", "", "getLastUsed", "Ljava/util/Date;", "Lcom/jetbrains/rd/util/Date;", "hasDataToImport", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAvailable", "intellij.ide.startup.importSettings"})
public final class VSMacTransferSettingsProvider
implements TransferSettingsProvider {
    @NotNull
    private final TransferableIdeId transferableIdeId = TransferableIdeId.VisualStudioForMac;
    @NotNull
    private final String name;

    public VSMacTransferSettingsProvider() {
        this.name = "Visual Studio for Mac";
    }

    @Override
    @NotNull
    public TransferableIdeId getTransferableIdeId() {
        return this.transferableIdeId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAvailable() {
        return SystemInfoRt.isMac;
    }

    @Override
    @Nullable
    public Object hasDataToImport(@NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)CollectionsKt.any((Iterable)((Iterable)this.getIdeVersions((List<String>)CollectionsKt.emptyList()))));
    }

    @NotNull
    public SmartList<IdeVersion> getIdeVersions(@NotNull List<String> skipIds) {
        Intrinsics.checkNotNullParameter(skipIds, (String)"skipIds");
        String version = this.detectVSForMacVersion();
        return version == null ? new SmartList() : new SmartList((Object)this.getIdeVersion(version));
    }

    private final IdeVersion getIdeVersion(String version) {
        TransferableIdeId transferableIdeId = this.getTransferableIdeId();
        Icon icon = AllIcons.TransferSettings.Vsmac;
        Date date = this.getLastUsed(version);
        Intrinsics.checkNotNull((Object)icon);
        return new IdeVersion(transferableIdeId, null, "VSMAC", icon, "Visual Studio for Mac", null, (Function0)new Function0<Settings>(version){
            final /* synthetic */ String $version;
            {
                this.$version = $version;
                super(0);
            }

            @NotNull
            public final Settings invoke() {
                return new VSMacSettingsProcessor().getProcessedSettings(this.$version);
            }
        }, date, this, 32, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String detectVSForMacVersion() {
        Path pathToDir = Paths.get(VSMacSettingsProcessor.Companion.getVsPreferences$intellij_ide_startup_importSettings(), new String[0]);
        if (!Files.isDirectory(pathToDir, new LinkOption[0])) {
            return null;
        }
        long max2 = 0L;
        String lastUsedVersion = null;
        AutoCloseable autoCloseable = Files.list(pathToDir);
        Throwable throwable = null;
        try {
            Stream files = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator2 = files.iterator();
            while (iterator2.hasNext()) {
                long lastModificationTime;
                String maybeVersion;
                File recentlyUsedFile;
                Path path = (Path)iterator2.next();
                if (!Files.isDirectory(path, new LinkOption[0]) && Files.isHidden(path) || !(recentlyUsedFile = VSMacSettingsProcessor.Companion.getGeneralSettingsFile$intellij_ide_startup_importSettings(maybeVersion = ((Object)path.getFileName()).toString())).exists() || max2 >= (lastModificationTime = recentlyUsedFile.lastModified())) continue;
                max2 = lastModificationTime;
                lastUsedVersion = maybeVersion;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return lastUsedVersion;
    }

    private final Date getLastUsed(String version) {
        Date date;
        File recentlyUsedFile = VSMacSettingsProcessor.Companion.getGeneralSettingsFile$intellij_ide_startup_importSettings(version);
        try {
            date = new Date(recentlyUsedFile.lastModified());
        }
        catch (Throwable t) {
            VSMacTransferSettingsProviderKt.access$getLogger$p().warn(t);
            date = null;
        }
        return date;
    }
}

