/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.layer.normalization;

import io.kinference.attribute.Attribute;
import io.kinference.core.data.tensor.KITensor;
import io.kinference.core.data.tensor.TensorExtensionsKt;
import io.kinference.core.operators.layer.normalization.EmbedLayerNormalization;
import io.kinference.data.ONNXData;
import io.kinference.graph.Contexts;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableIntNDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.pointers.FloatPointerKt;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.operator.AttributeInfo;
import io.kinference.operator.IOInfo;
import io.kinference.operator.Operator;
import io.kinference.operator.OperatorInfo;
import io.kinference.operator.VersionInfo;
import io.kinference.protobuf.message.AttributeProto;
import io.kinference.protobuf.message.TensorProto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\u000bJF\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\t\"\u0010\b\u0000\u0010\u0014*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00172\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\tH\u0096@\u00a2\u0006\u0002\u0010\u0018R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lio/kinference/core/operators/layer/normalization/EmbedLayerNormalizationVer1;", "Lio/kinference/core/operators/layer/normalization/EmbedLayerNormalization;", "name", "", "attributes", "", "Lio/kinference/attribute/Attribute;", "", "inputs", "", "outputs", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "epsilon", "", "getEpsilon", "()F", "epsilon$delegate", "Lio/kinference/operator/Operator$AttributeValueDelegate;", "apply", "Lio/kinference/core/data/tensor/KITensor;", "D", "Lio/kinference/data/ONNXData;", "contexts", "Lio/kinference/graph/Contexts;", "(Lio/kinference/graph/Contexts;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "inference-core"})
public final class EmbedLayerNormalizationVer1
extends EmbedLayerNormalization {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Operator.AttributeValueDelegate epsilon$delegate;
    @NotNull
    private static final Set<TensorProto.DataType> TYPE_CONSTRAINTS;
    @NotNull
    private static final List<AttributeInfo> ATTRIBUTES_INFO;
    @NotNull
    private static final List<IOInfo> INPUTS_INFO;
    @NotNull
    private static final List<IOInfo> OUTPUTS_INFO;
    @NotNull
    private static final VersionInfo VERSION;
    @NotNull
    private static final OperatorInfo INFO;

    public EmbedLayerNormalizationVer1(@NotNull String name, @NotNull Map<String, Attribute<Object>> attributes, @NotNull List<String> inputs, @NotNull List<String> outputs) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        super(name, INFO, attributes, inputs, outputs, null);
        this.epsilon$delegate = Operator.attribute$default(this, null, 1, null);
    }

    private final float getEpsilon() {
        return ((Number)this.epsilon$delegate.getValue(this, $$delegatedProperties[0])).floatValue();
    }

    @Override
    @Nullable
    public <D extends ONNXData<?, ?>> Object apply(@NotNull Contexts<D> contexts, @NotNull List<KITensor> inputs, @NotNull Continuation<? super List<KITensor>> $completion) {
        KITensor kITensor = inputs.get(0);
        Intrinsics.checkNotNull((Object)kITensor);
        NDArrayCore nDArrayCore = kITensor.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.IntNDArray");
        IntNDArray inputIds = (IntNDArray)nDArrayCore;
        KITensor kITensor2 = inputs.get(1);
        IntNDArray segmentIds = (IntNDArray)(kITensor2 != null ? kITensor2.getData() : null);
        KITensor kITensor3 = inputs.get(2);
        Intrinsics.checkNotNull((Object)kITensor3);
        NDArrayCore nDArrayCore2 = kITensor3.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore2, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        FloatNDArray wordEmbed = (FloatNDArray)nDArrayCore2;
        KITensor kITensor4 = inputs.get(3);
        Intrinsics.checkNotNull((Object)kITensor4);
        NDArrayCore nDArrayCore3 = kITensor4.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore3, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        FloatNDArray posEmbed = (FloatNDArray)nDArrayCore3;
        KITensor kITensor5 = inputs.get(4);
        FloatNDArray segmentEmbed = (FloatNDArray)(kITensor5 != null ? kITensor5.getData() : null);
        KITensor kITensor6 = inputs.get(5);
        Intrinsics.checkNotNull((Object)kITensor6);
        NDArrayCore nDArrayCore4 = kITensor6.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore4, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        FloatNDArray gamma = (FloatNDArray)nDArrayCore4;
        KITensor kITensor7 = inputs.get(6);
        Intrinsics.checkNotNull((Object)kITensor7);
        NDArrayCore nDArrayCore5 = kITensor7.getData();
        Intrinsics.checkNotNull((Object)nDArrayCore5, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
        FloatNDArray beta2 = (FloatNDArray)nDArrayCore5;
        KITensor kITensor8 = (KITensor)CollectionsKt.getOrNull(inputs, (int)7);
        IntNDArray mask2 = (IntNDArray)(kITensor8 != null ? kITensor8.getData() : null);
        KITensor kITensor9 = (KITensor)CollectionsKt.getOrNull(inputs, (int)8);
        IntNDArray positionIds = (IntNDArray)(kITensor9 != null ? kITensor9.getData() : null);
        Companion.NormalizeResult normalizeResult = EmbedLayerNormalizationVer1.Companion.normalize(this.getEpsilon(), inputIds, segmentIds, wordEmbed, posEmbed, segmentEmbed, gamma, beta2, positionIds);
        FloatNDArray normalized = normalizeResult.component1();
        FloatNDArray embedSum = normalizeResult.component2();
        NumberNDArrayCore maskIndices = Companion.createMaskIndices$inference_core(mask2, inputIds.getShape()[0], inputIds.getShape()[1]);
        Object[] objectArray = new NumberNDArrayCore[]{normalized, maskIndices, embedSum};
        return TensorExtensionsKt.asONNXTensors(CollectionsKt.listOf((Object[])objectArray), this.getOutputs());
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(EmbedLayerNormalizationVer1.class, "epsilon", "getEpsilon()F", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new TensorProto.DataType[]{TensorProto.DataType.FLOAT, TensorProto.DataType.FLOAT16};
        TYPE_CONSTRAINTS = SetsKt.setOf((Object[])objectArray);
        ATTRIBUTES_INFO = CollectionsKt.listOf((Object)new AttributeInfo("epsilon", SetsKt.setOf((Object)AttributeProto.AttributeType.FLOAT), false, Float.valueOf(1.0E-5f)));
        objectArray = new IOInfo[]{new IOInfo(0, SetsKt.setOf((Object)TensorProto.DataType.INT32), "input_ids", false, null, false, null, 112, null), new IOInfo(1, SetsKt.setOf((Object)TensorProto.DataType.INT32), "segment_ids", true, null, false, null, 112, null), new IOInfo(2, TYPE_CONSTRAINTS, "word_embedding", false, null, false, null, 112, null), new IOInfo(3, TYPE_CONSTRAINTS, "position_embedding", false, null, false, null, 112, null), new IOInfo(4, TYPE_CONSTRAINTS, "segment_embedding", true, null, false, null, 112, null), new IOInfo(5, TYPE_CONSTRAINTS, "gamma", false, null, false, null, 112, null), new IOInfo(6, TYPE_CONSTRAINTS, "beta", false, null, false, null, 112, null), new IOInfo(7, SetsKt.setOf((Object)TensorProto.DataType.INT32), "mask", true, null, false, null, 112, null), new IOInfo(8, SetsKt.setOf((Object)TensorProto.DataType.INT32), "position_ids", true, null, false, null, 112, null)};
        INPUTS_INFO = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new IOInfo[]{new IOInfo(0, TYPE_CONSTRAINTS, "output", false, null, false, null, 112, null), new IOInfo(1, SetsKt.setOf((Object)TensorProto.DataType.INT32), "mask_index", false, null, false, null, 112, null), new IOInfo(2, TYPE_CONSTRAINTS, "embedding_sum", true, null, false, null, 112, null)};
        OUTPUTS_INFO = CollectionsKt.listOf((Object[])objectArray);
        VERSION = new VersionInfo(1, 0, 2, null);
        INFO = new OperatorInfo("EmbedLayerNormalization", (Collection<AttributeInfo>)ATTRIBUTES_INFO, INPUTS_INFO, OUTPUTS_INFO, VERSION, "com.microsoft");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0019JV\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010\u0015H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lio/kinference/core/operators/layer/normalization/EmbedLayerNormalizationVer1$Companion;", "", "()V", "ATTRIBUTES_INFO", "", "Lio/kinference/operator/AttributeInfo;", "INFO", "Lio/kinference/operator/OperatorInfo;", "INPUTS_INFO", "Lio/kinference/operator/IOInfo;", "OUTPUTS_INFO", "TYPE_CONSTRAINTS", "", "Lio/kinference/protobuf/message/TensorProto$DataType;", "VERSION", "Lio/kinference/operator/VersionInfo;", "getVERSION$inference_core", "()Lio/kinference/operator/VersionInfo;", "createMaskIndices", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "mask", "Lio/kinference/ndarray/arrays/IntNDArray;", "batchSize", "", "seqLen", "createMaskIndices$inference_core", "normalize", "Lio/kinference/core/operators/layer/normalization/EmbedLayerNormalizationVer1$Companion$NormalizeResult;", "epsilon", "", "inputIds", "segmentIds", "wordEmbed", "Lio/kinference/ndarray/arrays/FloatNDArray;", "posEmbed", "segmentEmbed", "gamma", "beta", "positionIds", "NormalizeResult", "inference-core"})
    @SourceDebugExtension(value={"SMAP\nEmbedLayerNormalization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbedLayerNormalization.kt\nio/kinference/core/operators/layer/normalization/EmbedLayerNormalizationVer1$Companion\n+ 2 IntPointer.kt\nio/kinference/ndarray/arrays/pointers/IntPointerKt\n+ 3 FloatPointer.kt\nio/kinference/ndarray/arrays/pointers/FloatPointerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n195#2,18:186\n2141#3:204\n2142#3,36:206\n2629#3:242\n2630#3,41:244\n195#3,18:285\n175#3,18:303\n195#3,18:321\n2141#3:339\n2142#3,36:341\n1#4:205\n1#4:243\n1#4:340\n*S KotlinDebug\n*F\n+ 1 EmbedLayerNormalization.kt\nio/kinference/core/operators/layer/normalization/EmbedLayerNormalizationVer1$Companion\n*L\n85#1:186,18\n127#1:204\n127#1:206,36\n132#1:242\n132#1:244,41\n142#1:285,18\n151#1:303,18\n154#1:321,18\n161#1:339\n161#1:341,36\n127#1:205\n132#1:243\n161#1:340\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionInfo getVERSION$inference_core() {
            return VERSION;
        }

        @NotNull
        public final NumberNDArrayCore createMaskIndices$inference_core(@Nullable IntNDArray mask2, int batchSize, int seqLen) {
            int[] nArray = new int[]{batchSize};
            MutableIntNDArray maskIndices = new MutableIntNDArray(nArray);
            if (mask2 == null) {
                return maskIndices;
            }
            IntPointer pointer = IntTiledArray.pointer$default(mask2.getArray(), 0, 1, null);
            IntPointer maskIndicesPointer = IntTiledArray.pointer$default(maskIndices.getArray(), 0, 1, null);
            for (int i = 0; i < batchSize; ++i) {
                int offset$iv;
                int[] block$iv;
                int count = 0;
                pointer.setLinearIndex(i * seqLen);
                IntPointer $this$forEach$iv = pointer;
                boolean $i$f$forEach = false;
                for (int end$iv = seqLen; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                    block$iv = $this$forEach$iv.getCurrentBlock();
                    if (block$iv.length <= (offset$iv = $this$forEach$iv.getIndexInBlock()) + end$iv) {
                        $this$forEach$iv.blockIncrement();
                    } else {
                        $this$forEach$iv.setIndexInBlock($this$forEach$iv.getIndexInBlock() + end$iv);
                    }
                    int n = Math.min(block$iv.length, offset$iv + end$iv);
                    for (int index$iv = offset$iv; index$iv < n; ++index$iv) {
                        int it = block$iv[index$iv];
                        boolean bl = false;
                        if (it != 1) continue;
                        ++count;
                    }
                }
                maskIndicesPointer.set(count);
                maskIndicesPointer.increment();
            }
            return maskIndices;
        }

        /*
         * WARNING - void declaration
         */
        private final NormalizeResult normalize(float epsilon, IntNDArray inputIds, IntNDArray segmentIds, FloatNDArray wordEmbed, FloatNDArray posEmbed, FloatNDArray segmentEmbed, FloatNDArray gamma, FloatNDArray beta2, IntNDArray positionIds) {
            int[] nArray = inputIds.getShape();
            int batchSize = nArray[0];
            int seqLen = nArray[1];
            int hiddenSize2 = wordEmbed.getShape()[1];
            int[] nArray2 = new int[]{batchSize, seqLen, hiddenSize2};
            MutableFloatNDArray output = new MutableFloatNDArray(nArray2);
            int[] nArray3 = new int[]{batchSize, seqLen, hiddenSize2};
            MutableFloatNDArray embeddingSum = new MutableFloatNDArray(nArray3);
            for (int batch = 0; batch < batchSize; ++batch) {
                int blockIdx = batch * seqLen;
                IntPointer inputIdsPointer = inputIds.getArray().pointer(blockIdx);
                Object object = segmentIds;
                IntPointer segmentIdsPointer = object != null && (object = ((IntNDArray)object).getArray()) != null ? ((IntTiledArray)object).pointer(blockIdx) : null;
                Object object2 = positionIds;
                IntPointer positionIdsPointer = object2 != null && (object2 = ((IntNDArray)object2).getArray()) != null ? ((IntTiledArray)object2).pointer(blockIdx) : null;
                for (int seqIdx = 0; seqIdx < seqLen; ++seqIdx) {
                    float b;
                    float g;
                    float out;
                    boolean bl;
                    int end$iv;
                    float[] block$iv;
                    int end$iv2;
                    int offset$iv;
                    float[] block$iv2;
                    int index$iv3;
                    int offset$iv2;
                    float[] block$iv3;
                    float f;
                    Object object3;
                    int index$iv2;
                    int wordIdx = inputIdsPointer.getAndIncrement();
                    IntPointer intPointer = segmentIdsPointer;
                    int segmentIdx = intPointer != null ? intPointer.getAndIncrement() : 0;
                    IntPointer intPointer2 = positionIdsPointer;
                    int positionIdx = intPointer2 != null ? intPointer2.getAndIncrement() : seqIdx;
                    int wordEmbedOffset = wordIdx * hiddenSize2;
                    int segmentEmbedOffset = segmentIdx * hiddenSize2;
                    int outputOffset = (seqIdx + batch * seqLen) * hiddenSize2;
                    int posEmbedOffset = positionIdx * hiddenSize2;
                    FloatPointer wordEmbedPointer = wordEmbed.getArray().pointer(wordEmbedOffset);
                    Object object4 = segmentEmbed;
                    FloatPointer segmentEmbedPointer = object4 != null && (object4 = ((FloatNDArray)object4).getArray()) != null ? ((FloatTiledArray)object4).pointer(segmentEmbedOffset) : null;
                    FloatPointer posEmbedPointer = posEmbed.getArray().pointer(posEmbedOffset);
                    FloatPointer embeddingSumPointer = embeddingSum.getArray().pointer(outputOffset);
                    if (segmentEmbedPointer == null) {
                        FloatPointer $this$acceptDouble$iv = embeddingSumPointer;
                        boolean $i$f$acceptDouble = false;
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, wordEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$17$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$17$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$17$iv22.toString());
                        }
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, posEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptDouble$18$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptDouble$18$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$18$iv22.toString());
                        }
                        if (FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, wordEmbedPointer) && FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, posEmbedPointer)) {
                            int dstOffset$iv;
                            float[] dstBlock$iv;
                            for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$acceptDouble$iv.getCurrentBlock();
                                dstOffset$iv = $this$acceptDouble$iv.getIndexInBlock();
                                fstBlock$iv = wordEmbedPointer.getCurrentBlock();
                                sndBlock$iv = posEmbedPointer.getCurrentBlock();
                                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                    $this$acceptDouble$iv.blockIncrement();
                                    wordEmbedPointer.blockIncrement();
                                    posEmbedPointer.blockIncrement();
                                } else {
                                    $this$acceptDouble$iv.setIndexInBlock($this$acceptDouble$iv.getIndexInBlock() + end$iv);
                                    wordEmbedPointer.setIndexInBlock(wordEmbedPointer.getIndexInBlock() + end$iv);
                                    posEmbedPointer.setIndexInBlock(posEmbedPointer.getIndexInBlock() + end$iv);
                                }
                                index$iv2 = dstOffset$iv;
                                int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                                while (index$iv2 < n) {
                                    void snd;
                                    void fst;
                                    float cfr_ignored_0 = dstBlock$iv[index$iv2];
                                    float f2 = sndBlock$iv[index$iv2];
                                    float f3 = fstBlock$iv[index$iv2];
                                    int n2 = index$iv2++;
                                    object3 = dstBlock$iv;
                                    boolean bl2 = false;
                                    f = fst + snd;
                                    object3[n2] = f;
                                }
                            }
                        } else {
                            while (end$iv > 0) {
                                $this$acceptDouble$iv.get();
                                float snd = posEmbedPointer.getAndIncrement();
                                float fst = wordEmbedPointer.getAndIncrement();
                                object3 = $this$acceptDouble$iv;
                                boolean bl3 = false;
                                float f4 = fst + snd;
                                ((FloatPointer)object3).set(f4);
                                $this$acceptDouble$iv.increment();
                                --end$iv;
                            }
                        }
                    } else {
                        FloatPointer $this$acceptTriple$iv = embeddingSumPointer;
                        boolean $i$f$acceptTriple = false;
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptTriple$iv, wordEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptTriple$25$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptTriple$25$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptTriple$25$iv22.toString());
                        }
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptTriple$iv, posEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptTriple$26$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptTriple$26$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptTriple$26$iv22.toString());
                        }
                        if (!FloatPointerKt.isCompatibleBySize($this$acceptTriple$iv, segmentEmbedPointer, hiddenSize2)) {
                            boolean $i$a$-require-FloatPointerKt$acceptTriple$27$iv22 = false;
                            String $i$a$-require-FloatPointerKt$acceptTriple$27$iv22 = "Pointers not compatible by available elements";
                            throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptTriple$27$iv22.toString());
                        }
                        if (FloatPointerKt.isCompatibleWith($this$acceptTriple$iv, wordEmbedPointer) && FloatPointerKt.isCompatibleWith($this$acceptTriple$iv, posEmbedPointer) && FloatPointerKt.isCompatibleWith($this$acceptTriple$iv, segmentEmbedPointer)) {
                            int dstOffset$iv;
                            float[] dstBlock$iv;
                            for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$acceptTriple$iv.getCurrentBlock();
                                dstOffset$iv = $this$acceptTriple$iv.getIndexInBlock();
                                fstBlock$iv = wordEmbedPointer.getCurrentBlock();
                                sndBlock$iv = posEmbedPointer.getCurrentBlock();
                                float[] trdBlock$iv = segmentEmbedPointer.getCurrentBlock();
                                if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                    $this$acceptTriple$iv.blockIncrement();
                                    wordEmbedPointer.blockIncrement();
                                    posEmbedPointer.blockIncrement();
                                    segmentEmbedPointer.blockIncrement();
                                } else {
                                    $this$acceptTriple$iv.setIndexInBlock($this$acceptTriple$iv.getIndexInBlock() + end$iv);
                                    wordEmbedPointer.setIndexInBlock(wordEmbedPointer.getIndexInBlock() + end$iv);
                                    posEmbedPointer.setIndexInBlock(posEmbedPointer.getIndexInBlock() + end$iv);
                                    segmentEmbedPointer.setIndexInBlock(segmentEmbedPointer.getIndexInBlock() + end$iv);
                                }
                                int index$iv3 = dstOffset$iv;
                                int snd = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                                while (index$iv3 < snd) {
                                    void trd;
                                    void snd2;
                                    void fst;
                                    float cfr_ignored_1 = dstBlock$iv[index$iv3];
                                    float fst2 = trdBlock$iv[index$iv3];
                                    float f5 = sndBlock$iv[index$iv3];
                                    float bl3 = fstBlock$iv[index$iv3];
                                    int n = index$iv3++;
                                    object3 = dstBlock$iv;
                                    $i$a$-acceptTriple-EmbedLayerNormalizationVer1$Companion$normalize$2 = false;
                                    f = fst + snd2 + trd;
                                    object3[n] = f;
                                }
                            }
                        } else {
                            while (end$iv > 0) {
                                $this$acceptTriple$iv.get();
                                float trd = segmentEmbedPointer.getAndIncrement();
                                float snd2 = posEmbedPointer.getAndIncrement();
                                float fst = wordEmbedPointer.getAndIncrement();
                                object3 = $this$acceptTriple$iv;
                                $i$a$-acceptTriple-EmbedLayerNormalizationVer1$Companion$normalize$2 = false;
                                float f6 = fst + snd2 + trd;
                                ((FloatPointer)object3).set(f6);
                                $this$acceptTriple$iv.increment();
                                --end$iv;
                            }
                        }
                    }
                    FloatPointer outputPointer = output.getArray().pointer(outputOffset);
                    embeddingSumPointer.setLinearIndex(outputOffset);
                    float acc = 0.0f;
                    FloatPointer $this$forEach$iv = embeddingSumPointer;
                    boolean $i$f$forEach = false;
                    for (int end$iv3 = hiddenSize2; end$iv3 > 0; end$iv3 -= block$iv3.length - offset$iv2) {
                        block$iv3 = $this$forEach$iv.getCurrentBlock();
                        if (block$iv3.length <= (offset$iv2 = $this$forEach$iv.getIndexInBlock()) + end$iv3) {
                            $this$forEach$iv.blockIncrement();
                        } else {
                            $this$forEach$iv.setIndexInBlock($this$forEach$iv.getIndexInBlock() + end$iv3);
                        }
                        index$iv3 = Math.min(block$iv3.length, offset$iv2 + end$iv3);
                        for (index$iv2 = offset$iv2; index$iv2 < index$iv3; ++index$iv2) {
                            float it = block$iv3[index$iv2];
                            boolean bl4 = false;
                            outputPointer.setAndIncrement(it);
                            acc += it;
                        }
                    }
                    float mean2 = acc / (float)hiddenSize2;
                    acc = 0.0f;
                    outputPointer.setLinearIndex(outputOffset);
                    FloatPointer $this$map$iv = outputPointer;
                    boolean $i$f$map = false;
                    for (end$iv2 = hiddenSize2; end$iv2 > 0; end$iv2 -= block$iv2.length - offset$iv) {
                        block$iv2 = $this$map$iv.getCurrentBlock();
                        if (block$iv2.length <= (offset$iv = $this$map$iv.getIndexInBlock()) + end$iv2) {
                            $this$map$iv.blockIncrement();
                        } else {
                            $this$map$iv.setIndexInBlock($this$map$iv.getIndexInBlock() + end$iv2);
                        }
                        index$iv3 = offset$iv;
                        int it = Math.min(block$iv2.length, offset$iv + end$iv2);
                        while (index$iv3 < it) {
                            void it2;
                            float bl4 = block$iv2[index$iv3];
                            int n = index$iv3++;
                            object3 = block$iv2;
                            boolean bl5 = false;
                            f = it2 - mean2;
                            object3[n] = f;
                        }
                    }
                    outputPointer.setLinearIndex(outputOffset);
                    FloatPointer $this$forEach$iv2 = outputPointer;
                    boolean $i$f$forEach2 = false;
                    for (end$iv2 = hiddenSize2; end$iv2 > 0; end$iv2 -= block$iv.length - offset$iv) {
                        block$iv = $this$forEach$iv2.getCurrentBlock();
                        if (block$iv.length <= (offset$iv = $this$forEach$iv2.getIndexInBlock()) + end$iv2) {
                            $this$forEach$iv2.blockIncrement();
                        } else {
                            $this$forEach$iv2.setIndexInBlock($this$forEach$iv2.getIndexInBlock() + end$iv2);
                        }
                        int it = Math.min(block$iv.length, offset$iv + end$iv2);
                        for (index$iv3 = offset$iv; index$iv3 < it; ++index$iv3) {
                            float it3 = block$iv[index$iv3];
                            boolean bl6 = false;
                            acc += it3 * it3;
                        }
                    }
                    float eps = (float)Math.sqrt(acc / (float)hiddenSize2 + epsilon);
                    outputPointer.setLinearIndex(outputOffset);
                    FloatPointer gammaPointer = FloatTiledArray.pointer$default(gamma.getArray(), 0, 1, null);
                    FloatPointer betaPointer = FloatTiledArray.pointer$default(beta2.getArray(), 0, 1, null);
                    FloatPointer $this$acceptDouble$iv = outputPointer;
                    boolean $i$f$acceptDouble = false;
                    if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, gammaPointer, hiddenSize2)) {
                        boolean $i$a$-require-FloatPointerKt$acceptDouble$17$iv32 = false;
                        String $i$a$-require-FloatPointerKt$acceptDouble$17$iv32 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$17$iv32.toString());
                    }
                    if (!FloatPointerKt.isCompatibleBySize($this$acceptDouble$iv, betaPointer, hiddenSize2)) {
                        boolean $i$a$-require-FloatPointerKt$acceptDouble$18$iv32 = false;
                        String $i$a$-require-FloatPointerKt$acceptDouble$18$iv32 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-FloatPointerKt$acceptDouble$18$iv32.toString());
                    }
                    if (FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, gammaPointer) && FloatPointerKt.isCompatibleWith($this$acceptDouble$iv, betaPointer)) {
                        int dstOffset$iv;
                        float[] dstBlock$iv;
                        for (end$iv = hiddenSize2; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                            dstBlock$iv = $this$acceptDouble$iv.getCurrentBlock();
                            dstOffset$iv = $this$acceptDouble$iv.getIndexInBlock();
                            float[] fstBlock$iv = gammaPointer.getCurrentBlock();
                            float[] sndBlock$iv = betaPointer.getCurrentBlock();
                            if (dstBlock$iv.length <= dstOffset$iv + end$iv) {
                                $this$acceptDouble$iv.blockIncrement();
                                gammaPointer.blockIncrement();
                                betaPointer.blockIncrement();
                            } else {
                                $this$acceptDouble$iv.setIndexInBlock($this$acceptDouble$iv.getIndexInBlock() + end$iv);
                                gammaPointer.setIndexInBlock(gammaPointer.getIndexInBlock() + end$iv);
                                betaPointer.setIndexInBlock(betaPointer.getIndexInBlock() + end$iv);
                            }
                            int index$iv4 = dstOffset$iv;
                            int n = Math.min(dstBlock$iv.length, dstOffset$iv + end$iv);
                            while (index$iv4 < n) {
                                float f7 = sndBlock$iv[index$iv4];
                                float f8 = fstBlock$iv[index$iv4];
                                float f9 = dstBlock$iv[index$iv4];
                                int n3 = index$iv4++;
                                object3 = dstBlock$iv;
                                bl = false;
                                f = out / eps * g + b;
                                object3[n3] = f;
                            }
                        }
                        continue;
                    }
                    while (end$iv > 0) {
                        b = betaPointer.getAndIncrement();
                        g = gammaPointer.getAndIncrement();
                        out = $this$acceptDouble$iv.get();
                        object3 = $this$acceptDouble$iv;
                        bl = false;
                        float f10 = out / eps * g + b;
                        ((FloatPointer)object3).set(f10);
                        $this$acceptDouble$iv.increment();
                        --end$iv;
                    }
                }
            }
            return new NormalizeResult(output, embeddingSum);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/kinference/core/operators/layer/normalization/EmbedLayerNormalizationVer1$Companion$NormalizeResult;", "", "output", "Lio/kinference/ndarray/arrays/FloatNDArray;", "embeddingSum", "(Lio/kinference/ndarray/arrays/FloatNDArray;Lio/kinference/ndarray/arrays/FloatNDArray;)V", "getEmbeddingSum", "()Lio/kinference/ndarray/arrays/FloatNDArray;", "getOutput", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "inference-core"})
        private static final class NormalizeResult {
            @NotNull
            private final FloatNDArray output;
            @NotNull
            private final FloatNDArray embeddingSum;

            public NormalizeResult(@NotNull FloatNDArray output, @NotNull FloatNDArray embeddingSum) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                Intrinsics.checkNotNullParameter((Object)embeddingSum, (String)"embeddingSum");
                this.output = output;
                this.embeddingSum = embeddingSum;
            }

            @NotNull
            public final FloatNDArray getOutput() {
                return this.output;
            }

            @NotNull
            public final FloatNDArray getEmbeddingSum() {
                return this.embeddingSum;
            }

            @NotNull
            public final FloatNDArray component1() {
                return this.output;
            }

            @NotNull
            public final FloatNDArray component2() {
                return this.embeddingSum;
            }

            @NotNull
            public final NormalizeResult copy(@NotNull FloatNDArray output, @NotNull FloatNDArray embeddingSum) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                Intrinsics.checkNotNullParameter((Object)embeddingSum, (String)"embeddingSum");
                return new NormalizeResult(output, embeddingSum);
            }

            public static /* synthetic */ NormalizeResult copy$default(NormalizeResult normalizeResult, FloatNDArray floatNDArray, FloatNDArray floatNDArray2, int n, Object object) {
                if ((n & 1) != 0) {
                    floatNDArray = normalizeResult.output;
                }
                if ((n & 2) != 0) {
                    floatNDArray2 = normalizeResult.embeddingSum;
                }
                return normalizeResult.copy(floatNDArray, floatNDArray2);
            }

            @NotNull
            public String toString() {
                return "NormalizeResult(output=" + this.output + ", embeddingSum=" + this.embeddingSum + ")";
            }

            public int hashCode() {
                int result2 = this.output.hashCode();
                result2 = result2 * 31 + this.embeddingSum.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NormalizeResult)) {
                    return false;
                }
                NormalizeResult normalizeResult = (NormalizeResult)other;
                if (!Intrinsics.areEqual((Object)this.output, (Object)normalizeResult.output)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.embeddingSum, (Object)normalizeResult.embeddingSum);
            }
        }
    }
}

