/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayInput;
import kotlinx.serialization.cbor.internal.CborDecodingException;
import kotlinx.serialization.cbor.internal.CborDecodingExceptionKt;
import kotlinx.serialization.cbor.internal.EncodingKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\n\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000bH\u0002J\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0006H\u0002J\b\u0010 \u001a\u00020\u0011H\u0002J\b\u0010!\u001a\u00020\u0011H\u0002J\b\u0010\"\u001a\u00020\u0006H\u0002J\b\u0010#\u001a\u00020\u0019H\u0002J\b\u0010$\u001a\u00020\u0019H\u0002J\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0006H\u0002J\u0006\u0010)\u001a\u00020\tJ\b\u0010*\u001a\u00020\tH\u0002J\u0006\u0010+\u001a\u00020\u0006J\u0006\u0010,\u001a\u00020\u0006J \u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u001bH\u0002J\u0014\u00101\u001a\u00020\u0019*\u00020\u00032\u0006\u00102\u001a\u00020\u0006H\u0002J\u0014\u00103\u001a\u00020\u0011*\u00020\u00032\u0006\u00104\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lkotlinx/serialization/cbor/internal/CborDecoder;", "", "input", "Lkotlinx/serialization/cbor/internal/ByteArrayInput;", "(Lkotlinx/serialization/cbor/internal/ByteArrayInput;)V", "curByte", "", "elementLength", "end", "", "isEnd", "", "isEof", "isIndefinite", "isNull", "nextBoolean", "nextByteString", "", "nextDouble", "", "nextFloat", "", "nextNull", "", "nextNumber", "", "nextString", "", "prune", "lengthStack", "", "readByte", "readBytes", "readIndefiniteLengthBytes", "readInt", "readLong", "readNumber", "readShort", "", "skipByte", "expected", "skipElement", "skipOverTags", "startArray", "startMap", "startSized", "unboundedHeader", "boundedHeaderMask", "collectionType", "readExact", "bytes", "readExactNBytes", "bytesCount", "kotlinx-serialization-cbor"})
public final class CborDecoder {
    @NotNull
    private final ByteArrayInput input;
    private int curByte;

    public CborDecoder(@NotNull ByteArrayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.curByte = -1;
        this.readByte();
    }

    private final int readByte() {
        this.curByte = this.input.read();
        return this.curByte;
    }

    public final boolean isEof() {
        return this.curByte == -1;
    }

    private final void skipByte(int expected) {
        if (this.curByte != expected) {
            throw CborDecodingExceptionKt.CborDecodingException("byte " + CborDecodingExceptionKt.printByte(expected), this.curByte);
        }
        this.readByte();
    }

    public final boolean isNull() {
        return this.curByte == 246;
    }

    @Nullable
    public final Void nextNull() {
        this.skipOverTags();
        this.skipByte(246);
        return null;
    }

    public final boolean nextBoolean() {
        boolean bl;
        this.skipOverTags();
        switch (this.curByte) {
            case 245: {
                bl = true;
                break;
            }
            case 244: {
                bl = false;
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("boolean value", this.curByte);
            }
        }
        boolean ans = bl;
        this.readByte();
        return ans;
    }

    public final int startArray() {
        return this.startSized(159, 128, "array");
    }

    public final int startMap() {
        return this.startSized(191, 160, "map");
    }

    private final int startSized(int unboundedHeader, int boundedHeaderMask, String collectionType) {
        this.skipOverTags();
        if (this.curByte == unboundedHeader) {
            this.skipByte(unboundedHeader);
            return -1;
        }
        if ((this.curByte & 0xE0) != boundedHeaderMask) {
            throw CborDecodingExceptionKt.CborDecodingException("start of " + collectionType, this.curByte);
        }
        int size2 = (int)this.readNumber();
        this.readByte();
        return size2;
    }

    public final boolean isEnd() {
        return this.curByte == 255;
    }

    public final void end() {
        this.skipByte(255);
    }

    @NotNull
    public final byte[] nextByteString() {
        this.skipOverTags();
        if ((this.curByte & 0xE0) != 64) {
            throw CborDecodingExceptionKt.CborDecodingException("start of byte string", this.curByte);
        }
        byte[] arr = this.readBytes();
        this.readByte();
        return arr;
    }

    @NotNull
    public final String nextString() {
        this.skipOverTags();
        if ((this.curByte & 0xE0) != 96) {
            throw CborDecodingExceptionKt.CborDecodingException("start of string", this.curByte);
        }
        byte[] arr = this.readBytes();
        String ans = StringsKt.decodeToString((byte[])arr);
        this.readByte();
        return ans;
    }

    private final byte[] readBytes() {
        byte[] byArray;
        if ((this.curByte & 0x1F) == 31) {
            this.readByte();
            byArray = this.readIndefiniteLengthBytes();
        } else {
            int strLen = (int)this.readNumber();
            byArray = this.readExactNBytes(this.input, strLen);
        }
        return byArray;
    }

    private final void skipOverTags() {
        while ((this.curByte & 0xE0) == 192) {
            this.readNumber();
            this.readByte();
        }
    }

    public final long nextNumber() {
        this.skipOverTags();
        long res2 = this.readNumber();
        this.readByte();
        return res2;
    }

    private final long readNumber() {
        int bytesToRead;
        int value = this.curByte & 0x1F;
        boolean negative = (this.curByte & 0xE0) == 32;
        switch (value) {
            case 24: {
                int n = 1;
                break;
            }
            case 25: {
                int n = 2;
                break;
            }
            case 26: {
                int n = 4;
                break;
            }
            case 27: {
                int n = 8;
                break;
            }
            default: {
                int n = bytesToRead = 0;
            }
        }
        if (bytesToRead == 0) {
            return negative ? -((long)(value + 1)) : (long)value;
        }
        long res2 = this.readExact(this.input, bytesToRead);
        return negative ? -(res2 + 1L) : res2;
    }

    private final long readExact(ByteArrayInput $this$readExact, int bytes) {
        byte[] arr = this.readExactNBytes($this$readExact, bytes);
        long result2 = 0L;
        for (int i = 0; i < bytes; ++i) {
            result2 = result2 << 8 | (long)(arr[i] & 0xFF);
        }
        return result2;
    }

    private final byte[] readExactNBytes(ByteArrayInput $this$readExactNBytes, int bytesCount) {
        if (bytesCount > $this$readExactNBytes.getAvailableBytes()) {
            throw new IllegalStateException(("Unexpected EOF, available " + $this$readExactNBytes.getAvailableBytes() + " bytes, requested: " + bytesCount).toString());
        }
        byte[] array = new byte[bytesCount];
        $this$readExactNBytes.read(array, 0, bytesCount);
        return array;
    }

    public final float nextFloat() {
        float f;
        this.skipOverTags();
        switch (this.curByte) {
            case 250: {
                f = Float.intBitsToFloat(this.readInt());
                break;
            }
            case 249: {
                f = EncodingKt.access$floatFromHalfBits(this.readShort());
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("float header", this.curByte);
            }
        }
        float res2 = f;
        this.readByte();
        return res2;
    }

    public final double nextDouble() {
        double d;
        this.skipOverTags();
        switch (this.curByte) {
            case 251: {
                d = Double.longBitsToDouble(this.readLong());
                break;
            }
            case 250: {
                d = Float.intBitsToFloat(this.readInt());
                break;
            }
            case 249: {
                d = EncodingKt.access$floatFromHalfBits(this.readShort());
                break;
            }
            default: {
                throw CborDecodingExceptionKt.CborDecodingException("double header", this.curByte);
            }
        }
        double res2 = d;
        this.readByte();
        return res2;
    }

    private final long readLong() {
        long result2 = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = this.input.read();
            result2 = result2 << 8 | (long)n;
        }
        return result2;
    }

    private final short readShort() {
        int highByte = this.input.read();
        int lowByte = this.input.read();
        return (short)(highByte << 8 | lowByte);
    }

    private final int readInt() {
        int result2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n = this.input.read();
            result2 = result2 << 8 | n;
        }
        return result2;
    }

    public final void skipElement() {
        List lengthStack = new ArrayList();
        this.skipOverTags();
        do {
            if (this.isEof()) {
                throw new CborDecodingException("Unexpected EOF while skipping element");
            }
            if (this.isIndefinite()) {
                lengthStack.add(-1);
            } else if (this.isEnd()) {
                Integer n = (Integer)CollectionsKt.removeLastOrNull((List)lengthStack);
                int n2 = -1;
                if (n == null || n != n2) {
                    throw CborDecodingExceptionKt.CborDecodingException("next data item", this.curByte);
                }
                this.prune(lengthStack);
            } else {
                int header = this.curByte & 0xE0;
                int length = this.elementLength();
                switch (header) {
                    case 128: 
                    case 160: {
                        if (length > 0) {
                            lengthStack.add(length);
                        }
                        this.skipOverTags();
                        break;
                    }
                    default: {
                        this.input.skip(length);
                        this.prune(lengthStack);
                    }
                }
            }
            this.readByte();
        } while (!((Collection)lengthStack).isEmpty());
    }

    private final void prune(List<Integer> lengthStack) {
        block4: for (int i = CollectionsKt.getLastIndex(lengthStack); -1 < i; --i) {
            switch (((Number)lengthStack.get(i)).intValue()) {
                case -1: {
                    break block4;
                }
                case 1: {
                    lengthStack.remove(i);
                    continue block4;
                }
                default: {
                    lengthStack.set(i, ((Number)lengthStack.get(i)).intValue() - 1);
                    break block4;
                }
            }
        }
    }

    private final boolean isIndefinite() {
        int majorType = this.curByte & 0xE0;
        int value = this.curByte & 0x1F;
        return value == 31 && (majorType == 128 || majorType == 160 || majorType == 64 || majorType == 96);
    }

    private final int elementLength() {
        int n;
        int majorType = this.curByte & 0xE0;
        int additionalInformation = this.curByte & 0x1F;
        block0 : switch (majorType) {
            case 64: 
            case 96: 
            case 128: {
                n = (int)this.readNumber();
                break;
            }
            case 160: {
                n = (int)this.readNumber() * 2;
                break;
            }
            default: {
                switch (additionalInformation) {
                    case 24: {
                        n = 1;
                        break block0;
                    }
                    case 25: {
                        n = 2;
                        break block0;
                    }
                    case 26: {
                        n = 4;
                        break block0;
                    }
                    case 27: {
                        n = 8;
                        break block0;
                    }
                }
                n = 0;
            }
        }
        return n;
    }

    private final byte[] readIndefiniteLengthBytes() {
        List byteStrings = new ArrayList();
        do {
            byteStrings.add(this.readBytes());
            this.readByte();
        } while (!this.isEnd());
        return EncodingKt.access$flatten(byteStrings);
    }
}

