/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.HistogramSlider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 72\u00020\u0001:\u0005789:;B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u001e\b\u0002\u0010\u0006\u001a\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020%H\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020%H\u0002J\u001a\u0010+\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J$\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\t2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010-2\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\b\u00103\u001a\u00020\nH\u0002J\u0012\u00104\u001a\u00020\n2\b\u00105\u001a\u0004\u0018\u00010-H\u0002J\b\u00106\u001a\u00020\nH\u0002R.\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010\u000fR\u000e\u0010#\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider;", "", "histogram", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$Histogram;", "drawingStyle", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$DrawingStyle;", "onUserInput", "Lkotlin/Function1;", "Lkotlin/ranges/ClosedRange;", "", "", "(Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$Histogram;Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$DrawingStyle;Lkotlin/jvm/functions/Function1;)V", "range", "backingSelectionRange", "setBackingSelectionRange", "(Lkotlin/ranges/ClosedRange;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "frequencies", "", "fromInputField", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$SwitchableNumberField;", "histogramEnd", "histogramPanel", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$HistogramPanel;", "histogramStart", "histogramStep", "rootPanel", "Ljavax/swing/JPanel;", "selectionRange", "getSelectionRange", "()Lkotlin/ranges/ClosedRange;", "setSelectionRange", "toInputField", "xFirst", "", "xSecond", "convertCoordinateToValue", "coordinate", "convertIndexToValue", "index", "convertIndicesToValues", "indices", "Lkotlin/ranges/IntRange;", "convertValueToIndex", "value", "rounding", "convertValuesToIndices", "values", "notifyRangeChanged", "updateHistogramPanel", "newSelectedIndices", "updateSelectionRange", "Companion", "DrawingStyle", "Histogram", "HistogramPanel", "SwitchableNumberField", "intellij.notebooks.visualization"})
public final class HistogramSlider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Function1<ClosedRange<Double>, Unit> onUserInput;
    private int xFirst;
    private int xSecond;
    @Nullable
    private ClosedRange<Double> backingSelectionRange;
    @NotNull
    private final List<Double> frequencies;
    private final double histogramStart;
    private final double histogramEnd;
    private final double histogramStep;
    @NotNull
    private final HistogramPanel histogramPanel;
    @NotNull
    private final SwitchableNumberField fromInputField;
    @NotNull
    private final SwitchableNumberField toInputField;
    @NotNull
    private final JPanel rootPanel;
    @NotNull
    private static final DrawingStyle DEFAULT_DRAWING_STYLE = new DrawingStyle(new Color(96, 160, 255), new Color(255, 0, 0, 96), null);

    /*
     * WARNING - void declaration
     */
    public HistogramSlider(@NotNull Histogram histogram, @Nullable DrawingStyle drawingStyle, @Nullable Function1<? super ClosedRange<Double>, Unit> onUserInput) {
        void $this$rootPanel_u24lambda_u241;
        JPanel $this$histogramPanel_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)histogram, (String)"histogram");
        this.onUserInput = onUserInput;
        this.xFirst = -1;
        this.xSecond = -1;
        this.frequencies = histogram.getFrequencies();
        this.histogramStart = ((Number)((Object)histogram.getValues().getStart())).doubleValue();
        this.histogramEnd = ((Number)((Object)histogram.getValues().getEndInclusive())).doubleValue();
        this.histogramStep = (this.histogramEnd - this.histogramStart) / (double)histogram.getFrequencies().size();
        DrawingStyle drawingStyle2 = drawingStyle;
        if (drawingStyle2 == null) {
            drawingStyle2 = DEFAULT_DRAWING_STYLE;
        }
        HistogramPanel histogramPanel2 = jPanel = new HistogramPanel(this.frequencies, drawingStyle2, null, 4, null);
        HistogramSlider histogramSlider = this;
        boolean bl = false;
        $this$histogramPanel_u24lambda_u240.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ HistogramSlider this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(@Nullable MouseEvent e) {
                if (e != null) {
                    HistogramSlider.access$setXFirst$p(this.this$0, e.getX());
                }
            }

            public void mouseReleased(@Nullable MouseEvent e) {
                if (e != null) {
                    HistogramSlider.access$setXSecond$p(this.this$0, e.getX());
                    HistogramSlider.access$updateSelectionRange(this.this$0);
                    HistogramSlider.access$notifyRangeChanged(this.this$0);
                }
            }
        });
        $this$histogramPanel_u24lambda_u240.addMouseMotionListener(new MouseAdapter(this){
            final /* synthetic */ HistogramSlider this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseDragged(@Nullable MouseEvent e) {
                if (e != null) {
                    HistogramSlider.access$setXSecond$p(this.this$0, e.getX());
                    HistogramSlider.access$updateSelectionRange(this.this$0);
                }
            }
        });
        histogramSlider.histogramPanel = jPanel;
        this.fromInputField = new SwitchableNumberField((Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ HistogramSlider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Double newFrom) {
                this.this$0.setSelectionRange((ClosedRange<Double>)org.jetbrains.plugins.notebooks.visualization.r.inlays.components.HistogramSlider$Companion.access$makeRange(HistogramSlider.Companion, newFrom, HistogramSlider.access$getToInputField$p(this.this$0).getValue()));
                HistogramSlider.access$notifyRangeChanged(this.this$0);
            }
        }));
        this.toInputField = new SwitchableNumberField((Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ HistogramSlider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Double newTo) {
                this.this$0.setSelectionRange((ClosedRange<Double>)org.jetbrains.plugins.notebooks.visualization.r.inlays.components.HistogramSlider$Companion.access$makeRange(HistogramSlider.Companion, HistogramSlider.access$getFromInputField$p(this.this$0).getValue(), newTo));
                HistogramSlider.access$notifyRangeChanged(this.this$0);
            }
        }));
        $this$histogramPanel_u24lambda_u240 = jPanel = new JPanel(new GridBagLayout());
        histogramSlider = this;
        boolean bl2 = false;
        org.jetbrains.plugins.notebooks.visualization.r.inlays.components.HistogramSlider$Companion.addWithConstraints$default(Companion, (JPanel)$this$rootPanel_u24lambda_u241, this.histogramPanel, 0, 0, 3, null, 1.0, 16, null);
        org.jetbrains.plugins.notebooks.visualization.r.inlays.components.HistogramSlider$Companion.addWithConstraints$default(Companion, (JPanel)$this$rootPanel_u24lambda_u241, this.fromInputField, 0, 1, 0, 0.5, 0.0, 8, null);
        org.jetbrains.plugins.notebooks.visualization.r.inlays.components.HistogramSlider$Companion.addWithConstraints$default(Companion, (JPanel)$this$rootPanel_u24lambda_u241, new JLabel("-", 0), 1, 1, 0, 0.0, 0.0, 8, null);
        org.jetbrains.plugins.notebooks.visualization.r.inlays.components.HistogramSlider$Companion.addWithConstraints$default(Companion, (JPanel)$this$rootPanel_u24lambda_u241, this.toInputField, 2, 1, 0, 0.5, 0.0, 8, null);
        histogramSlider.rootPanel = jPanel;
    }

    public /* synthetic */ HistogramSlider(Histogram histogram, DrawingStyle drawingStyle, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            drawingStyle = null;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(histogram, drawingStyle, (Function1<? super ClosedRange<Double>, Unit>)function1);
    }

    private final void setBackingSelectionRange(ClosedRange<Double> range2) {
        this.backingSelectionRange = range2;
        if (range2 != null) {
            this.fromInputField.silentlyChangeValue((Double)range2.getStart());
            this.toInputField.silentlyChangeValue((Double)range2.getEndInclusive());
        }
    }

    @NotNull
    public final JComponent getComponent() {
        return this.rootPanel;
    }

    @Nullable
    public final ClosedRange<Double> getSelectionRange() {
        return this.backingSelectionRange;
    }

    public final void setSelectionRange(@Nullable ClosedRange<Double> range2) {
        if (!Intrinsics.areEqual(range2, this.backingSelectionRange)) {
            this.setBackingSelectionRange(range2);
            IntRange selectedIndices = this.convertValuesToIndices(range2);
            this.updateHistogramPanel(selectedIndices);
        }
    }

    private final void notifyRangeChanged() {
        block0: {
            Function1<ClosedRange<Double>, Unit> function1 = this.onUserInput;
            if (function1 == null) break block0;
            function1.invoke(this.backingSelectionRange);
        }
    }

    private final IntRange convertValuesToIndices(ClosedRange<Double> values) {
        IntRange intRange;
        ClosedRange<Double> closedRange = values;
        if (closedRange != null) {
            ClosedRange<Double> range2 = closedRange;
            boolean bl = false;
            int startIndex2 = this.convertValueToIndex(((Number)((Object)range2.getStart())).doubleValue(), (Function1<? super Double, Double>)((Function1)convertValuesToIndices.1.startIndex.1.INSTANCE));
            int endIndex2 = this.convertValueToIndex(((Number)((Object)range2.getEndInclusive())).doubleValue(), (Function1<? super Double, Double>)((Function1)convertValuesToIndices.1.endIndex.1.INSTANCE));
            intRange = new IntRange(startIndex2, endIndex2);
        } else {
            intRange = null;
        }
        return intRange;
    }

    private final int convertValueToIndex(double value, Function1<? super Double, Double> rounding) {
        double fractional = (value - this.histogramStart) / this.histogramStep;
        return (int)((Number)rounding.invoke((Object)fractional)).doubleValue();
    }

    private final ClosedRange<Double> convertIndicesToValues(IntRange indices) {
        ClosedFloatingPointRange closedFloatingPointRange;
        IntRange intRange = indices;
        if (intRange != null) {
            IntRange range2 = intRange;
            boolean bl = false;
            double from = this.convertIndexToValue(range2.getFirst());
            double to = this.convertIndexToValue(range2.getLast());
            closedFloatingPointRange = RangesKt.rangeTo((double)from, (double)to);
        } else {
            closedFloatingPointRange = null;
        }
        return (ClosedRange)closedFloatingPointRange;
    }

    private final double convertIndexToValue(int index) {
        return (double)index * this.histogramStep + this.histogramStart;
    }

    private final double convertCoordinateToValue(int coordinate) {
        int width = this.histogramPanel.getWidth();
        double ratio = (double)coordinate / (double)width;
        return Math.floor((double)this.frequencies.size() * this.histogramStep * ratio + this.histogramStart);
    }

    private final void updateSelectionRange() {
        int width = this.histogramPanel.getWidth();
        int xFrom = RangesKt.coerceIn((int)Math.min(this.xFirst, this.xSecond), (int)1, (int)(width - 1));
        int xTo = RangesKt.coerceIn((int)Math.max(this.xFirst, this.xSecond), (int)1, (int)(width - 1));
        double valueFrom = this.convertCoordinateToValue(xFrom);
        double valueTo = this.convertCoordinateToValue(xTo);
        this.setSelectionRange((ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)valueFrom, (double)valueTo)));
        this.setBackingSelectionRange(this.convertIndicesToValues(this.histogramPanel.getSelectedIndices()));
    }

    private final void updateHistogramPanel(IntRange newSelectedIndices) {
        if (!Intrinsics.areEqual((Object)this.histogramPanel.getSelectedIndices(), (Object)newSelectedIndices)) {
            this.histogramPanel.setSelectedIndices(newSelectedIndices);
            this.getComponent().repaint();
        }
    }

    public static final /* synthetic */ SwitchableNumberField access$getToInputField$p(HistogramSlider $this) {
        return $this.toInputField;
    }

    public static final /* synthetic */ void access$notifyRangeChanged(HistogramSlider $this) {
        $this.notifyRangeChanged();
    }

    public static final /* synthetic */ SwitchableNumberField access$getFromInputField$p(HistogramSlider $this) {
        return $this.fromInputField;
    }

    public static final /* synthetic */ void access$setXFirst$p(HistogramSlider $this, int n) {
        $this.xFirst = n;
    }

    public static final /* synthetic */ void access$setXSecond$p(HistogramSlider $this, int n) {
        $this.xSecond = n;
    }

    public static final /* synthetic */ void access$updateSelectionRange(HistogramSlider $this) {
        $this.updateSelectionRange();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\nJ\\\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u001a\u0010\u0017\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0004\u0012\u00020\f0\u0018JK\u0010\u0019\u001a\u00020\f*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u001d2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$Companion;", "", "()V", "DEFAULT_DRAWING_STYLE", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$DrawingStyle;", "makeRange", "Lkotlin/ranges/ClosedRange;", "", "from", "to", "(Ljava/lang/Double;Ljava/lang/Double;)Lkotlin/ranges/ClosedRange;", "show", "", "owner", "Ljavax/swing/JComponent;", "point", "Ljava/awt/Point;", "preferredSize", "Ljava/awt/Dimension;", "histogram", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$Histogram;", "selectedValues", "drawingStyle", "onUserInput", "Lkotlin/Function1;", "addWithConstraints", "Ljavax/swing/JPanel;", "component", "x", "", "y", "width", "xWeight", "yWeight", "(Ljavax/swing/JPanel;Ljavax/swing/JComponent;IIILjava/lang/Double;Ljava/lang/Double;)V", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final void show(@NotNull JComponent owner, @NotNull Point point, @NotNull Dimension preferredSize, @NotNull Histogram histogram, @NotNull ClosedRange<Double> selectedValues, @Nullable DrawingStyle drawingStyle, @NotNull Function1<? super ClosedRange<Double>, Unit> onUserInput) {
            ComponentPopupBuilder componentPopupBuilder;
            HistogramSlider histogramSlider;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
            Intrinsics.checkNotNullParameter((Object)histogram, (String)"histogram");
            Intrinsics.checkNotNullParameter(selectedValues, (String)"selectedValues");
            Intrinsics.checkNotNullParameter(onUserInput, (String)"onUserInput");
            HistogramSlider $this$show_u24lambda_u240 = histogramSlider = new HistogramSlider(histogram, drawingStyle, onUserInput);
            boolean bl = false;
            $this$show_u24lambda_u240.getComponent().setPreferredSize(preferredSize);
            $this$show_u24lambda_u240.setSelectionRange(selectedValues);
            HistogramSlider slider = histogramSlider;
            ComponentPopupBuilder $this$show_u24lambda_u241 = componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(slider.getComponent(), null);
            boolean bl2 = false;
            $this$show_u24lambda_u241.setFocusable(true);
            $this$show_u24lambda_u241.setRequestFocus(true);
            ComponentPopupBuilder componentPopupBuilder2 = componentPopupBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder2, (String)"apply(...)");
            ComponentPopupBuilder popupBuilder = componentPopupBuilder2;
            JBPopup jBPopup = popupBuilder.createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
            JBPopup popup = jBPopup;
            popup.showInScreenCoordinates((Component)owner, point);
        }

        public static /* synthetic */ void show$default(Companion companion, JComponent jComponent, Point point, Dimension dimension, Histogram histogram, ClosedRange closedRange, DrawingStyle drawingStyle, Function1 function1, int n, Object object) {
            if ((n & 0x20) != 0) {
                drawingStyle = null;
            }
            companion.show(jComponent, point, dimension, histogram, (ClosedRange<Double>)closedRange, drawingStyle, (Function1<? super ClosedRange<Double>, Unit>)function1);
        }

        private final void addWithConstraints(JPanel $this$addWithConstraints, JComponent component, int x, int y, int width, Double xWeight, Double yWeight) {
            GridBagConstraints gridBagConstraints;
            GridBagConstraints $this$addWithConstraints_u24lambda_u242 = gridBagConstraints = new GridBagConstraints();
            boolean bl = false;
            $this$addWithConstraints_u24lambda_u242.fill = 1;
            $this$addWithConstraints_u24lambda_u242.insets = (Insets)JBUI.insets((int)(2 * width));
            $this$addWithConstraints_u24lambda_u242.gridx = x;
            $this$addWithConstraints_u24lambda_u242.gridy = y;
            $this$addWithConstraints_u24lambda_u242.gridwidth = width;
            if (xWeight != null) {
                $this$addWithConstraints_u24lambda_u242.weightx = xWeight;
            }
            if (yWeight != null) {
                $this$addWithConstraints_u24lambda_u242.weighty = yWeight;
            }
            GridBagConstraints constraints = gridBagConstraints;
            $this$addWithConstraints.add((Component)component, constraints);
        }

        static /* synthetic */ void addWithConstraints$default(Companion companion, JPanel jPanel, JComponent jComponent, int n, int n2, int n3, Double d, Double d2, int n4, Object object) {
            if ((n4 & 8) != 0) {
                n3 = 1;
            }
            if ((n4 & 0x10) != 0) {
                d = null;
            }
            if ((n4 & 0x20) != 0) {
                d2 = null;
            }
            companion.addWithConstraints(jPanel, jComponent, n, n2, n3, d, d2);
        }

        private final ClosedRange<Double> makeRange(Double from, Double to) {
            ClosedFloatingPointRange closedFloatingPointRange;
            Double d = from;
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                Double d2 = to;
                if (d2 != null) {
                    double it2 = ((Number)d2).doubleValue();
                    boolean bl2 = false;
                    closedFloatingPointRange = from <= to ? RangesKt.rangeTo((double)from, (double)to) : null;
                } else {
                    closedFloatingPointRange = null;
                }
            } else {
                closedFloatingPointRange = null;
            }
            return (ClosedRange)closedFloatingPointRange;
        }

        public static final /* synthetic */ ClosedRange access$makeRange(Companion $this, Double from, Double to) {
            return $this.makeRange(from, to);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$DrawingStyle;", "", "histogramColor", "Ljava/awt/Color;", "selectionColor", "backgroundColor", "(Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "getBackgroundColor", "()Ljava/awt/Color;", "getHistogramColor", "getSelectionColor", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.notebooks.visualization"})
    public static final class DrawingStyle {
        @NotNull
        private final Color histogramColor;
        @NotNull
        private final Color selectionColor;
        @Nullable
        private final Color backgroundColor;

        public DrawingStyle(@NotNull Color histogramColor, @NotNull Color selectionColor, @Nullable Color backgroundColor) {
            Intrinsics.checkNotNullParameter((Object)histogramColor, (String)"histogramColor");
            Intrinsics.checkNotNullParameter((Object)selectionColor, (String)"selectionColor");
            this.histogramColor = histogramColor;
            this.selectionColor = selectionColor;
            this.backgroundColor = backgroundColor;
        }

        @NotNull
        public final Color getHistogramColor() {
            return this.histogramColor;
        }

        @NotNull
        public final Color getSelectionColor() {
            return this.selectionColor;
        }

        @Nullable
        public final Color getBackgroundColor() {
            return this.backgroundColor;
        }

        @NotNull
        public final Color component1() {
            return this.histogramColor;
        }

        @NotNull
        public final Color component2() {
            return this.selectionColor;
        }

        @Nullable
        public final Color component3() {
            return this.backgroundColor;
        }

        @NotNull
        public final DrawingStyle copy(@NotNull Color histogramColor, @NotNull Color selectionColor, @Nullable Color backgroundColor) {
            Intrinsics.checkNotNullParameter((Object)histogramColor, (String)"histogramColor");
            Intrinsics.checkNotNullParameter((Object)selectionColor, (String)"selectionColor");
            return new DrawingStyle(histogramColor, selectionColor, backgroundColor);
        }

        public static /* synthetic */ DrawingStyle copy$default(DrawingStyle drawingStyle, Color color, Color color2, Color color3, int n, Object object) {
            if ((n & 1) != 0) {
                color = drawingStyle.histogramColor;
            }
            if ((n & 2) != 0) {
                color2 = drawingStyle.selectionColor;
            }
            if ((n & 4) != 0) {
                color3 = drawingStyle.backgroundColor;
            }
            return drawingStyle.copy(color, color2, color3);
        }

        @NotNull
        public String toString() {
            return "DrawingStyle(histogramColor=" + this.histogramColor + ", selectionColor=" + this.selectionColor + ", backgroundColor=" + this.backgroundColor + ")";
        }

        public int hashCode() {
            int result2 = this.histogramColor.hashCode();
            result2 = result2 * 31 + this.selectionColor.hashCode();
            result2 = result2 * 31 + (this.backgroundColor == null ? 0 : this.backgroundColor.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DrawingStyle)) {
                return false;
            }
            DrawingStyle drawingStyle = (DrawingStyle)other;
            if (!Intrinsics.areEqual((Object)this.histogramColor, (Object)drawingStyle.histogramColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.selectionColor, (Object)drawingStyle.selectionColor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.backgroundColor, (Object)drawingStyle.backgroundColor);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$Histogram;", "", "frequencies", "", "", "values", "Lkotlin/ranges/ClosedRange;", "(Ljava/util/List;Lkotlin/ranges/ClosedRange;)V", "getFrequencies", "()Ljava/util/List;", "getValues", "()Lkotlin/ranges/ClosedRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.notebooks.visualization"})
    public static final class Histogram {
        @NotNull
        private final List<Double> frequencies;
        @NotNull
        private final ClosedRange<Double> values;

        public Histogram(@NotNull List<Double> frequencies, @NotNull ClosedRange<Double> values) {
            Intrinsics.checkNotNullParameter(frequencies, (String)"frequencies");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.frequencies = frequencies;
            this.values = values;
        }

        @NotNull
        public final List<Double> getFrequencies() {
            return this.frequencies;
        }

        @NotNull
        public final ClosedRange<Double> getValues() {
            return this.values;
        }

        @NotNull
        public final List<Double> component1() {
            return this.frequencies;
        }

        @NotNull
        public final ClosedRange<Double> component2() {
            return this.values;
        }

        @NotNull
        public final Histogram copy(@NotNull List<Double> frequencies, @NotNull ClosedRange<Double> values) {
            Intrinsics.checkNotNullParameter(frequencies, (String)"frequencies");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new Histogram(frequencies, values);
        }

        public static /* synthetic */ Histogram copy$default(Histogram histogram, List list, ClosedRange closedRange, int n, Object object) {
            if ((n & 1) != 0) {
                list = histogram.frequencies;
            }
            if ((n & 2) != 0) {
                closedRange = histogram.values;
            }
            return histogram.copy(list, closedRange);
        }

        @NotNull
        public String toString() {
            return "Histogram(frequencies=" + this.frequencies + ", values=" + this.values + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.frequencies).hashCode();
            result2 = result2 * 31 + this.values.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Histogram)) {
                return false;
            }
            Histogram histogram = (Histogram)other;
            if (!Intrinsics.areEqual(this.frequencies, histogram.frequencies)) {
                return false;
            }
            return Intrinsics.areEqual(this.values, histogram.values);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$HistogramPanel;", "Ljavax/swing/JPanel;", "frequencies", "", "", "drawingStyle", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$DrawingStyle;", "selectedIndices", "Lkotlin/ranges/IntRange;", "(Ljava/util/List;Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$DrawingStyle;Lkotlin/ranges/IntRange;)V", "getSelectedIndices", "()Lkotlin/ranges/IntRange;", "setSelectedIndices", "(Lkotlin/ranges/IntRange;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.notebooks.visualization"})
    private static final class HistogramPanel
    extends JPanel {
        @NotNull
        private final List<Double> frequencies;
        @NotNull
        private final DrawingStyle drawingStyle;
        @Nullable
        private IntRange selectedIndices;

        public HistogramPanel(@NotNull List<Double> frequencies, @NotNull DrawingStyle drawingStyle, @Nullable IntRange selectedIndices) {
            Intrinsics.checkNotNullParameter(frequencies, (String)"frequencies");
            Intrinsics.checkNotNullParameter((Object)drawingStyle, (String)"drawingStyle");
            this.frequencies = frequencies;
            this.drawingStyle = drawingStyle;
            this.selectedIndices = selectedIndices;
        }

        public /* synthetic */ HistogramPanel(List list, DrawingStyle drawingStyle, IntRange intRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                intRange = null;
            }
            this(list, drawingStyle, intRange);
        }

        @Nullable
        public final IntRange getSelectedIndices() {
            return this.selectedIndices;
        }

        public final void setSelectedIndices(@Nullable IntRange intRange) {
            this.selectedIndices = intRange;
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Color color = this.drawingStyle.getBackgroundColor();
                if (color != null) {
                    Color color2 = color;
                    boolean bl = false;
                    g.setColor(color2);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                int columnWidth = this.getWidth() / this.frequencies.size();
                g.setColor(this.drawingStyle.getHistogramColor());
                Iterator<Double> iterator2 = this.frequencies.iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int index = n++;
                    double value = ((Number)iterator2.next()).doubleValue();
                    double clamped = RangesKt.coerceIn((double)value, (double)0.0, (double)1.0);
                    int columnHeight = (int)((double)this.getHeight() * clamped);
                    g.fillRect(index * columnWidth, this.getHeight() - columnHeight, columnWidth, columnHeight);
                }
                IntRange intRange = this.selectedIndices;
                if (intRange == null) break block2;
                IntRange indices = intRange;
                boolean bl = false;
                int first = RangesKt.coerceIn((int)indices.getFirst(), (int)0, (int)this.frequencies.size());
                int last = RangesKt.coerceIn((int)indices.getLast(), (int)0, (int)this.frequencies.size());
                int from = first * columnWidth;
                int selectionWidth = (last - first) * columnWidth;
                g.setColor(this.drawingStyle.getSelectionColor());
                g.fillRect(from, 0, selectionWidth, this.getHeight());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000f\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/HistogramSlider$SwitchableNumberField;", "Ljavax/swing/JTextField;", "onValueChanged", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "isActive", "", "newValue", "value", "getValue", "()Ljava/lang/Double;", "setValue", "(Ljava/lang/Double;)V", "silentlyChangeValue", "intellij.notebooks.visualization"})
    private static final class SwitchableNumberField
    extends JTextField {
        private boolean isActive;

        public SwitchableNumberField(final @NotNull Function1<? super Double, Unit> onValueChanged) {
            Intrinsics.checkNotNullParameter(onValueChanged, (String)"onValueChanged");
            this.isActive = true;
            this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (isActive) {
                        String string = this.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        Double newValue = StringsKt.toDoubleOrNull((String)string);
                        onValueChanged.invoke((Object)newValue);
                    }
                }
            });
        }

        @Nullable
        public final Double getValue() {
            String string = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return StringsKt.toDoubleOrNull((String)string);
        }

        public final void setValue(@Nullable Double newValue) {
            Double d = newValue;
            this.setText(d != null ? d.toString() : null);
        }

        public final void silentlyChangeValue(@Nullable Double newValue) {
            if (!Intrinsics.areEqual((Double)this.getValue(), (Double)newValue)) {
                this.isActive = false;
                this.setValue(newValue);
                this.isActive = true;
            }
        }
    }
}

