/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.sheet;

import com.openhtmltopdf.css.newmatch.Selector;
import com.openhtmltopdf.css.sheet.InvalidPropertyDeclaration;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Ruleset {
    private final int _origin;
    private final List<PropertyDeclaration> _props;
    private final List<Selector> _fsSelectors;
    private List<InvalidPropertyDeclaration> _invalidProperties;

    public Ruleset(int orig) {
        this._origin = orig;
        this._props = new ArrayList<PropertyDeclaration>();
        this._fsSelectors = new ArrayList<Selector>();
    }

    public List<PropertyDeclaration> getPropertyDeclarations() {
        return Collections.unmodifiableList(this._props);
    }

    public void addProperty(PropertyDeclaration decl) {
        this._props.add(decl);
    }

    public void addAllProperties(List<PropertyDeclaration> props) {
        this._props.addAll(props);
    }

    public void addFSSelector(Selector selector) {
        this._fsSelectors.add(selector);
    }

    public List<Selector> getFSSelectors() {
        return this._fsSelectors;
    }

    public int getOrigin() {
        return this._origin;
    }

    public void toCSS(StringBuilder sb) {
        List<PropertyDeclaration> decls;
        if (this._invalidProperties != null) {
            decls = new ArrayList<PropertyDeclaration>(this._props);
            for (InvalidPropertyDeclaration invalidPropertyDeclaration : this._invalidProperties) {
                decls.add(invalidPropertyDeclaration.getOrder(), invalidPropertyDeclaration);
            }
        } else {
            decls = this._props;
        }
        sb.append('{');
        sb.append('\n');
        for (PropertyDeclaration propertyDeclaration : decls) {
            propertyDeclaration.toCSS(sb);
            sb.append('\n');
        }
        sb.append('}');
        sb.append('\n');
    }

    public void addInvalidProperty(InvalidPropertyDeclaration invalidPropertyDeclaration) {
        if (this._invalidProperties == null) {
            this._invalidProperties = new ArrayList<InvalidPropertyDeclaration>();
        }
        this._invalidProperties.add(invalidPropertyDeclaration);
    }

    public List<InvalidPropertyDeclaration> getInvalidPropertyDeclarations() {
        return this._invalidProperties == null ? Collections.emptyList() : this._invalidProperties;
    }
}

