/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.sheet;

import com.openhtmltopdf.css.sheet.Stylesheet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class StylesheetInfo {
    private Stylesheet stylesheet = null;
    private String title;
    private String uri;
    private int origin = 0;
    private String type;
    private final List<String> mediaTypes = new ArrayList<String>();
    private String content;
    public static final int USER_AGENT = 0;
    public static final int USER = 1;
    public static final int AUTHOR = 2;

    public boolean appliesToMedia(String m) {
        if (this.mediaTypes.contains("all")) {
            return true;
        }
        String media = m.toLowerCase(Locale.US);
        return media.equals("all") || this.mediaTypes.contains(media);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setMedia(String media) {
        this.mediaTypes.clear();
        if (media == null || media.isEmpty()) {
            this.addMedium("all");
        } else {
            Arrays.stream(media.split(",")).map(mediaType -> mediaType.trim().toLowerCase(Locale.US)).forEach(this::addMedium);
        }
    }

    public void addMedium(String medium) {
        this.mediaTypes.add(medium);
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStylesheet(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public String getUri() {
        return this.uri;
    }

    public List<String> getMedia() {
        return this.mediaTypes;
    }

    public int getOrigin() {
        return this.origin;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isInline() {
        return this.content != null;
    }
}

