/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.PkceUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.DigestUtil;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.cloud.api.QodanaCloudEnvironment;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthCredentialsAcquirer;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthService;
import org.jetbrains.qodana.cloud.authorization.credentials.QodanaCloudCredentials;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lorg/jetbrains/qodana/cloud/authorization/credentials/QodanaCloudCredentials;", "port", "", "environment", "Lorg/jetbrains/qodana/cloud/api/QodanaCloudEnvironment;", "authUrl", "Lcom/intellij/util/Url;", "(ILorg/jetbrains/qodana/cloud/api/QodanaCloudEnvironment;Lcom/intellij/util/Url;)V", "authUrlWithParameters", "getAuthUrlWithParameters", "()Lcom/intellij/util/Url;", "authorizationCodeUrl", "getAuthorizationCodeUrl", "codeChallenge", "", "codeVerifier", "credentialsAcquirer", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getEnvironment", "()Lorg/jetbrains/qodana/cloud/api/QodanaCloudEnvironment;", "getPort", "()I", "stateWithEmbeddedPortAndChallenge", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaCloudOAuthRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCloudOAuthRequest.kt\norg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,39:1\n42#2,3:40\n*S KotlinDebug\n*F\n+ 1 QodanaCloudOAuthRequest.kt\norg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest\n*L\n35#1:40,3\n*E\n"})
public final class QodanaCloudOAuthRequest
implements OAuthRequest<QodanaCloudCredentials> {
    private final int port;
    @NotNull
    private final QodanaCloudEnvironment environment;
    @NotNull
    private final String codeVerifier;
    @NotNull
    private final String codeChallenge;
    @NotNull
    private final String stateWithEmbeddedPortAndChallenge;
    @NotNull
    private final Url authUrlWithParameters;

    public QodanaCloudOAuthRequest(int port, @NotNull QodanaCloudEnvironment environment, @NotNull Url authUrl) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)authUrl, (String)"authUrl");
        this.port = port;
        this.environment = environment;
        this.codeVerifier = PkceUtils.INSTANCE.generateCodeVerifier();
        Base64.Encoder encoder = Base64.getEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"getEncoder(...)");
        this.codeChallenge = PkceUtils.INSTANCE.generateShaCodeChallenge(this.codeVerifier, encoder);
        this.stateWithEmbeddedPortAndChallenge = "idea-" + this.port + "-" + DigestUtil.randomToken();
        Url url = authUrl.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"state", (Object)this.stateWithEmbeddedPortAndChallenge)));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        this.authUrlWithParameters = url;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final QodanaCloudEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public Url getAuthUrlWithParameters() {
        return this.authUrlWithParameters;
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        boolean $i$f$service = false;
        Class<QodanaCloudOAuthService> serviceClass$iv = QodanaCloudOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return Urls.newFromEncoded((String)("http://localhost:" + this.port + "/api/" + ((QodanaCloudOAuthService)object).getName() + "/authorization_code/"));
    }

    @NotNull
    public OAuthCredentialsAcquirer<QodanaCloudCredentials> getCredentialsAcquirer() {
        return new QodanaCloudOAuthCredentialsAcquirer(this.environment, this.codeVerifier);
    }
}

