/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

class YAMLQuotedTextTextEvaluator
extends YamlScalarTextEvaluator<YAMLQuotedTextImpl> {
    YAMLQuotedTextTextEvaluator(YAMLQuotedTextImpl text) {
        super(text);
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ASTNode firstContentNode = ((YAMLQuotedTextImpl)this.myHost).getFirstContentNode();
        if (firstContentNode == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                YAMLQuotedTextTextEvaluator.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        TextRange contentRange = TextRange.create((int)firstContentNode.getStartOffset(), (int)((YAMLQuotedTextImpl)this.myHost).getTextRange().getEndOffset()).shiftRight(-((YAMLQuotedTextImpl)this.myHost).getTextRange().getStartOffset());
        List lines = StringUtil.split((String)contentRange.substring(((YAMLQuotedTextImpl)this.myHost).getText()), (String)"\n", (boolean)true, (boolean)false);
        int cumulativeOffset = contentRange.getStartOffset();
        for (int i = 0; i < lines.size(); ++i) {
            int lineStart;
            String line = (String)lines.get(i);
            int lineEnd = line.length();
            if (i == 0) {
                ++lineStart;
            } else {
                for (lineStart = 0; lineStart < line.length() && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineStart)); ++lineStart) {
                }
            }
            if (i == lines.size() - 1) {
                --lineEnd;
            } else {
                while (lineEnd > lineStart && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineEnd - 1))) {
                    --lineEnd;
                }
            }
            result.add(TextRange.create((int)lineStart, (int)lineEnd).shiftRight(cumulativeOffset));
            cumulativeOffset += line.length() + 1;
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            YAMLQuotedTextTextEvaluator.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges2, int indexBefore) {
        TextRange leftRange;
        if (text == null) {
            YAMLQuotedTextTextEvaluator.$$$reportNull$$$0(2);
        }
        if (contentRanges2 == null) {
            YAMLQuotedTextTextEvaluator.$$$reportNull$$$0(3);
        }
        if ((leftRange = contentRanges2.get(indexBefore)).isEmpty() || !((YAMLQuotedTextImpl)this.myHost).isSingleQuote() && text.charAt(leftRange.getEndOffset() - 1) == '\\') {
            return "\n";
        }
        if (contentRanges2.get(indexBefore + 1).isEmpty()) {
            return "";
        }
        return " ";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLQuotedTextTextEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRanges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLQuotedTextTextEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRangesJoiner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

