/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.list;

import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.openapi.project.Project;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.GHApiLoadingErrorHandler;
import org.jetbrains.plugins.github.ui.component.GHHtmlErrorPanel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0015\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0015\u0010\u0013\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/list/GHPRErrorStatusPresenter;", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter$Text;", "", "project", "Lcom/intellij/openapi/project/Project;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "resetRunnable", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Lkotlin/jvm/functions/Function0;)V", "errorHandler", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHApiLoadingErrorHandler;", "getErrorAction", "Ljavax/swing/Action;", "error", "getErrorDescription", "", "Lorg/jetbrains/annotations/Nls;", "getErrorTitle", "intellij.vcs.github"})
public final class GHPRErrorStatusPresenter
implements ErrorStatusPresenter.Text<Throwable> {
    @NotNull
    private final GHApiLoadingErrorHandler errorHandler;

    public GHPRErrorStatusPresenter(@NotNull Project project, @NotNull GithubAccount account, @NotNull Function0<Unit> resetRunnable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter(resetRunnable, (String)"resetRunnable");
        this.errorHandler = new GHApiLoadingErrorHandler(project, account, resetRunnable);
    }

    @NotNull
    public String getErrorTitle(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        String string = GithubBundle.message("pull.request.list.cannot.load", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getErrorDescription(@NotNull Throwable error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (error instanceof GithubAuthenticationException) {
            String string2 = GithubBundle.message("pull.request.list.error.authorization", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            string = GHHtmlErrorPanel.INSTANCE.getLoadingErrorText(error);
        }
        return string;
    }

    @NotNull
    public Action getErrorAction(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return this.errorHandler.getActionForError(error);
    }
}

