/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.messages;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.io.IOException;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J,\u0010\u0013\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0015\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u001e\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/editorconfig/language/messages/EditorConfigWrongFileNameNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "HIDDEN_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "buildPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "renameRunnable", "Ljava/lang/Runnable;", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "createNotificationPanel", "fileEditor", "createRenameRunnable", "error", "", "message", "", "findEditorConfig", "Lorg/jetbrains/annotations/Nullable;", "nameMatches", "update", "intellij.editorconfig"})
public final class EditorConfigWrongFileNameNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    @NotNull
    private final Key<Boolean> HIDDEN_KEY;

    public EditorConfigWrongFileNameNotificationProvider() {
        Key key = Key.create((String)"editorconfig.wrong.name.notification.hidden");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.HIDDEN_KEY = key;
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (PropertiesComponent.getInstance().isTrueValue("editorconfig.wrong.name.notification.disabled")) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"editorconfig")) {
            return null;
        }
        if (this.nameMatches(file)) {
            return null;
        }
        Runnable renameRunnable = this.createRenameRunnable(project, file);
        return arg_0 -> EditorConfigWrongFileNameNotificationProvider.collectNotificationData$lambda$0(this, file, project, renameRunnable, arg_0);
    }

    private final EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor, Project project, Runnable renameRunnable) {
        if (!(fileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        if (editor2.getUserData(this.HIDDEN_KEY) != null) {
            return null;
        }
        return this.buildPanel(editor2, file, project, renameRunnable);
    }

    private final Runnable createRenameRunnable(Project project, VirtualFile file) {
        if (this.findEditorConfig(file) == null) {
            return () -> EditorConfigWrongFileNameNotificationProvider.createRenameRunnable$lambda$1(file, this, project);
        }
        return null;
    }

    private final EditorNotificationPanel buildPanel(Editor editor, VirtualFile file, Project project, Runnable renameRunnable) {
        EditorNotificationPanel result2 = new EditorNotificationPanel(editor, null, null, EditorNotificationPanel.Status.Warning);
        if (renameRunnable != null) {
            String rename = EditorConfigBundle.INSTANCE.get("notification.action.rename");
            result2.createActionLabel(rename, renameRunnable);
        }
        String hide = EditorConfigBundle.INSTANCE.get("notification.action.hide.once");
        result2.createActionLabel(hide, () -> EditorConfigWrongFileNameNotificationProvider.buildPanel$lambda$2(editor, this, file, project));
        String hideForever = EditorConfigBundle.INSTANCE.get("notification.action.hide.forever");
        result2.createActionLabel(hideForever, () -> EditorConfigWrongFileNameNotificationProvider.buildPanel$lambda$3(this, file, project));
        EditorNotificationPanel editorNotificationPanel = result2.text(EditorConfigBundle.INSTANCE.get("notification.rename.message"));
        Intrinsics.checkNotNullExpressionValue((Object)editorNotificationPanel, (String)"text(...)");
        return editorNotificationPanel;
    }

    private final VirtualFile findEditorConfig(VirtualFile file) {
        return file.getParent().findChild(".editorconfig");
    }

    private final void error(@Nls String message2, Project project) {
        Notification notification = new Notification("editorconfig", "EditorConfig", message2, NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private final boolean nameMatches(VirtualFile file) {
        return Intrinsics.areEqual((Object)file.getNameWithoutExtension(), (Object)"");
    }

    private final void update(VirtualFile file, Project project) {
        EditorNotifications.getInstance((Project)project).updateNotifications(file);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(EditorConfigWrongFileNameNotificationProvider this$0, VirtualFile $file, Project $project, Runnable $renameRunnable, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createNotificationPanel($file, it, $project, $renameRunnable);
    }

    private static final void createRenameRunnable$lambda$1(VirtualFile $file, EditorConfigWrongFileNameNotificationProvider this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        if (ActionsKt.runReadAction((Function0)((Function0)new Function0<VirtualFile>(this$0, $file){
            final /* synthetic */ EditorConfigWrongFileNameNotificationProvider this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final VirtualFile invoke() {
                return EditorConfigWrongFileNameNotificationProvider.access$findEditorConfig(this.this$0, this.$file);
            }
        })) != null) {
            $file.getParent().findChild(".editorconfig");
            String message2 = EditorConfigBundle.INSTANCE.get("notification.error.file.already.exists");
            this$0.error(message2, $project);
            return;
        }
        try {
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>($file, this$0){
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ EditorConfigWrongFileNameNotificationProvider this$0;
                {
                    this.$file = $file;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$file.rename((Object)this.this$0, ".editorconfig");
                }
            }));
        }
        catch (IOException ex) {
            Object[] objectArray = new Object[1];
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            String message3 = EditorConfigBundle.INSTANCE.get("notification.error.ioexception", objectArray);
            throw new IllegalStateException(message3.toString());
        }
        this$0.update($file, $project);
    }

    private static final void buildPanel$lambda$2(Editor $editor, EditorConfigWrongFileNameNotificationProvider this$0, VirtualFile $file, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $editor.putUserData(this$0.HIDDEN_KEY, (Object)true);
        this$0.update($file, $project);
    }

    private static final void buildPanel$lambda$3(EditorConfigWrongFileNameNotificationProvider this$0, VirtualFile $file, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        PropertiesComponent.getInstance().setValue("editorconfig.wrong.name.notification.disabled", true);
        this$0.update($file, $project);
    }

    public static final /* synthetic */ VirtualFile access$findEditorConfig(EditorConfigWrongFileNameNotificationProvider $this, VirtualFile file) {
        return $this.findEditorConfig(file);
    }
}

