/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.JTableCellPreconditions;
import org.assertj.swing.edt.GuiActionRunner;

final class JTableCancelCellEditingTask {
    @RunsInEDT
    static void cancelEditing(@Nonnull JTable table, int row2, int column) {
        GuiActionRunner.execute(() -> {
            JTableCellPreconditions.checkCellIndicesInBounds(table, row2, column);
            JTableCellPreconditions.validateCellIsEditable(table, row2, column);
            TableCellEditor cellEditor = table.getCellEditor(row2, column);
            JTableCancelCellEditingTask.doCancelEditing(cellEditor);
        });
    }

    @RunsInEDT
    static void cancelEditing(@Nonnull TableCellEditor cellEditor) {
        GuiActionRunner.execute(() -> JTableCancelCellEditingTask.doCancelEditing(cellEditor));
    }

    private static void doCancelEditing(@Nullable TableCellEditor cellEditor) {
        if (cellEditor == null) {
            return;
        }
        cellEditor.cancelCellEditing();
    }

    private JTableCancelCellEditingTask() {
    }
}

