/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import java.awt.Color;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;

public final class Colors {
    @Nonnull
    public static Color colorFromHexString(@Nonnull String hexString) {
        Preconditions.checkNotNullOrEmpty(hexString);
        try {
            return new Color(Integer.parseInt(hexString, 16));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(Strings.concat("The hexadecimal code ", Strings.quote(hexString), " is not a valid color code"));
        }
    }

    private Colors() {
    }
}

