/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.searchEverywhereMl.SearchEverywhereMlExperiment;
import com.intellij.searchEverywhereMl.SearchEverywhereTabWithMlRanking;
import com.intellij.searchEverywhereMl.settings.SearchEverywhereMlSettings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\u0018\u0000 #2\u00020\u0001:\u0003#$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014J\u0019\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u001eH\u0001\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u000e\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u0019R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR$\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment;", "", "()V", "computedGroup", "", "getComputedGroup", "()I", "computedGroup$delegate", "Lkotlin/Lazy;", "experimentGroup", "getExperimentGroup", "isAllowed", "", "()Z", "<set-?>", "isExperimentalMode", "setExperimentalMode", "(Z)V", "tabExperiments", "Ljava/util/HashMap;", "Lcom/intellij/searchEverywhereMl/SearchEverywhereTabWithMlRanking;", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Experiment;", "Lkotlin/collections/HashMap;", "tabsWithEnabledLogging", "", "", "getExperimentForTab", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "tab", "getTabExperiments", "", "getTabExperiments$intellij_searchEverywhereMl", "isDisableExperiments", "isLoggingEnabledForTab", "tabId", "Companion", "Experiment", "ExperimentType", "intellij.searchEverywhereMl"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereMlExperiment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereMlExperiment.kt\ncom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,117:1\n42#2,3:118\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereMlExperiment.kt\ncom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment\n*L\n86#1:118,3\n*E\n"})
public final class SearchEverywhereMlExperiment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isExperimentalMode = StatisticsUploadAssistant.isSendAllowed() && ApplicationManager.getApplication().isEAP();
    @NotNull
    private final Set<String> tabsWithEnabledLogging;
    @NotNull
    private final HashMap<SearchEverywhereTabWithMlRanking, Experiment> tabExperiments;
    @NotNull
    private final Lazy computedGroup$delegate;
    public static final int VERSION = 1;
    public static final int NUMBER_OF_GROUPS = 4;

    public SearchEverywhereMlExperiment() {
        Object[] objectArray = new String[]{SearchEverywhereTabWithMlRanking.ACTION.getTabId(), SearchEverywhereTabWithMlRanking.FILES.getTabId(), SearchEverywhereTabWithMlRanking.CLASSES.getTabId(), SearchEverywhereTabWithMlRanking.SYMBOLS.getTabId(), SearchEverywhereTabWithMlRanking.ALL.getTabId()};
        this.tabsWithEnabledLogging = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[4];
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ExperimentType.ENABLE_SEMANTIC_SEARCH)), TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.ENABLE_TYPOS))};
        objectArray[0] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.ACTION), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ExperimentType.ENABLE_SEMANTIC_SEARCH)), TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.NO_ML))};
        objectArray[1] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.FILES), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)((Object)ExperimentType.ENABLE_SEMANTIC_SEARCH)), TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.NO_ML))};
        objectArray[2] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.CLASSES), (Object)new Experiment(pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)2, (Object)((Object)ExperimentType.USE_EXPERIMENTAL_MODEL)), TuplesKt.to((Object)3, (Object)((Object)ExperimentType.NO_RECENT_FILES_PRIORITIZATION))};
        objectArray[3] = TuplesKt.to((Object)((Object)SearchEverywhereTabWithMlRanking.ALL), (Object)new Experiment(pairArray));
        this.tabExperiments = MapsKt.hashMapOf((Pair[])objectArray);
        this.computedGroup$delegate = LazyKt.lazy((Function0)computedGroup.2.INSTANCE);
    }

    public final boolean isExperimentalMode() {
        return this.isExperimentalMode;
    }

    @TestOnly
    public final void setExperimentalMode(boolean bl) {
        this.isExperimentalMode = bl;
    }

    public final boolean isAllowed() {
        return this.isExperimentalMode && !Registry.is((String)"search.everywhere.force.disable.logging.ml");
    }

    public final int getExperimentGroup() {
        int registryExperimentGroup;
        return this.isExperimentalMode ? ((registryExperimentGroup = Registry.intValue((String)"search.everywhere.ml.experiment.group", (int)-1, (int)-1, (int)3)) >= 0 ? registryExperimentGroup : this.getComputedGroup()) : -1;
    }

    private final int getComputedGroup() {
        Lazy lazy = this.computedGroup$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final boolean isLoggingEnabledForTab(@NotNull String tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        return this.tabsWithEnabledLogging.contains(tabId);
    }

    private final boolean isDisableExperiments(SearchEverywhereTabWithMlRanking tab) {
        String string = tab.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return Registry.is((String)("search.everywhere.force.disable.experiment." + string + ".ml"));
    }

    @NotNull
    public final ExperimentType getExperimentForTab(@NotNull SearchEverywhereTabWithMlRanking tab) {
        ExperimentType experimentByGroup;
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        boolean $i$f$service = false;
        Class<SearchEverywhereMlSettings> serviceClass$iv = SearchEverywhereMlSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        SearchEverywhereMlSettings settings = (SearchEverywhereMlSettings)object;
        if (!this.isAllowed() || this.isDisableExperiments(tab)) {
            settings.disableExperiment(tab);
            return ExperimentType.NO_EXPERIMENT;
        }
        Experiment experiment = this.tabExperiments.get((Object)tab);
        ExperimentType experimentType = experimentByGroup = experiment != null ? experiment.getExperimentByGroup(this.getExperimentGroup()) : null;
        if (experimentByGroup == null || experimentByGroup == ExperimentType.NO_EXPERIMENT) {
            settings.disableExperiment(tab);
            return ExperimentType.NO_EXPERIMENT;
        }
        boolean enabledMlRanking = experimentByGroup != ExperimentType.NO_ML && experimentByGroup != ExperimentType.NO_ML_FEATURES;
        boolean isExperimentAllowed = settings.updateExperimentStateIfAllowed(tab, enabledMlRanking);
        return isExperimentAllowed ? experimentByGroup : ExperimentType.NO_EXPERIMENT;
    }

    @TestOnly
    @NotNull
    public final Map<SearchEverywhereTabWithMlRanking, Experiment> getTabExperiments$intellij_searchEverywhereMl() {
        return this.tabExperiments;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Companion;", "", "()V", "NUMBER_OF_GROUPS", "", "VERSION", "intellij.searchEverywhereMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B1\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0005R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$Experiment;", "", "experiments", "", "Lkotlin/Pair;", "", "Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "([Lkotlin/Pair;)V", "tabExperiments", "", "getTabExperiments", "()Ljava/util/Map;", "getExperimentByGroup", "group", "intellij.searchEverywhereMl"})
    @VisibleForTesting
    public static final class Experiment {
        @NotNull
        private final Map<Integer, ExperimentType> tabExperiments;

        public Experiment(Pair<Integer, ? extends ExperimentType> ... experiments) {
            Intrinsics.checkNotNullParameter(experiments, (String)"experiments");
            this.tabExperiments = MapsKt.hashMapOf(Arrays.copyOf(experiments, experiments.length));
        }

        @NotNull
        public final Map<Integer, ExperimentType> getTabExperiments() {
            return this.tabExperiments;
        }

        @NotNull
        public final ExperimentType getExperimentByGroup(int group) {
            return this.tabExperiments.getOrDefault(group, ExperimentType.NO_EXPERIMENT);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/searchEverywhereMl/SearchEverywhereMlExperiment$ExperimentType;", "", "(Ljava/lang/String;I)V", "NO_EXPERIMENT", "NO_ML", "USE_EXPERIMENTAL_MODEL", "NO_ML_FEATURES", "ENABLE_TYPOS", "NO_RECENT_FILES_PRIORITIZATION", "ENABLE_SEMANTIC_SEARCH", "intellij.searchEverywhereMl"})
    public static final class ExperimentType
    extends Enum<ExperimentType> {
        public static final /* enum */ ExperimentType NO_EXPERIMENT = new ExperimentType();
        public static final /* enum */ ExperimentType NO_ML = new ExperimentType();
        public static final /* enum */ ExperimentType USE_EXPERIMENTAL_MODEL = new ExperimentType();
        public static final /* enum */ ExperimentType NO_ML_FEATURES = new ExperimentType();
        public static final /* enum */ ExperimentType ENABLE_TYPOS = new ExperimentType();
        public static final /* enum */ ExperimentType NO_RECENT_FILES_PRIORITIZATION = new ExperimentType();
        public static final /* enum */ ExperimentType ENABLE_SEMANTIC_SEARCH = new ExperimentType();
        private static final /* synthetic */ ExperimentType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ExperimentType[] values() {
            return (ExperimentType[])$VALUES.clone();
        }

        public static ExperimentType valueOf(String value) {
            return Enum.valueOf(ExperimentType.class, value);
        }

        @NotNull
        public static EnumEntries<ExperimentType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = experimentTypeArray = new ExperimentType[]{ExperimentType.NO_EXPERIMENT, ExperimentType.NO_ML, ExperimentType.USE_EXPERIMENTAL_MODEL, ExperimentType.NO_ML_FEATURES, ExperimentType.ENABLE_TYPOS, ExperimentType.NO_RECENT_FILES_PRIORITIZATION, ExperimentType.ENABLE_SEMANTIC_SEARCH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

