/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.history;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.exp.history.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.exp.history.CommandHistoryUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/exp/history/CommandHistoryPresenter;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;)V", "initialCommand", "", "onCommandHistoryClosed", "", "showCommandHistory", "history", "", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nCommandHistoryPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandHistoryPresenter.kt\norg/jetbrains/plugins/terminal/exp/history/CommandHistoryPresenter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n9#2:93\n*S KotlinDebug\n*F\n+ 1 CommandHistoryPresenter.kt\norg/jetbrains/plugins/terminal/exp/history/CommandHistoryPresenter\n*L\n66#1:93\n*E\n"})
public final class CommandHistoryPresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final TerminalCommandExecutor commandExecutor;
    @Nullable
    private String initialCommand;
    @NotNull
    private static final Key<Boolean> IS_COMMAND_HISTORY_LOOKUP_KEY;

    public CommandHistoryPresenter(@NotNull Project project, @NotNull Editor editor, @NotNull TerminalCommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.project = project;
        this.editor = editor;
        this.commandExecutor = commandExecutor;
    }

    public final void showCommandHistory(@NotNull List<String> history) {
        String command;
        Intrinsics.checkNotNullParameter(history, (String)"history");
        String string = this.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.initialCommand = command = string;
        LookupImpl lookup = CommandHistoryUtil.INSTANCE.createLookup(this.project, this.editor, ((Object)StringsKt.trim((CharSequence)command)).toString(), CollectionsKt.asReversed(history));
        lookup.putUserData(IS_COMMAND_HISTORY_LOOKUP_KEY, (Object)true);
        lookup.addLookupListener(new LookupListener(lookup, this){
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ CommandHistoryPresenter this$0;
            {
                this.$lookup = $lookup;
                this.this$0 = $receiver;
            }

            public void currentItemChanged(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object object = event.getItem();
                if (object == null || (object = object.getLookupString()) == null) {
                    return;
                }
                Object selectedCommand = object;
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.$lookup, this.this$0, (String)selectedCommand){
                    final /* synthetic */ LookupImpl $lookup;
                    final /* synthetic */ CommandHistoryPresenter this$0;
                    final /* synthetic */ String $selectedCommand;
                    {
                        this.$lookup = $lookup;
                        this.this$0 = $receiver;
                        this.$selectedCommand = $selectedCommand;
                        super(0);
                    }

                    public final void invoke() {
                        if (!this.$lookup.isLookupDisposed()) {
                            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Boolean>(this.$lookup, this.this$0, this.$selectedCommand){
                                final /* synthetic */ LookupImpl $lookup;
                                final /* synthetic */ CommandHistoryPresenter this$0;
                                final /* synthetic */ String $selectedCommand;
                                {
                                    this.$lookup = $lookup;
                                    this.this$0 = $receiver;
                                    this.$selectedCommand = $selectedCommand;
                                    super(0);
                                }

                                @NotNull
                                public final Boolean invoke() {
                                    return this.$lookup.performGuardedChange(() -> showCommandHistory.currentItemChanged.1.invoke$lambda$0(this.this$0, this.$selectedCommand));
                                }

                                private static final void invoke$lambda$0(CommandHistoryPresenter this$0, String $selectedCommand) {
                                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                    Intrinsics.checkNotNullParameter((Object)$selectedCommand, (String)"$selectedCommand");
                                    CommandHistoryPresenter.access$getEditor$p(this$0).getDocument().setText((CharSequence)$selectedCommand);
                                    CommandHistoryPresenter.access$getEditor$p(this$0).getCaretModel().moveToOffset($selectedCommand.length());
                                }
                            }));
                        }
                    }
                }), (int)1, null);
            }

            public boolean beforeItemSelected(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return false;
            }

            public void itemSelected(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CommandHistoryPresenter.access$setInitialCommand$p(this.this$0, null);
                if (event.getCompletionChar() == '\n') {
                    TerminalCommandExecutor terminalCommandExecutor = CommandHistoryPresenter.access$getCommandExecutor$p(this.this$0);
                    String string = CommandHistoryPresenter.access$getEditor$p(this.this$0).getDocument().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    terminalCommandExecutor.startCommandExecution(string);
                }
            }

            public void lookupCanceled(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CommandHistoryPresenter.access$setInitialCommand$p(this.this$0, null);
            }
        });
        if (lookup.showLookup()) {
            lookup.ensureSelectionVisible(false);
        } else {
            CommandHistoryPresenter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CommandHistoryPresenter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to show command history");
        }
    }

    public final void onCommandHistoryClosed() {
        String commandToRestore = this.initialCommand;
        if (commandToRestore != null) {
            this.initialCommand = null;
            TerminalUiUtilsKt.invokeLater$default(TerminalUiUtilsKt.getDisposed(this.editor), null, () -> CommandHistoryPresenter.onCommandHistoryClosed$lambda$0(this, commandToRestore), 2, null);
        }
    }

    private static final void onCommandHistoryClosed$lambda$0(CommandHistoryPresenter this$0, String $commandToRestore) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this$0, $commandToRestore){
            final /* synthetic */ CommandHistoryPresenter this$0;
            final /* synthetic */ String $commandToRestore;
            {
                this.this$0 = $receiver;
                this.$commandToRestore = $commandToRestore;
                super(0);
            }

            public final void invoke() {
                CommandHistoryPresenter.access$getEditor$p(this.this$0).getDocument().setText((CharSequence)this.$commandToRestore);
                CommandHistoryPresenter.access$getEditor$p(this.this$0).getCaretModel().moveToOffset(this.$commandToRestore.length());
            }
        }));
    }

    public static final /* synthetic */ Editor access$getEditor$p(CommandHistoryPresenter $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$setInitialCommand$p(CommandHistoryPresenter $this, String string) {
        $this.initialCommand = string;
    }

    public static final /* synthetic */ TerminalCommandExecutor access$getCommandExecutor$p(CommandHistoryPresenter $this) {
        return $this.commandExecutor;
    }

    static {
        Key key = Key.create((String)"isCommandHistoryLookup");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_COMMAND_HISTORY_LOOKUP_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00020\u0005*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/exp/history/CommandHistoryPresenter$Companion;", "", "()V", "IS_COMMAND_HISTORY_LOOKUP_KEY", "Lcom/intellij/openapi/util/Key;", "", "isTerminalCommandHistory", "Lcom/intellij/codeInsight/lookup/Lookup;", "(Lcom/intellij/codeInsight/lookup/Lookup;)Z", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTerminalCommandHistory(@NotNull Lookup $this$isTerminalCommandHistory) {
            Intrinsics.checkNotNullParameter((Object)$this$isTerminalCommandHistory, (String)"<this>");
            UserDataHolder userDataHolder = $this$isTerminalCommandHistory instanceof UserDataHolder ? (UserDataHolder)$this$isTerminalCommandHistory : null;
            return userDataHolder != null ? Intrinsics.areEqual((Object)userDataHolder.getUserData(IS_COMMAND_HISTORY_LOOKUP_KEY), (Object)true) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

