/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.data;

import com.intellij.collaboration.ui.codereview.details.data.ReviewRequestState;
import git4idea.GitRemoteBranch;
import git4idea.push.GitSpecialRefRemoteBranch;
import git4idea.remote.hosting.HostedGitRepositoryRemote;
import git4idea.repo.GitRemote;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.dto.GitLabProjectDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestFullDetails;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestState;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"reviewState", "Lcom/intellij/collaboration/ui/codereview/details/data/ReviewRequestState;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestFullDetails;", "getReviewState", "(Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestFullDetails;)Lcom/intellij/collaboration/ui/codereview/details/data/ReviewRequestState;", "getSourceRemoteDescriptor", "Lgit4idea/remote/hosting/HostedGitRepositoryRemote;", "server", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "getSpecialRemoteBranchForHead", "Lgit4idea/GitRemoteBranch;", "remote", "Lgit4idea/repo/GitRemote;", "getTargetRemoteDescriptor", "isFork", "", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestFullDetailsKt {
    @NotNull
    public static final ReviewRequestState getReviewState(@NotNull GitLabMergeRequestFullDetails $this$reviewState) {
        ReviewRequestState reviewRequestState;
        Intrinsics.checkNotNullParameter((Object)$this$reviewState, (String)"<this>");
        if ($this$reviewState.getDraft()) {
            reviewRequestState = ReviewRequestState.DRAFT;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[$this$reviewState.getState().ordinal()]) {
                case 1: {
                    reviewRequestState = ReviewRequestState.CLOSED;
                    break;
                }
                case 2: {
                    reviewRequestState = ReviewRequestState.MERGED;
                    break;
                }
                case 3: {
                    reviewRequestState = ReviewRequestState.OPENED;
                    break;
                }
                default: {
                    reviewRequestState = ReviewRequestState.OPENED;
                }
            }
        }
        return reviewRequestState;
    }

    @Nullable
    public static final HostedGitRepositoryRemote getSourceRemoteDescriptor(@NotNull GitLabMergeRequestFullDetails $this$getSourceRemoteDescriptor, @NotNull GitLabServerPath server) {
        HostedGitRepositoryRemote hostedGitRepositoryRemote;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceRemoteDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        GitLabProjectDTO gitLabProjectDTO = $this$getSourceRemoteDescriptor.getSourceProject();
        if (gitLabProjectDTO != null) {
            GitLabProjectDTO it = gitLabProjectDTO;
            boolean bl = false;
            hostedGitRepositoryRemote = new HostedGitRepositoryRemote(it.getOwnerPath(), server.toURI(), it.getFullPath(), it.getHttpUrlToRepo(), it.getSshUrlToRepo());
        } else {
            hostedGitRepositoryRemote = null;
        }
        return hostedGitRepositoryRemote;
    }

    @NotNull
    public static final HostedGitRepositoryRemote getTargetRemoteDescriptor(@NotNull GitLabMergeRequestFullDetails $this$getTargetRemoteDescriptor, @NotNull GitLabServerPath server) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetRemoteDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return new HostedGitRepositoryRemote($this$getTargetRemoteDescriptor.getTargetProject().getOwnerPath(), server.toURI(), $this$getTargetRemoteDescriptor.getTargetProject().getFullPath(), $this$getTargetRemoteDescriptor.getTargetProject().getHttpUrlToRepo(), $this$getTargetRemoteDescriptor.getTargetProject().getSshUrlToRepo());
    }

    @NotNull
    public static final GitRemoteBranch getSpecialRemoteBranchForHead(@NotNull GitLabMergeRequestFullDetails $this$getSpecialRemoteBranchForHead, @NotNull GitRemote remote) {
        Intrinsics.checkNotNullParameter((Object)$this$getSpecialRemoteBranchForHead, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        return (GitRemoteBranch)new GitSpecialRefRemoteBranch("refs/merge-requests/" + $this$getSpecialRemoteBranchForHead.getIid() + "/head", remote);
    }

    public static final boolean isFork(@NotNull GitLabMergeRequestFullDetails $this$isFork) {
        Intrinsics.checkNotNullParameter((Object)$this$isFork, (String)"<this>");
        GitLabProjectDTO gitLabProjectDTO = $this$isFork.getSourceProject();
        return !Intrinsics.areEqual((Object)(gitLabProjectDTO != null ? gitLabProjectDTO.getFullPath() : null), (Object)$this$isFork.getTargetProject().getFullPath());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitLabMergeRequestState.values().length];
            try {
                nArray[GitLabMergeRequestState.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabMergeRequestState.MERGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabMergeRequestState.OPENED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

