from _typeshed import Incomplete
from typing import Any

class Query:
    def __init__(self, query_string) -> None: ...
    def query_string(self): ...
    def limit_ids(self, *ids): ...
    def return_fields(self, *fields): ...
    def return_field(self, field, as_field: Incomplete | None = None): ...
    def summarize(
        self,
        fields: Incomplete | None = None,
        context_len: Incomplete | None = None,
        num_frags: Incomplete | None = None,
        sep: Incomplete | None = None,
    ): ...
    def highlight(self, fields: Incomplete | None = None, tags: Incomplete | None = None): ...
    def language(self, language): ...
    def slop(self, slop): ...
    def in_order(self): ...
    def scorer(self, scorer): ...
    def get_args(self): ...
    def paging(self, offset, num): ...
    def verbatim(self): ...
    def no_content(self): ...
    def no_stopwords(self): ...
    def with_payloads(self): ...
    def with_scores(self): ...
    def limit_fields(self, *fields): ...
    def add_filter(self, flt): ...
    def sort_by(self, field, asc: bool = True): ...
    def expander(self, expander): ...

class Filter:
    args: Any
    def __init__(self, keyword, field, *args) -> None: ...

class NumericFilter(Filter):
    INF: str
    NEG_INF: str
    def __init__(self, field, minval, maxval, minExclusive: bool = False, maxExclusive: bool = False) -> None: ...

class GeoFilter(Filter):
    METERS: str
    KILOMETERS: str
    FEET: str
    MILES: str
    def __init__(self, field, lon, lat, radius, unit="km") -> None: ...

class SortbyField:
    args: Any
    def __init__(self, field, asc: bool = True) -> None: ...
