/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import au.com.thinkingrock.tr.resource.Icons;
import au.com.trgtd.tr.appl.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang.StringEscapeUtils;
import org.jdesktop.swingx.JXTable;
import org.openide.awt.Toolbar;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.WindowManager;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.XSLFO;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.ActionStateScheduled;
import tr.prefs.gui.GUIPrefs;
import tr.swing.StyledString;
import tr.util.HTML;
import tr.view.DeleteAction;
import tr.view.ReprocessAction;
import tr.view.Window;
import tr.view.actions.prefs.ActionsPrefs;
import tr.view.actions.screens.ActionNode;
import tr.view.actions.screens.ActionsProvider;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.ColumnsDialog;
import tr.view.actions.screens.FiltersDialog;
import tr.view.actions.screens.ItemCountShower;
import tr.view.actions.screens.ReviewActionsFilters;
import tr.view.actions.screens.ReviewActionsPanel;
import tr.view.actions.screens.SetDoneAction;
import tr.view.actions.screens.filters.ActionsFilter;
import tr.view.contexts.ContextChangeAction;
import tr.view.projects.PostponeActionAction;
import tr.view.topics.TopicChangeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReviewActionsTopComponent
extends Window
implements ActionsProvider,
ItemCountShower {
    private static final String PREFERRED_ID = "ReviewActionsTopComponent";
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private final ComponentListener windowListener = new WindowListener();
    private final InstanceContent content = new InstanceContent();
    private final ActionsScreen screen;
    private final ReviewActionsFilters filters;
    private ReviewActionsPanel panel;
    private JToolBar toolbar;
    private JToggleButton viewFiltersButton;
    private JButton editFiltersButton;
    private JButton editColumnsButton;
    private JButton pdfButton;
    private JSplitPane splitPane;
    private Lookup lookup;
    private Lookup.Result dataLookupResult;
    private boolean activated;
    private static final DateFormat DF = new SimpleDateFormat("dd MMM yyyy");
    private static final String EOL = "\r\n";

    private ReviewActionsTopComponent(ActionsScreen screen) {
        this.screen = screen;
        this.filters = new ReviewActionsFilters(screen);
        this.setName(screen.toString());
        this.setToolTipText(NbBundle.getMessage(ReviewActionsTopComponent.class, (String)"TTT_ReviewActionsTopComponent"));
        this.setIcon(Icons.Actions.getImage());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized ReviewActionsTopComponent createInstance(ActionsScreen screen) {
        return new ReviewActionsTopComponent(screen);
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentOpened() {
        super.componentOpened();
        if (this.panel == null) {
            this.removeAll();
            this.getToolBar();
            String position = GUIPrefs.getButtonsPosition();
            if (position.equals("top")) {
                this.toolbar.setOrientation(0);
                this.add(this.toolbar, "North");
            } else if (position.equals("bottom")) {
                this.toolbar.setOrientation(0);
                this.add(this.toolbar, "South");
            } else if (position.equals("left")) {
                this.toolbar.setOrientation(1);
                this.add(this.toolbar, "West");
            } else if (position.equals("right")) {
                this.toolbar.setOrientation(1);
                this.add(this.toolbar, "East");
            }
            this.panel = new ReviewActionsPanel(this.screen, this, this.filters, this, this);
            this.splitPane = new JSplitPane();
            this.splitPane.setOrientation(0);
            this.splitPane.setTopComponent(this.filters.getPanel());
            this.splitPane.setBottomComponent(this.panel);
            this.splitPane.setBorder(BorderFactory.createEmptyBorder());
            this.splitPane.setDividerSize(0);
            this.splitPane.setDividerLocation(0);
            this.add(this.splitPane, "Center");
        }
        this.panel.refresh();
        if (this.dataLookupResult == null) {
            this.dataLookupResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.dataLookupResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ReviewActionsTopComponent.this.removeAll();
                    if (ReviewActionsTopComponent.this.panel != null) {
                        ReviewActionsTopComponent.this.panel.save();
                        ReviewActionsTopComponent.this.panel = null;
                    }
                }
            });
        }
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.panel != null) {
            this.panel.view();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ReviewActionsTopComponent.this.showHideFilters();
                if (ReviewActionsTopComponent.this.panel != null) {
                    ReviewActionsTopComponent.this.panel.takeFocus();
                }
            }
        });
        this.activated = true;
    }

    protected void componentClosed() {
        this.removeAll();
        if (this.activated && this.panel != null) {
            this.panel.save();
        }
        super.componentClosed();
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public Lookup getLookup() {
        if (this.panel == null) {
            return super.getLookup();
        }
        if (this.lookup == null) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.content);
            this.content.set(Collections.singleton(this.panel), null);
        }
        return this.lookup;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("review.actions");
    }

    @Override
    public void showItemCount(final int count) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ReviewActionsTopComponent.this.setName(ReviewActionsTopComponent.this.screen.toString() + " (" + count + ")");
            }
        });
    }

    private JToolBar getToolBar() {
        if (this.toolbar == null) {
            SystemAction[] actions = new SystemAction[]{null, SystemAction.get(ReprocessAction.class), SystemAction.get(PostponeActionAction.class), SystemAction.get(ContextChangeAction.class), SystemAction.get(TopicChangeAction.class), SystemAction.get(SetDoneAction.class), SystemAction.get(DeleteAction.class)};
            this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
            this.viewFiltersButton = new JToggleButton();
            this.viewFiltersButton.setSelected(this.screen.isShowFilters());
            this.viewFiltersButton.setAction(new ViewFiltersAction());
            this.toolbar.add((Component)this.viewFiltersButton, 0);
            this.editFiltersButton = new JButton(new EditFiltersAction());
            this.toolbar.add((Component)this.editFiltersButton, 0);
            this.editColumnsButton = new JButton(new EditColumnsAction());
            this.toolbar.add((Component)this.editColumnsButton, 0);
            this.pdfButton = new JButton(new PDFAction());
            this.toolbar.add((Component)this.pdfButton, 0);
            this.toolbar.setUI(new Toolbar().getUI());
            this.toolbar.setFloatable(false);
            Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
            for (Component component : this.toolbar.getComponents()) {
                if (!(component instanceof AbstractButton)) continue;
                component.setPreferredSize(buttonSize);
                component.setMinimumSize(buttonSize);
                component.setMaximumSize(buttonSize);
                component.setSize(buttonSize);
            }
        }
        return this.toolbar;
    }

    private void showHideFilters() {
        if (this.viewFiltersButton.isSelected()) {
            this.splitPane.setDividerLocation(this.getFiltersHeight());
        } else {
            this.splitPane.setDividerLocation(0);
        }
    }

    private synchronized int getFiltersHeight() {
        try {
            int n;
            if (n <= 0) {
                return 0;
            }
            int tw = this.panel.getWidth();
            if (tw <= 0) {
                return 0;
            }
            int cw = this.filters.getComponentWidth() + 1;
            if (cw <= 0) {
                return 0;
            }
            int ch = this.filters.getComponentHeight() + 1;
            if (ch <= 0) {
                return 0;
            }
            int h = 2;
            for (n = this.filters.getPanel().getComponentCount(); n > 0; n -= tw / cw) {
                h += ch;
            }
            return h;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private void printPDF() throws Exception {
        String prefix = "tr-actions-screen-";
        String timestamp = Extract.getTimeStamp();
        File xmlfile = Extract.getTmpFile((String)(prefix + timestamp + ".xml"));
        File outfile = Extract.getOutFile((String)(prefix + timestamp + ".pdf"));
        URL xslfo = this.getClass().getResource("tr-actions-screen.fo.xml");
        Vector<Param> params = new Vector<Param>();
        params.add(new Param("font", ActionsPrefs.getReportFont()));
        this.extractData(xmlfile);
        XSLFO.transform((File)xmlfile, (InputStream)xslfo.openStream(), params, (File)outfile);
        Extract.openFile((File)outfile);
    }

    private void extractData(File xmlfile) throws Exception {
        TableColumn tc;
        int i;
        boolean useColour = ActionsPrefs.isReportUseColour();
        boolean strikeDone = ActionsPrefs.isReportStrikeDone();
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        out.write("<actions-screen>\r\n");
        Calendar calendar = Calendar.getInstance();
        out.write("<date>" + DF.format(calendar.getTime()) + "</date>" + EOL);
        out.write("<title>" + this.escape(this.getName()) + "</title>" + EOL);
        if (this.viewFiltersButton.isSelected()) {
            out.write("<filters>\r\n");
            for (ActionsFilter filter : this.screen.getFilters()) {
                Object value = filter.getFilterCombo().getSelectedItem();
                if (value == null) continue;
                out.write("<filter>\r\n");
                out.write("<label>" + this.escape(filter.getLabel()) + "</label>" + EOL);
                out.write("<value>" + this.escape(value.toString()) + "</value>" + EOL);
                out.write("</filter>\r\n");
            }
            out.write("</filters>\r\n");
        }
        out.write("<table>\r\n");
        out.write("<widths>\r\n");
        JXTable table = this.panel.actionsTable;
        TableColumnModel tcm = table.getColumnModel();
        float totalWidth = table.getColumnModel().getTotalColumnWidth();
        totalWidth -= (float)((tcm.getColumnCount() - 1) * 2);
        for (i = 0; i < tcm.getColumnCount(); ++i) {
            tc = tcm.getColumn(i);
            int width = (int)((float)tc.getWidth() / totalWidth * 277.0f);
            out.write("<column>" + width + "mm" + "</column>" + EOL);
        }
        out.write("</widths>\r\n");
        out.write("<headings>\r\n");
        for (i = 0; i < tcm.getColumnCount(); ++i) {
            tc = tcm.getColumn(i);
            int col = tcm.getColumn(i).getModelIndex();
            Class<?> clazz = table.getModel().getColumnClass(col);
            if (clazz == Boolean.class || clazz == Icon.class) {
                out.write("<column></column>\r\n");
                continue;
            }
            out.write("<column>" + this.escape(tc.getHeaderValue().toString()) + "</column>" + EOL);
        }
        out.write("</headings>\r\n");
        int rows = table.getModel().getRowCount();
        int cols = table.getModel().getColumnCount();
        for (int row = 0; row < rows; ++row) {
            out.write("<row>\r\n");
            for (int i2 = 0; i2 < tcm.getColumnCount(); ++i2) {
                int col = tcm.getColumn(i2).getModelIndex();
                Object value = table.getModel().getValueAt(row, col);
                String fg = "black";
                String bg = "white";
                boolean strike = false;
                if (value instanceof StyledString) {
                    StyledString ss = (StyledString)value;
                    if (useColour) {
                        fg = HTML.format((Color)ss.getForeground());
                        bg = HTML.format((Color)ss.getBackground());
                    }
                    if (strikeDone) {
                        strike = ss.isStrike();
                    }
                }
                String type = "";
                String symbol = "";
                if (value instanceof Boolean) {
                    type = "boolean";
                } else if (value instanceof Icon) {
                    type = "icon";
                    if (col == 0) {
                        symbol = this.getType((Action)this.panel.actionsSortedList.get(row));
                    } else if (col == 12) {
                        symbol = this.getFromType((Action)this.panel.actionsSortedList.get(row));
                    }
                }
                out.write("<col type='" + type + "' symbol='" + symbol + "' fg='" + fg + "' bg='" + bg + "' strike='" + Boolean.toString(strike) + "'>" + (value == null ? "" : this.escape(value.toString())) + "</col>" + EOL);
            }
            out.write("</row>\r\n");
        }
        out.write("</table>\r\n");
        out.write("</actions-screen>\r\n");
        out.close();
    }

    private String escape(String string) {
        return StringEscapeUtils.escapeXml((String)string);
    }

    private String getType(Action action) {
        if (action.isStateASAP()) {
            return "doasap";
        }
        if (action.isStateDelegated()) {
            return "delegated";
        }
        if (action.isStateScheduled()) {
            ActionStateScheduled ss = (ActionStateScheduled)action.getState();
            return ss.getRecurrence() == null ? "scheduled" : "recurrent";
        }
        if (action.isStateInactive()) {
            return "inactive";
        }
        return "";
    }

    private String getFromType(Action action) {
        if (action.isSingleAction()) {
            return action.getThought() == null ? "" : "thought";
        }
        return action.getParent() == null ? "" : "project";
    }

    protected void componentHidden() {
        super.componentHidden();
        JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
        frame.removeComponentListener(this.windowListener);
    }

    protected void componentShowing() {
        super.componentShowing();
        JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
        frame.addComponentListener(this.windowListener);
    }

    @Override
    public void provide(final List<Action> actions) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Vector<Object> collection = new Vector<Object>();
                if (ReviewActionsTopComponent.this.panel != null) {
                    collection.add(ReviewActionsTopComponent.this.panel);
                }
                if (actions != null) {
                    for (Action action : actions) {
                        collection.add(new ActionNode(action));
                    }
                }
                ReviewActionsTopComponent.this.content.set(collection, null);
            }
        });
    }

    public class WindowListener
    implements ComponentListener {
        private static final int DELAY = 1000;
        private final Timer timer;

        public WindowListener() {
            this.timer = new Timer(1000, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    WindowListener.this.doAction();
                }
            });
            this.timer.setRepeats(false);
        }

        private void doAction() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ReviewActionsTopComponent.this.showHideFilters();
                }
            });
        }

        public void componentResized(ComponentEvent e) {
            this.timer.start();
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }
    }

    private class PDFAction
    extends AbstractAction {
        public PDFAction() {
            super("", Icons.PDF);
            this.putValue("ShortDescription", NbBundle.getMessage(this.getClass(), (String)"CTL_PDFAction"));
        }

        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ReviewActionsTopComponent.this.printPDF();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    private class EditColumnsAction
    extends AbstractAction {
        public EditColumnsAction() {
            super("", Icons.ColumnsEdit);
            this.putValue("ShortDescription", NbBundle.getMessage(this.getClass(), (String)"CTL_EditColumnsAction"));
        }

        public void actionPerformed(final ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ColumnsDialog dialog = new ColumnsDialog(ReviewActionsTopComponent.this.screen);
                    dialog.setLocationRelativeTo((Component)e.getSource());
                    dialog.setVisible(true);
                    ReviewActionsTopComponent.this.panel.refreshColumns();
                    ReviewActionsTopComponent.this.panel.validate();
                    ReviewActionsTopComponent.this.panel.repaint();
                }
            });
        }
    }

    private class EditFiltersAction
    extends AbstractAction {
        public EditFiltersAction() {
            super("", Icons.FiltersEdit);
            this.putValue("ShortDescription", NbBundle.getMessage(this.getClass(), (String)"CTL_EditFiltersAction"));
        }

        public void actionPerformed(final ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FiltersDialog dialog = new FiltersDialog(ReviewActionsTopComponent.this.screen);
                    dialog.setLocationRelativeTo((Component)e.getSource());
                    int result = dialog.showDialog();
                    if (result == 0) {
                        ReviewActionsTopComponent.this.panel.refresh();
                        ReviewActionsTopComponent.this.splitPane.setTopComponent(ReviewActionsTopComponent.this.filters.getPanel(true));
                        ReviewActionsTopComponent.this.showHideFilters();
                    }
                }
            });
        }
    }

    private class ViewFiltersAction
    extends AbstractAction {
        public ViewFiltersAction() {
            super("", Icons.FiltersView);
            this.putValue("ShortDescription", NbBundle.getMessage(this.getClass(), (String)"CTL_ViewFiltersAction"));
        }

        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ReviewActionsTopComponent.this.screen.setShowFilters(ReviewActionsTopComponent.this.viewFiltersButton.isSelected());
                    ReviewActionsTopComponent.this.showHideFilters();
                }
            });
        }
    }
}

