/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.AdjustmentException;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2ServerHelloParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2ServerHelloPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.SSL2ServerHelloSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.util.CertificateUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.tls.Certificate;

public class SSL2ServerHelloHandler
extends HandshakeMessageHandler<SSL2ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ServerHelloHandler(TlsContext context) {
        super(context);
    }

    @Override
    public SSL2ServerHelloParser getParser(byte[] message, int pointer) {
        return new SSL2ServerHelloParser(message, pointer, this.tlsContext.getChooser().getSelectedProtocolVersion(), this.tlsContext.getConfig());
    }

    public SSL2ServerHelloPreparator getPreparator(SSL2ServerHelloMessage message) {
        return new SSL2ServerHelloPreparator(this.tlsContext.getChooser(), message);
    }

    public SSL2ServerHelloSerializer getSerializer(SSL2ServerHelloMessage message) {
        return new SSL2ServerHelloSerializer(message, this.tlsContext);
    }

    private Certificate parseCertificate(int lengthBytes, byte[] bytesToParse) {
        LOGGER.debug("SSL2 lengthBytes:" + lengthBytes);
        LOGGER.debug("SSL2 bytesToParse:" + ArrayConverter.bytesToHexString((byte[])bytesToParse, (boolean)false));
        try {
            byte[] concatenated = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)(lengthBytes + 3), (int)3), ArrayConverter.intToBytes((int)lengthBytes, (int)3), bytesToParse});
            LOGGER.debug("SSL2 concatenated:" + ArrayConverter.bytesToHexString((byte[])concatenated, (boolean)false));
            ByteArrayInputStream stream = new ByteArrayInputStream(concatenated);
            return Certificate.parse((InputStream)stream);
        }
        catch (IOException | IllegalArgumentException E) {
            LOGGER.warn("Could not parse Certificate bytes into Certificate object:\n" + ArrayConverter.bytesToHexString((byte[])bytesToParse, (boolean)false));
            LOGGER.debug((Object)E);
            return null;
        }
    }

    @Override
    public void adjustTLSContext(SSL2ServerHelloMessage message) {
        byte[] serverRandom = (byte[])message.getSessionId().getValue();
        if (serverRandom != null) {
            this.tlsContext.setServerRandom(serverRandom);
        }
        Certificate cert = this.parseCertificate((Integer)message.getCertificateLength().getValue(), (byte[])message.getCertificate().getValue());
        LOGGER.debug("Setting ServerCertificate in Context");
        this.tlsContext.setServerCertificate(cert);
        if (cert == null || !CertificateUtils.hasRSAParameters(cert)) {
            LOGGER.error("Cannot parse Certificate from SSL2ServerHello");
        } else {
            LOGGER.debug("Adjusting RSA PublicKey");
            try {
                this.tlsContext.setServerRSAPublicKey(CertificateUtils.extractRSAPublicKey(cert));
                this.tlsContext.setServerRsaModulus(CertificateUtils.extractRSAModulus(cert));
            }
            catch (IOException e) {
                throw new AdjustmentException("Could not adjust PublicKey Information from Certificate", e);
            }
        }
    }
}

